/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailetcontainer;

import jakarta.mail.MessagingException;
import java.util.Arrays;
import java.util.Optional;
import org.apache.james.core.MailAddress;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.field.ContentTypeField;
import org.apache.james.mime4j.field.ContentTypeFieldLenientImpl;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.RawField;
import org.apache.mailet.Mail;
import org.apache.mailet.base.AutomaticallySentMailDetector;

public class AutomaticallySentMailDetectorImpl
implements AutomaticallySentMailDetector {
    private static final String[] MAILING_LIST_HEADERS = new String[]{"List-Help", "List-Subscribe", "List-Unsubscribe", "List-Owner", "List-Post", "List-Id", "List-Archive"};

    public boolean isAutomaticallySent(Mail mail) throws MessagingException {
        return !mail.hasSender() || this.isMailingList(mail) || this.isAutoSubmitted(mail) || this.isMdnSentAutomatically(mail);
    }

    public boolean isMailingList(Mail mail) throws MessagingException {
        return this.senderIsMailingList(mail) || this.headerIsMailingList(mail);
    }

    private boolean senderIsMailingList(Mail mail) {
        return mail.getMaybeSender().asOptional().map(MailAddress::getLocalPart).map(localPart -> localPart.startsWith("owner-") || localPart.endsWith("-request") || localPart.equalsIgnoreCase("MAILER-DAEMON") || localPart.equalsIgnoreCase("LISTSERV") || localPart.equalsIgnoreCase("majordomo")).orElse(false);
    }

    private boolean headerIsMailingList(Mail mail) throws MessagingException {
        return mail.getMessage().getMatchingHeaders(MAILING_LIST_HEADERS).hasMoreElements();
    }

    public boolean isAutoSubmitted(Mail mail) throws MessagingException {
        String[] headers = mail.getMessage().getHeader("Auto-Submitted");
        if (headers != null) {
            return Arrays.stream(headers).anyMatch(this::isAutoSubmitted);
        }
        return false;
    }

    private boolean isAutoSubmitted(String header) {
        return header.equalsIgnoreCase("auto-replied") || header.equalsIgnoreCase("auto-generated") || header.equalsIgnoreCase("auto-notified");
    }

    public boolean isMdnSentAutomatically(Mail mail) throws MessagingException {
        return Optional.ofNullable(mail.getMessage().getContentType()).map(field -> (ContentTypeField)ContentTypeFieldLenientImpl.PARSER.parse((Field)new RawField("Content-Type", field), DecodeMonitor.SILENT)).map(ContentTypeField::getMimeType).stream().anyMatch("multipart/report"::equals);
    }
}

