/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.quota.mailing.events;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaLimitValue;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.core.quota.QuotaUsageValue;
import org.apache.james.mailbox.model.Quota;

public record QuotaDTO(@JsonProperty(value="used") long used, @JsonProperty(value="limit") Optional<Long> limit) {
    @JsonIgnore
    public static QuotaDTO from(Quota<?, ?> quota) {
        if (quota.getLimit().isUnlimited()) {
            return new QuotaDTO(quota.getUsed().asLong(), Optional.empty());
        }
        return new QuotaDTO(quota.getUsed().asLong(), Optional.of(quota.getLimit().asLong()));
    }

    @JsonIgnore
    public Quota<QuotaSizeLimit, QuotaSizeUsage> asSizeQuota() {
        return Quota.builder().used((QuotaUsageValue)QuotaSizeUsage.size((long)this.used)).computedLimit((QuotaLimitValue)QuotaSizeLimit.size(this.limit)).build();
    }

    @JsonIgnore
    public Quota<QuotaCountLimit, QuotaCountUsage> asCountQuota() {
        return Quota.builder().used((QuotaUsageValue)QuotaCountUsage.count((long)this.used)).computedLimit((QuotaLimitValue)QuotaCountLimit.count(this.limit)).build();
    }
}

