/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.data;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.adapter.mailbox.DelegationStoreAuthorizator;
import org.apache.james.backends.cassandra.components.CassandraDataDefinition;
import org.apache.james.mailbox.Authorizator;
import org.apache.james.server.core.configuration.ConfigurationProvider;
import org.apache.james.user.api.DelegationStore;
import org.apache.james.user.api.DelegationUsernameChangeTaskStep;
import org.apache.james.user.api.UsernameChangeTaskStep;
import org.apache.james.user.cassandra.CassandraDelegationStore;
import org.apache.james.user.cassandra.CassandraRepositoryConfiguration;
import org.apache.james.user.cassandra.CassandraUsersDAO;
import org.apache.james.user.cassandra.CassandraUsersRepositoryDataDefinition;

public class CassandraDelegationStoreModule
extends AbstractModule {
    public void configure() {
        this.bind(DelegationStore.class).to(CassandraDelegationStore.class);
        this.bind(CassandraDelegationStore.UserExistencePredicate.class).to(CassandraDelegationStore.UserExistencePredicateImplementation.class);
        this.bind(Authorizator.class).to(DelegationStoreAuthorizator.class);
        Multibinder cassandraDataDefinitions = Multibinder.newSetBinder((Binder)this.binder(), CassandraDataDefinition.class);
        cassandraDataDefinitions.addBinding().toInstance((Object)CassandraUsersRepositoryDataDefinition.MODULE);
        Multibinder.newSetBinder((Binder)this.binder(), UsernameChangeTaskStep.class).addBinding().to(DelegationUsernameChangeTaskStep.class);
        this.bind(CassandraUsersDAO.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    public CassandraRepositoryConfiguration provideConfiguration(ConfigurationProvider configurationProvider) throws ConfigurationException {
        return CassandraRepositoryConfiguration.from((HierarchicalConfiguration)configurationProvider.getConfiguration("usersrepository"));
    }
}

