/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.codec.Codec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;

final class PrimitiveCodec<T>
implements Codec<Object> {
    private final Class<?> primitiveType;
    private final Class<T> wrapperType;
    private final Codec<T> boxedCodec;

    public PrimitiveCodec(Class<?> primitiveType, Class<T> wrapperType, Codec<T> boxedCodec) {
        this.primitiveType = Assert.requireNonNull(primitiveType, "primitiveType must not be null");
        this.wrapperType = Assert.requireNonNull(wrapperType, "wrapperType must not be null");
        this.boxedCodec = Assert.requireNonNull(boxedCodec, "boxedCodec must not be null");
        Assert.isTrue(primitiveType.isPrimitive(), "primitiveType must be a primitive type");
    }

    @Override
    public boolean canDecode(int dataType, Format format, Class<?> type) {
        return this.primitiveType.equals(type) && this.boxedCodec.canDecode(dataType, format, this.wrapperType);
    }

    @Override
    public boolean canEncode(Object value) {
        return this.boxedCodec.canEncode(value);
    }

    @Override
    public boolean canEncodeNull(Class<?> type) {
        return this.primitiveType.equals(type) && this.boxedCodec.canEncodeNull(this.wrapperType);
    }

    @Override
    public Object decode(ByteBuf buffer, int dataType, Format format, Class<?> type) {
        T value = this.boxedCodec.decode(buffer, dataType, format, this.wrapperType);
        if (value == null) {
            throw new NullPointerException("value for primitive type " + this.primitiveType.getName() + " is null");
        }
        return value;
    }

    @Override
    public EncodedParameter encode(Object value) {
        return this.boxedCodec.encode(value);
    }

    @Override
    public EncodedParameter encode(Object value, int dataType) {
        return this.boxedCodec.encode(value, dataType);
    }

    @Override
    public EncodedParameter encodeNull() {
        return this.boxedCodec.encodeNull();
    }
}

