/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.codec.ArrayCodecDelegate;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.codec.StringCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import java.util.function.Function;
import reactor.util.annotation.Nullable;

class StringCodecDelegate<T>
extends AbstractCodec<T>
implements ArrayCodecDelegate<T> {
    private final StringCodec delegate;
    private final Function<T, String> toTextEncoder;
    private final Function<String, T> fromTextDecoder;

    StringCodecDelegate(Class<T> type, ByteBufAllocator byteBufAllocator, Function<T, String> toTextEncoder, Function<String, T> fromTextDecoder) {
        super(type);
        this.delegate = new StringCodec(byteBufAllocator);
        this.toTextEncoder = Assert.requireNonNull(toTextEncoder, "toTextEncoder must not be null");
        this.fromTextDecoder = Assert.requireNonNull(fromTextDecoder, "fromTextDecoder must not be null");
    }

    @Override
    public final EncodedParameter encodeNull() {
        return this.delegate.encodeNull();
    }

    @Override
    final boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        return this.delegate.doCanDecode(type, format);
    }

    @Override
    final T doDecode(ByteBuf buffer, PostgresTypeIdentifier dataType, @Nullable Format format, @Nullable Class<? extends T> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        return this.fromTextDecoder.apply(((String)this.delegate.doDecode(buffer, dataType, format, String.class)).trim());
    }

    @Override
    final EncodedParameter doEncode(T value) {
        Assert.requireNonNull(value, "value must not be null");
        return this.delegate.doEncode(this.encodeToText(value));
    }

    @Override
    final EncodedParameter doEncode(T value, PostgresTypeIdentifier dataType) {
        Assert.requireNonNull(value, "value must not be null");
        return this.delegate.doEncode(this.encodeToText(value), dataType);
    }

    @Override
    public final String encodeToText(T value) {
        Assert.requireNonNull(value, "value must not be null");
        return this.toTextEncoder.apply(value);
    }

    @Override
    public final PostgresTypeIdentifier getArrayDataType() {
        return PostgresqlObjectId.VARCHAR_ARRAY;
    }

    @Override
    public Iterable<Format> getFormats() {
        return this.delegate.getFormats();
    }

    @Override
    public Iterable<PostgresTypeIdentifier> getDataTypes() {
        return this.delegate.getDataTypes();
    }
}

