/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.CharsetUtil;
import io.r2dbc.postgresql.util.Assert;

public final class ByteBufUtils {
    private ByteBufUtils() {
    }

    public static String decode(ByteBuf byteBuf) {
        Assert.requireNonNull(byteBuf, "byteBuf must not be null");
        return byteBuf.readCharSequence(byteBuf.readableBytes(), CharsetUtil.UTF_8).toString();
    }

    public static ByteBuf encode(ByteBufAllocator byteBufAllocator, CharSequence s) {
        Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        Assert.requireNonNull(s, "s must not be null");
        ByteBuf byteBuf = byteBufAllocator.buffer();
        byteBuf.writeCharSequence(s, CharsetUtil.UTF_8);
        return byteBuf;
    }
}

