/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.postgres.user;

import org.apache.james.backends.postgres.PostgresDataDefinition;
import org.apache.james.backends.postgres.PostgresIndex;
import org.apache.james.backends.postgres.PostgresTable;
import org.jooq.Constraint;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

public interface PostgresSubscriptionDataDefinition {
    public static final Field<String> MAILBOX = DSL.field((String)"mailbox", (DataType)SQLDataType.VARCHAR((int)255).notNull());
    public static final Field<String> USER = DSL.field((String)"user_name", (DataType)SQLDataType.VARCHAR((int)255).notNull());
    public static final Table<Record> TABLE_NAME = DSL.table((String)"subscription");
    public static final PostgresTable TABLE = PostgresTable.name((String)TABLE_NAME.getName()).createTableStep((dsl, tableName) -> dsl.createTableIfNotExists(tableName).column(MAILBOX).column(USER).constraint((Constraint)DSL.unique((Field[])new Field[]{MAILBOX, USER}))).supportsRowLevelSecurity().build();
    public static final PostgresIndex INDEX = PostgresIndex.name((String)"subscription_user_index").createIndexStep((dsl, indexName) -> dsl.createIndexIfNotExists(indexName).on(TABLE_NAME, new OrderField[]{USER}));
    public static final PostgresDataDefinition MODULE = PostgresDataDefinition.builder().addTable(new PostgresTable[]{TABLE}).addIndex(new PostgresIndex[]{INDEX}).build();
}

