/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;

@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public abstract class ReplaceCertificateExtendedResult
extends ExtendedResult {
    private static final byte TYPE_TOOL_OUTPUT = -111;
    private static final long serialVersionUID = -4865907062468450991L;
    @Nullable
    private final String toolOutput;

    protected ReplaceCertificateExtendedResult(@NotNull ExtendedResult extendedResult) throws LDAPException {
        super(extendedResult);
        String output = null;
        ASN1OctetString value = extendedResult.getValue();
        if (value != null) {
            try {
                for (ASN1Element element : ASN1Sequence.decodeAsSequence(value.getValue()).elements()) {
                    switch (element.getType()) {
                        case -111: {
                            output = element.decodeAsOctetString().stringValue();
                        }
                    }
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_REPLACE_CERT_RESULT_CANNOT_DECODE_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
            }
        }
        this.toolOutput = output;
    }

    protected ReplaceCertificateExtendedResult(int messageID, @NotNull ResultCode resultCode, @Nullable String diagnosticMessage, @Nullable String matchedDN, @Nullable String[] referralURLs, @Nullable String oid, @Nullable String toolOutput, Control ... responseControls) {
        super(messageID, resultCode, diagnosticMessage, matchedDN, referralURLs, oid, ReplaceCertificateExtendedResult.encodeValue(oid, toolOutput), responseControls);
        this.toolOutput = toolOutput;
    }

    @Nullable
    public static ASN1OctetString encodeValue(@Nullable String oid, @Nullable String toolOutput) {
        if (oid == null && toolOutput == null) {
            return null;
        }
        ArrayList<ASN1OctetString> valueElements = new ArrayList<ASN1OctetString>(1);
        if (toolOutput != null) {
            valueElements.add(new ASN1OctetString(-111, toolOutput));
        }
        ASN1Sequence valueSequence = new ASN1Sequence(valueElements);
        return new ASN1OctetString(valueSequence.encode());
    }

    @Nullable
    public String getToolOutput() {
        return this.toolOutput;
    }

    @Override
    public final void toString(@NotNull StringBuilder buffer) {
        Control[] responseControls;
        String oid;
        String[] referralURLs;
        String matchedDN;
        String diagnosticMessage;
        buffer.append("ReplaceCertificateExtendedResult(resultCode=");
        buffer.append(this.getResultCode());
        int messageID = this.getMessageID();
        if (messageID >= 0) {
            buffer.append(", messageID=");
            buffer.append(messageID);
        }
        if ((diagnosticMessage = this.getDiagnosticMessage()) != null) {
            buffer.append(", diagnosticMessage='");
            buffer.append(diagnosticMessage);
            buffer.append('\'');
        }
        if ((matchedDN = this.getMatchedDN()) != null) {
            buffer.append(", matchedDN='");
            buffer.append(matchedDN);
            buffer.append('\'');
        }
        if ((referralURLs = this.getReferralURLs()).length > 0) {
            buffer.append(", referralURLs={");
            for (int i = 0; i < referralURLs.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append('\'');
                buffer.append(referralURLs[i]);
                buffer.append('\'');
            }
            buffer.append('}');
        }
        if ((oid = this.getOID()) != null) {
            buffer.append(", oid='");
            buffer.append(oid);
            buffer.append('\'');
        }
        if (this.toolOutput != null) {
            buffer.append(", toolOutput='");
            ReplaceCertificateExtendedResult.escapeOutput(this.toolOutput, buffer);
            buffer.append('\'');
        }
        if ((responseControls = this.getResponseControls()).length > 0) {
            buffer.append(", responseControls={");
            for (int i = 0; i < responseControls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(responseControls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }

    private static void escapeOutput(@NotNull String toolOutput, @NotNull StringBuilder buffer) {
        block7: for (char c : toolOutput.toCharArray()) {
            switch (c) {
                case '\\': {
                    buffer.append("\\\\");
                    continue block7;
                }
                case '\n': {
                    buffer.append("\\n");
                    continue block7;
                }
                case '\r': {
                    buffer.append("\\r");
                    continue block7;
                }
                case '\'': {
                    buffer.append("\\'");
                    continue block7;
                }
                case '\"': {
                    buffer.append("\\\"");
                    continue block7;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
    }
}

