/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.NormalScope;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.New;
import javax.enterprise.inject.Stereotype;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.util.Nonbinding;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Qualifier;
import javax.inject.Scope;
import javax.interceptor.InterceptorBinding;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.inject.DefinitionException;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.ArrayUtil;
import org.apache.webbeans.util.Asserts;

public final class AnnotationManager {
    private Map<Class<? extends Annotation>, Boolean> checkedQualifierAnnotations = new ConcurrentHashMap<Class<? extends Annotation>, Boolean>();
    private Map<Class<? extends Annotation>, Boolean> checkedStereotypeAnnotations = new ConcurrentHashMap<Class<? extends Annotation>, Boolean>();
    private final BeanManagerImpl beanManagerImpl;
    private final WebBeansContext webBeansContext;
    private static final Annotation[] ONLY_DEFAULT_ANNOTATION = new Annotation[1];

    public AnnotationManager(WebBeansContext context) {
        this.webBeansContext = context;
        this.beanManagerImpl = context.getBeanManagerImpl();
    }

    public Annotation getDeclaredScopeAnnotation(Class<?> beanClass) {
        for (Annotation annotation : beanClass.getDeclaredAnnotations()) {
            if (!this.beanManagerImpl.isScope(annotation.annotationType())) continue;
            return annotation;
        }
        return null;
    }

    public boolean isInterceptorBindingAnnotation(Class<? extends Annotation> clazz) {
        Asserts.nullCheckForClass(clazz);
        return clazz.isAnnotationPresent(InterceptorBinding.class) || this.webBeansContext.getInterceptorsManager().hasInterceptorBindingType(clazz);
    }

    public Set<Annotation> getInterceptorAnnotations(Set<Annotation> typeAnns) {
        Annotation[] stereoTypes;
        Annotation[] anns;
        HashMap<Class<? extends Annotation>, Annotation> bindings = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation ann : anns = this.getInterceptorBindingMetaAnnotations(typeAnns)) {
            Annotation oldBinding = (Annotation)bindings.get(ann.annotationType());
            if (oldBinding != null && !AnnotationUtil.isCdiAnnotationEqual(oldBinding, ann)) {
                throw new WebBeansConfigurationException("Illegal interceptor binding: annotation of type " + ann.annotationType().getName() + " is present twice with diffenent values: " + oldBinding.toString() + " and " + ann.toString());
            }
            bindings.put(ann.annotationType(), ann);
        }
        for (Annotation stereoType : stereoTypes = this.getStereotypeMetaAnnotations(typeAnns.toArray(new Annotation[typeAnns.size()]))) {
            Annotation[] steroInterceptorBindings;
            if (!this.hasInterceptorBindingMetaAnnotation(stereoType.annotationType().getDeclaredAnnotations())) continue;
            for (Annotation ann : steroInterceptorBindings = this.getInterceptorBindingMetaAnnotations(stereoType.annotationType().getDeclaredAnnotations())) {
                Annotation oldBinding = (Annotation)bindings.get(ann.annotationType());
                if (oldBinding != null && !AnnotationUtil.isCdiAnnotationEqual(oldBinding, ann)) {
                    throw new WebBeansConfigurationException("Illegal interceptor binding: annotation of type " + ann.annotationType().getName() + " is present twice with diffenent values: " + oldBinding.toString() + " and " + ann.toString());
                }
                bindings.put(ann.annotationType(), ann);
            }
        }
        return new HashSet<Annotation>(bindings.values());
    }

    public boolean hasInterceptorBindingMetaAnnotation(Annotation[] anns) {
        Asserts.assertNotNull(anns, "anns parameter can not be null");
        for (Annotation ann : anns) {
            if (!this.isInterceptorBindingAnnotation(ann.annotationType())) continue;
            return true;
        }
        return false;
    }

    public Annotation[] getInterceptorBindingMetaAnnotations(Set<Annotation> anns) {
        return this.getInterceptorBindingMetaAnnotations(AnnotationUtil.asArray(anns));
    }

    public Annotation[] getInterceptorBindingMetaAnnotations(Annotation[] anns) {
        Asserts.assertNotNull(anns, "anns parameter can not be null");
        ArrayList<Annotation> interAnns = new ArrayList<Annotation>();
        for (Annotation ann : anns) {
            if (!this.isInterceptorBindingAnnotation(ann.annotationType())) continue;
            interAnns.add(ann);
            Annotation[] transitives = this.getInterceptorBindingMetaAnnotations(ann.annotationType().getDeclaredAnnotations());
            Collections.addAll(interAnns, transitives);
        }
        Annotation[] ret = new Annotation[interAnns.size()];
        ret = interAnns.toArray(ret);
        return ret;
    }

    public boolean isQualifierAnnotation(Class<? extends Annotation> clazz) {
        Boolean checkedAnnotationResult = this.checkedQualifierAnnotations.get(clazz);
        if (checkedAnnotationResult != null) {
            return checkedAnnotationResult;
        }
        boolean result = false;
        Asserts.nullCheckForClass(clazz);
        if (clazz.isAnnotationPresent(Qualifier.class)) {
            result = true;
        } else if (this.beanManagerImpl.getAdditionalQualifiers().contains(clazz)) {
            result = true;
        }
        this.checkedQualifierAnnotations.put(clazz, result);
        return result;
    }

    public <X> Annotation[] getAnnotatedMethodFirstParameterQualifierWithGivenAnnotation(AnnotatedMethod<X> annotatedMethod, Class<? extends Annotation> clazz) {
        Asserts.assertNotNull(annotatedMethod, "annotatedMethod argument can not be null");
        Asserts.nullCheckForClass(clazz);
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        List parameters = annotatedMethod.getParameters();
        for (AnnotatedParameter parameter : parameters) {
            Annotation[] anns;
            if (!parameter.isAnnotationPresent(clazz)) continue;
            for (Annotation ann : anns = AnnotationUtil.asArray(parameter.getAnnotations())) {
                if (!this.isQualifierAnnotation(ann.annotationType())) continue;
                list.add(ann);
            }
        }
        Annotation[] finalAnns = new Annotation[list.size()];
        finalAnns = list.toArray(finalAnns);
        return finalAnns;
    }

    public Annotation[] getMethodFirstParameterQualifierWithGivenAnnotation(Method method, Class<? extends Annotation> clazz) {
        Asserts.assertNotNull(method, "Method argument can not be null");
        Asserts.nullCheckForClass(clazz);
        Annotation[][] parameterAnns = method.getParameterAnnotations();
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        for (Annotation[] parameters : parameterAnns) {
            boolean found = false;
            for (Annotation param : parameters) {
                Class<? extends Annotation> btype = param.annotationType();
                if (btype.equals(clazz)) {
                    found = true;
                    continue;
                }
                if (!this.isQualifierAnnotation(btype)) continue;
                list.add(param);
            }
            if (!found) continue;
            Annotation[] result = new Annotation[list.size()];
            result = list.toArray(result);
            return result;
        }
        Annotation[] result = AnnotationUtil.EMPTY_ANNOTATION_ARRAY;
        return result;
    }

    public Set<Annotation> getQualifierAnnotations(Set<Annotation> annotations) {
        return new HashSet<Annotation>(Arrays.asList(this.getQualifierAnnotations(annotations.toArray(new Annotation[annotations.size()]))));
    }

    public Annotation[] getQualifierAnnotations(Annotation ... annotations) {
        Asserts.assertNotNull(annotations, "Annotations argument can not be null");
        if (annotations.length == 0) {
            return ONLY_DEFAULT_ANNOTATION;
        }
        HashSet<Annotation> set = new HashSet<Annotation>();
        for (Annotation annot : annotations) {
            if (!this.isQualifierAnnotation(annot.annotationType())) continue;
            set.add(annot);
        }
        if (set.size() == 0) {
            return ONLY_DEFAULT_ANNOTATION;
        }
        Annotation[] a = new Annotation[set.size()];
        a = set.toArray(a);
        return a;
    }

    public void checkQualifierConditions(Annotation ... qualifierAnnots) {
        Set<Annotation> annSet = ArrayUtil.asSet(qualifierAnnots);
        if (qualifierAnnots.length != annSet.size()) {
            throw new IllegalArgumentException("Qualifier annotations can not contain duplicate qualifiers:" + Arrays.toString(qualifierAnnots));
        }
        this.checkQualifierConditions(annSet);
    }

    public void checkQualifierConditions(Set<Annotation> qualifierAnnots) {
        for (Annotation ann : qualifierAnnots) {
            this.checkQualifierConditions(ann);
        }
    }

    private void checkQualifierConditions(Annotation ann) {
        Method[] methods;
        for (Method method : methods = this.webBeansContext.getSecurityService().doPrivilegedGetDeclaredMethods(ann.annotationType())) {
            Class<?> clazz = method.getReturnType();
            if (!clazz.isArray() && !clazz.isAnnotation() || AnnotationUtil.hasAnnotation(method.getDeclaredAnnotations(), Nonbinding.class)) continue;
            throw new WebBeansConfigurationException("@Qualifier : " + ann.annotationType().getName() + " must have @NonBinding valued members for its array-valued and annotation valued members");
        }
        if (!this.isQualifierAnnotation(ann.annotationType())) {
            throw new IllegalArgumentException("Qualifier annotations must be annotated with @Qualifier");
        }
    }

    public boolean isStereoTypeAnnotation(Class<? extends Annotation> clazz) {
        return this.isStereoTypeAnnotation(clazz, new HashSet<Class<? extends Annotation>>());
    }

    private boolean isStereoTypeAnnotation(Class<? extends Annotation> clazz, Set<Class<? extends Annotation>> checkedAnnotations) {
        Asserts.nullCheckForClass(clazz);
        Boolean checkedAnnotationResult = this.checkedStereotypeAnnotations.get(clazz);
        if (checkedAnnotationResult != null) {
            return checkedAnnotationResult;
        }
        boolean result = false;
        if (clazz.isAnnotationPresent(Stereotype.class)) {
            result = true;
        } else {
            for (Annotation annotation : clazz.getAnnotations()) {
                if (checkedAnnotations.contains(annotation.annotationType())) continue;
                checkedAnnotations.add(annotation.annotationType());
                if (!this.isStereoTypeAnnotation(annotation.annotationType(), checkedAnnotations)) continue;
                result = true;
                break;
            }
        }
        this.checkedStereotypeAnnotations.put(clazz, result);
        return result;
    }

    public boolean hasStereoTypeMetaAnnotation(Set<Class<? extends Annotation>> anns) {
        Asserts.assertNotNull(anns, "anns parameter can not be null");
        for (Class<? extends Annotation> ann : anns) {
            if (!this.isStereoTypeAnnotation(ann)) continue;
            return true;
        }
        return false;
    }

    public boolean hasStereoTypeMetaAnnotation(Annotation[] anns) {
        Asserts.assertNotNull(anns, "anns parameter can not be null");
        for (Annotation ann : anns) {
            if (!this.isStereoTypeAnnotation(ann.annotationType())) continue;
            return true;
        }
        return false;
    }

    public Annotation[] getStereotypeMetaAnnotations(Annotation[] anns) {
        Asserts.assertNotNull(anns, "anns parameter can not be null");
        ArrayList<Annotation> interAnns = new ArrayList<Annotation>();
        for (Annotation ann : anns) {
            if (!this.isStereoTypeAnnotation(ann.annotationType())) continue;
            interAnns.add(ann);
            Annotation[] transitives = this.getTransitiveStereoTypes(ann.annotationType().getDeclaredAnnotations());
            Collections.addAll(interAnns, transitives);
        }
        Annotation[] ret = new Annotation[interAnns.size()];
        ret = interAnns.toArray(ret);
        return ret;
    }

    public Set<Class<? extends Annotation>> getStereotypeMetaAnnotations(Set<Class<? extends Annotation>> stereotypes) {
        Asserts.assertNotNull(stereotypes, "anns parameter can not be null");
        HashSet<Class<? extends Annotation>> interAnns = new HashSet<Class<? extends Annotation>>();
        for (Class<? extends Annotation> ann : stereotypes) {
            Annotation[] transitives;
            if (!this.isStereoTypeAnnotation(ann)) continue;
            interAnns.add(ann);
            for (Annotation transitive : transitives = this.getTransitiveStereoTypes(ann.getDeclaredAnnotations())) {
                interAnns.add(transitive.annotationType());
            }
        }
        return interAnns;
    }

    private Annotation[] getTransitiveStereoTypes(Annotation[] anns) {
        return this.getStereotypeMetaAnnotations(anns);
    }

    public Set<Class<? extends Annotation>> getStereotypes(Set<Class<? extends Annotation>> anns) {
        Asserts.assertNotNull(anns, "bean parameter can not be null");
        if (this.hasStereoTypeMetaAnnotation(anns)) {
            return this.getStereotypeMetaAnnotations(anns);
        }
        return Collections.emptySet();
    }

    public boolean hasNamedOnStereoTypes(Set<Class<? extends Annotation>> stereotypes) {
        Set<Class<? extends Annotation>> types = this.getStereotypes(stereotypes);
        for (Class<? extends Annotation> ann : types) {
            if (!AnnotationUtil.hasClassAnnotation(ann, Named.class)) continue;
            return true;
        }
        return false;
    }

    public void checkStereoTypeClass(Class<? extends Annotation> clazz, Annotation ... annotations) {
        Asserts.nullCheckForClass(clazz);
        boolean scopeTypeFound = false;
        for (Annotation annotation : annotations) {
            Named name;
            Class<? extends Annotation> annotType = annotation.annotationType();
            if (annotType.isAnnotationPresent(NormalScope.class) || annotType.isAnnotationPresent(Scope.class)) {
                if (scopeTypeFound) {
                    throw new WebBeansConfigurationException("@StereoType annotation can not contain more than one @Scope/@NormalScope annotation");
                }
                scopeTypeFound = true;
                continue;
            }
            if (!annotType.equals(Named.class) || (name = (Named)annotation).value().equals("")) continue;
            throw new WebBeansConfigurationException("@StereoType annotation can not define @Named annotation with value");
        }
    }

    public void checkInterceptorResolverParams(Annotation ... interceptorBindings) {
        if (interceptorBindings == null || interceptorBindings.length == 0) {
            throw new IllegalArgumentException("Manager.resolveInterceptors() method parameter interceptor bindings array argument can not be empty");
        }
        Annotation old = null;
        for (Annotation interceptorBinding : interceptorBindings) {
            if (!this.isInterceptorBindingAnnotation(interceptorBinding.annotationType())) {
                throw new IllegalArgumentException("Manager.resolveInterceptors() method parameter interceptor bindings array can not contain other annotation that is not @InterceptorBinding");
            }
            if (old == null) {
                old = interceptorBinding;
                continue;
            }
            if (old.equals(interceptorBinding)) {
                throw new IllegalArgumentException("Manager.resolveInterceptors() method parameter interceptor bindings array argument can not define duplicate binding annotation with name : @" + old.getClass().getName());
            }
            old = interceptorBinding;
        }
    }

    public void checkDecoratorResolverParams(Set<Type> apiTypes, Annotation ... qualifiers) {
        if (apiTypes == null || apiTypes.size() == 0) {
            throw new IllegalArgumentException("Manager.resolveDecorators() method parameter api types argument can not be empty");
        }
        Annotation old = null;
        for (Annotation qualifier : qualifiers) {
            if (!this.isQualifierAnnotation(qualifier.annotationType())) {
                throw new IllegalArgumentException("Manager.resolveDecorators() method parameter qualifiers array can not contain other annotation that is not @Qualifier");
            }
            if (old == null) {
                old = qualifier;
                continue;
            }
            if (old.annotationType().equals(qualifier.annotationType())) {
                throw new IllegalArgumentException("Manager.resolveDecorators() method parameter qualifiers array argument can not define duplicate qualifier annotation with name : @" + old.annotationType().getName());
            }
            old = qualifier;
        }
    }

    public Annotation[] checkForNewQualifierForDeployment(Type type, Class<?> clazz, String name, Annotation[] annotations) {
        Asserts.assertNotNull(type, "Type argument can not be null");
        Asserts.nullCheckForClass(clazz);
        Asserts.assertNotNull(annotations, "Annotations argument can not be null");
        Annotation[] as = this.getQualifierAnnotations(annotations);
        for (Annotation a : annotations) {
            if (!a.annotationType().equals(New.class) || as.length <= 1) continue;
            throw new WebBeansConfigurationException("@New binding annotation can not have any binding annotation in class : " + clazz.getName() + " in field/method : " + name);
        }
        return as;
    }

    public boolean isSuperMethodNamed(AbstractOwbBean<?> component, Method method, Method superMethod) {
        Asserts.assertNotNull(component, "component parameter can not be null");
        Asserts.assertNotNull(method, "method parameter can not be null");
        Asserts.assertNotNull(superMethod, "superMethod parameter can not be null");
        boolean hasName = false;
        if (AnnotationUtil.hasMethodAnnotation(superMethod, Named.class)) {
            hasName = true;
        } else {
            Annotation[] anns;
            for (Annotation ann : anns = this.getStereotypeMetaAnnotations(superMethod.getAnnotations())) {
                if (!ann.annotationType().isAnnotationPresent(Stereotype.class)) continue;
                hasName = true;
                break;
            }
        }
        if (hasName && AnnotationUtil.hasMethodAnnotation(method, Named.class)) {
            throw new DefinitionException("Specialized method : " + method.getName() + " in class : " + component.getReturnType().getName() + " may not define @Named annotation");
        }
        return hasName;
    }

    public <X> Method getDisposalWithGivenAnnotatedMethod(AnnotatedType<X> annotatedType, Type beanType, Annotation[] qualifiers) {
        Set annotatedMethods = annotatedType.getMethods();
        if (annotatedMethods != null) {
            for (AnnotatedMethod annotatedMethod : annotatedMethods) {
                AnnotatedMethod annt = annotatedMethod;
                List parameters = annt.getParameters();
                if (parameters == null) continue;
                boolean found = false;
                for (AnnotatedParameter parameter : parameters) {
                    if (!parameter.isAnnotationPresent(Disposes.class)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                Type type = AnnotationUtil.getAnnotatedMethodFirstParameterWithAnnotation(annotatedMethod, Disposes.class);
                Annotation[] annots = this.getAnnotatedMethodFirstParameterQualifierWithGivenAnnotation(annotatedMethod, Disposes.class);
                if (!type.equals(beanType)) continue;
                for (Annotation qualifier : qualifiers) {
                    if (qualifier.annotationType() == Default.class) continue;
                    for (Annotation ann : annots) {
                        if (AnnotationUtil.isCdiAnnotationEqual(qualifier, ann)) continue;
                        return null;
                    }
                }
                return annotatedMethod.getJavaMember();
            }
        }
        return null;
    }

    public void checkInjectionPointForInjectInjectionPoint(Class<?> clazz) {
        Field[] fields;
        Asserts.nullCheckForClass(clazz);
        for (Field field : fields = this.webBeansContext.getSecurityService().doPrivilegedGetDeclaredFields(clazz)) {
            Annotation[] anns;
            if (field.getAnnotation(Inject.class) == null || field.getType() != InjectionPoint.class || !AnnotationUtil.hasAnnotation(anns = this.getQualifierAnnotations(field.getDeclaredAnnotations()), Default.class)) continue;
            throw new WebBeansConfigurationException("Java EE Component class :  " + clazz + " can not inject InjectionPoint");
        }
    }

    static {
        AnnotationManager.ONLY_DEFAULT_ANNOTATION[0] = DefaultLiteral.INSTANCE;
    }
}

