/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component.creation;

import javax.enterprise.inject.spi.AnnotatedType;
import org.apache.webbeans.component.BeanAttributesImpl;
import org.apache.webbeans.component.ManagedBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.WebBeansUtil;

public class ManagedBeanBuilder<T, M extends ManagedBean<T>> {
    protected final WebBeansContext webBeansContext;
    protected final AnnotatedType<T> annotatedType;
    protected final BeanAttributesImpl<T> beanAttributes;

    public ManagedBeanBuilder(WebBeansContext webBeansContext, AnnotatedType<T> annotatedType, BeanAttributesImpl<T> beanAttributes) {
        Asserts.assertNotNull(webBeansContext, "webBeansContext may not be null");
        Asserts.assertNotNull(annotatedType, "annotated type may not be null");
        Asserts.assertNotNull(beanAttributes, "beanAttributes may not be null");
        this.webBeansContext = webBeansContext;
        this.annotatedType = annotatedType;
        this.beanAttributes = beanAttributes;
    }

    public M getBean() {
        ManagedBean<T> bean = new ManagedBean<T>(this.webBeansContext, WebBeansType.MANAGED, this.annotatedType, this.beanAttributes, this.annotatedType.getJavaClass());
        bean.setEnabled(this.webBeansContext.getWebBeansUtil().isBeanEnabled(this.annotatedType, bean.getStereotypes()));
        this.webBeansContext.getWebBeansUtil().checkManagedBeanCondition(this.annotatedType);
        WebBeansUtil.checkGenericType(this.annotatedType.getJavaClass(), this.beanAttributes.getScope());
        this.webBeansContext.getDeploymentValidationService().validateProxyable(bean);
        return (M)bean;
    }
}

