/*
 * Decompiled with CFR 0.152.
 */
package brave.propagation;

import brave.internal.Nullable;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;

public final class StrictScopeDecorator
implements CurrentTraceContext.ScopeDecorator {
    public static CurrentTraceContext.ScopeDecorator create() {
        return new StrictScopeDecorator();
    }

    @Override
    public CurrentTraceContext.Scope decorateScope(@Nullable TraceContext currentSpan, CurrentTraceContext.Scope scope) {
        return new StrictScope(scope, new Error(String.format("Thread %s opened scope for %s here:", Thread.currentThread().getName(), currentSpan)));
    }

    StrictScopeDecorator() {
    }

    static final class StrictScope
    implements CurrentTraceContext.Scope {
        final CurrentTraceContext.Scope delegate;
        final Throwable caller;
        final long threadId = Thread.currentThread().getId();

        StrictScope(CurrentTraceContext.Scope delegate, Throwable caller) {
            this.delegate = delegate;
            this.caller = caller;
        }

        @Override
        public void close() {
            if (Thread.currentThread().getId() != this.threadId) {
                throw new IllegalStateException("scope closed in a different thread: " + Thread.currentThread().getName(), this.caller);
            }
            this.delegate.close();
        }

        public String toString() {
            return this.caller.toString();
        }
    }
}

