/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.Ordered;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.reactive.function.BodyExtractors;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class WebClientWriteResponseFilter
implements GlobalFilter,
Ordered {
    private static final Log log = LogFactory.getLog(WebClientWriteResponseFilter.class);
    public static final int WRITE_RESPONSE_FILTER_ORDER = -1;

    public int getOrder() {
        return -1;
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        return chain.filter(exchange).then(Mono.defer(() -> {
            ClientResponse clientResponse = (ClientResponse)exchange.getAttribute(ServerWebExchangeUtils.CLIENT_RESPONSE_ATTR);
            if (clientResponse == null) {
                return Mono.empty();
            }
            log.trace((Object)"WebClientWriteResponseFilter start");
            ServerHttpResponse response = exchange.getResponse();
            return response.writeWith((Publisher)clientResponse.body(BodyExtractors.toDataBuffers())).log("webClient response");
        }));
    }
}

