/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.aggregate;

import java.util.HashSet;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.reader.MetricReader;
import org.springframework.boot.actuate.metrics.repository.InMemoryMetricRepository;
import org.springframework.util.StringUtils;

public class AggregateMetricReader
implements MetricReader {
    private MetricReader source;
    private String keyPattern = "d.d";
    private String prefix = "aggregate.";

    public AggregateMetricReader(MetricReader source) {
        this.source = source;
    }

    public void setKeyPattern(String keyPattern) {
        this.keyPattern = keyPattern;
    }

    public void setPrefix(String prefix) {
        if (StringUtils.hasText((String)prefix) && !prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        this.prefix = prefix;
    }

    @Override
    public Metric<?> findOne(String metricName) {
        if (!metricName.startsWith(this.prefix)) {
            return null;
        }
        InMemoryMetricRepository result = new InMemoryMetricRepository();
        String baseName = metricName.substring(this.prefix.length());
        for (Metric<?> metric : this.source.findAll()) {
            String name = this.getSourceKey(metric.getName());
            if (!baseName.equals(name)) continue;
            this.update(result, name, metric);
        }
        return result.findOne(metricName);
    }

    @Override
    public Iterable<Metric<?>> findAll() {
        InMemoryMetricRepository result = new InMemoryMetricRepository();
        for (Metric<?> metric : this.source.findAll()) {
            String key = this.getSourceKey(metric.getName());
            if (key == null) continue;
            this.update(result, key, metric);
        }
        return result.findAll();
    }

    @Override
    public long count() {
        HashSet<String> names = new HashSet<String>();
        for (Metric<?> metric : this.source.findAll()) {
            String name = this.getSourceKey(metric.getName());
            if (name == null) continue;
            names.add(name);
        }
        return names.size();
    }

    private void update(InMemoryMetricRepository result, String key, Metric<?> metric) {
        String name = this.prefix + key;
        Metric<Object> aggregate = result.findOne(name);
        if (aggregate == null) {
            aggregate = new Metric(name, metric.getValue(), metric.getTimestamp());
        } else if (key.contains("counter.")) {
            aggregate = new Metric<Long>(name, metric.increment(((Number)aggregate.getValue()).intValue()).getValue(), metric.getTimestamp());
        } else if (aggregate.getTimestamp().before(metric.getTimestamp())) {
            aggregate = new Metric(name, metric.getValue(), metric.getTimestamp());
        }
        result.set(aggregate);
    }

    private String getSourceKey(String name) {
        int i;
        String[] keys = StringUtils.delimitedListToStringArray((String)name, (String)".");
        String[] patterns = StringUtils.delimitedListToStringArray((String)this.keyPattern, (String)".");
        StringBuilder builder = new StringBuilder();
        for (i = 0; i < patterns.length; ++i) {
            if (!"k".equals(patterns[i])) continue;
            builder.append(builder.length() > 0 ? "." : "");
            builder.append(keys[i]);
        }
        for (i = patterns.length; i < keys.length; ++i) {
            builder.append(builder.length() > 0 ? "." : "");
            builder.append(keys[i]);
        }
        return builder.toString();
    }
}

