/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.server;

import io.netty.buffer.ByteBuf;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.parsetools.RecordParser;
import java.io.UnsupportedEncodingException;
import org.apache.servicecomb.foundation.vertx.server.TcpBufferHandler;

public class TcpParser
implements Handler<Buffer> {
    public static final byte[] TCP_MAGIC;
    public static final int TCP_HEADER_LENGTH = 23;
    private TcpBufferHandler outputHandler;
    private RecordParser parser;
    private ParseStatus status;
    private long msgId;
    private int totalLen;
    private int headerLen;

    public TcpParser(TcpBufferHandler output) {
        this.outputHandler = output;
        this.reset();
    }

    protected void reset() {
        this.parser = RecordParser.newFixed((int)23, this::onParse);
        this.status = ParseStatus.TCP_HEADER;
        this.parser.handle(Buffer.buffer((int)0));
    }

    public boolean firstNEqual(byte[] a, byte[] b, int n) {
        assert (a.length >= n && b.length >= n);
        for (int i = 0; i < n; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    protected void onParse(Buffer buffer) {
        switch (this.status) {
            case TCP_HEADER: {
                ByteBuf buf = buffer.getByteBuf();
                if (!this.firstNEqual(TCP_MAGIC, buf.array(), TCP_MAGIC.length)) {
                    this.reset();
                    return;
                }
                buf.skipBytes(TCP_MAGIC.length);
                this.msgId = buf.readLong();
                this.totalLen = buf.readInt();
                this.headerLen = buf.readInt();
                if (this.totalLen == 0) {
                    this.onReadOnePackage(null, null);
                    return;
                }
                this.parser.fixedSizeMode(this.totalLen);
                this.status = ParseStatus.TCP_PAYLOAD;
                break;
            }
            case TCP_PAYLOAD: {
                Buffer headerBuffer = buffer.slice(0, this.headerLen);
                Buffer bodyBuffer = buffer.slice(this.headerLen, buffer.length());
                this.onReadOnePackage(headerBuffer, bodyBuffer);
                break;
            }
        }
    }

    private void onReadOnePackage(Buffer headerBuffer, Buffer bodyBuffer) {
        this.outputHandler.handle(this.msgId, headerBuffer, bodyBuffer);
        this.parser.fixedSizeMode(23);
        this.status = ParseStatus.TCP_HEADER;
    }

    public void handle(Buffer buf) {
        this.parser.handle(buf);
    }

    static {
        try {
            TCP_MAGIC = "CSE.TCP".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    static enum ParseStatus {
        TCP_HEADER,
        TCP_PAYLOAD;

    }
}

