/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.publish;

import org.apache.servicecomb.foundation.common.net.NetUtils;
import org.apache.servicecomb.foundation.common.utils.StringBuilderUtils;
import org.apache.servicecomb.foundation.metrics.publish.spectator.MeasurementNode;
import org.apache.servicecomb.foundation.metrics.publish.spectator.MeasurementTree;
import org.apache.servicecomb.metrics.core.publish.AbstractMeasurementNodeLogPublisher;

public class ServerEndpointsLogPublisher
extends AbstractMeasurementNodeLogPublisher {
    public ServerEndpointsLogPublisher(MeasurementTree tree, StringBuilder sb, String meterName) {
        super(tree, sb, "servicecomb.vertx.endpoints", meterName);
    }

    @Override
    public void print(boolean printDetail) {
        StringBuilderUtils.appendLine((StringBuilder)this.sb, (String)"    server.endpoints:", (Object[])new Object[0]);
        StringBuilderUtils.appendLine((StringBuilder)this.sb, (String)"      listen                connectCount disconnectCount rejectByLimit connections send(Bps) receive(Bps)", (Object[])new Object[0]);
        double connect = 0.0;
        double disconnect = 0.0;
        double reject = 0.0;
        double connections = 0.0;
        double readSize = 0.0;
        double writeSize = 0.0;
        for (MeasurementNode address : this.measurementNode.getChildren().values()) {
            connect += address.findChild("connectCount").summary();
            disconnect += address.findChild("disconnectCount").summary();
            reject += address.findChild("rejectByConnectionLimit").summary();
            connections += address.findChild("connections").summary();
            readSize += address.findChild("bytesRead").summary();
            writeSize += address.findChild("bytesWritten").summary();
            if (!printDetail) continue;
            StringBuilderUtils.appendLine((StringBuilder)this.sb, (String)"      %-21s %-12.0f %-15.0f %-13.0f %-11.0f %-9s %s", (Object[])new Object[]{address.getName(), address.findChild("connectCount").summary(), address.findChild("disconnectCount").summary(), address.findChild("rejectByConnectionLimit").summary(), address.findChild("connections").summary(), NetUtils.humanReadableBytes((long)((long)address.findChild("bytesWritten").summary())), NetUtils.humanReadableBytes((long)((long)address.findChild("bytesRead").summary()))});
        }
        StringBuilderUtils.appendLine((StringBuilder)this.sb, (String)"      %-21s %-12.0f %-15.0f %-13.0f %-11.0f %-9s %s", (Object[])new Object[]{"(summary)", connect, disconnect, reject, connections, NetUtils.humanReadableBytes((long)((long)writeSize)), NetUtils.humanReadableBytes((long)((long)readSize))});
    }
}

