/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.context;

import com.netflix.zuul.context.RequestContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;

public class Debug {
    public static void setDebugRequest(boolean bDebug) {
        RequestContext.getCurrentContext().setDebugRequest(bDebug);
    }

    public static void setDebugRequestHeadersOnly(boolean bHeadersOnly) {
        RequestContext.getCurrentContext().setDebugRequestHeadersOnly(bHeadersOnly);
    }

    public static boolean debugRequestHeadersOnly() {
        return RequestContext.getCurrentContext().debugRequestHeadersOnly();
    }

    public static void setDebugRouting(boolean bDebug) {
        RequestContext.getCurrentContext().setDebugRouting(bDebug);
    }

    public static boolean debugRequest() {
        return RequestContext.getCurrentContext().debugRequest();
    }

    public static boolean debugRouting() {
        return RequestContext.getCurrentContext().debugRouting();
    }

    public static void addRoutingDebug(String line) {
        List<String> rd = Debug.getRoutingDebug();
        rd.add(line);
    }

    public static List<String> getRoutingDebug() {
        ArrayList rd = (ArrayList)RequestContext.getCurrentContext().get("routingDebug");
        if (rd == null) {
            rd = new ArrayList();
            RequestContext.getCurrentContext().set("routingDebug", rd);
        }
        return rd;
    }

    public static void addRequestDebug(String line) {
        List<String> rd = Debug.getRequestDebug();
        rd.add(line);
    }

    public static List<String> getRequestDebug() {
        ArrayList rd = (ArrayList)RequestContext.getCurrentContext().get("requestDebug");
        if (rd == null) {
            rd = new ArrayList();
            RequestContext.getCurrentContext().set("requestDebug", rd);
        }
        return rd;
    }

    public static void compareContextState(String filterName, RequestContext copy) {
        RequestContext context = RequestContext.getCurrentContext();
        Iterator it = ((ConcurrentHashMap.KeySetView)context.keySet()).iterator();
        String key = (String)it.next();
        while (key != null) {
            if (!key.equals("routingDebug") && !key.equals("requestDebug")) {
                Object newValue = context.get(key);
                Object oldValue = copy.get(key);
                if (oldValue == null && newValue != null) {
                    Debug.addRoutingDebug("{" + filterName + "} added " + key + "=" + newValue.toString());
                } else if (oldValue != null && newValue != null && !oldValue.equals(newValue)) {
                    Debug.addRoutingDebug("{" + filterName + "} changed " + key + "=" + newValue.toString());
                }
            }
            if (it.hasNext()) {
                key = (String)it.next();
                continue;
            }
            key = null;
        }
    }

    @RunWith(value=MockitoJUnitRunner.class)
    public static class UnitTest {
        @Test
        public void testRequestDebug() {
            Assert.assertFalse((boolean)Debug.debugRouting());
            Assert.assertFalse((boolean)Debug.debugRequest());
            Debug.setDebugRouting(true);
            Debug.setDebugRequest(true);
            Assert.assertTrue((boolean)Debug.debugRouting());
            Assert.assertTrue((boolean)Debug.debugRequest());
            Debug.addRoutingDebug("test1");
            Assert.assertTrue((boolean)Debug.getRoutingDebug().contains("test1"));
            Debug.addRequestDebug("test2");
            Assert.assertTrue((boolean)Debug.getRequestDebug().contains("test2"));
        }
    }
}

