/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.metrics;

import com.netflix.servo.MonitorRegistry;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.tag.SmallTagMap;
import com.netflix.servo.tag.Tags;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.netflix.metrics.MetricsTagProvider;
import org.springframework.cloud.netflix.metrics.servo.ServoMonitorCache;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class MetricsHandlerInterceptor
extends HandlerInterceptorAdapter {
    @Value(value="${netflix.metrics.rest.metricName:rest}")
    String metricName;
    @Value(value="${netflix.metrics.rest.callerHeader:#{null}}")
    String callerHeader;
    @Autowired
    MonitorRegistry registry;
    @Autowired
    ServoMonitorCache servoMonitorCache;
    @Autowired
    Collection<MetricsTagProvider> tagProviders;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        RequestContextHolder.getRequestAttributes().setAttribute("requestStartTime", (Object)System.nanoTime(), 0);
        return super.preHandle(request, response, handler);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        RequestContextHolder.getRequestAttributes().setAttribute("exception", (Object)ex, 0);
        Long startTime = (Long)RequestContextHolder.getRequestAttributes().getAttribute("requestStartTime", 0);
        if (startTime != null) {
            this.recordMetric(request, response, handler, startTime);
        }
        super.afterCompletion(request, response, handler, ex);
    }

    protected void recordMetric(HttpServletRequest request, HttpServletResponse response, Object handler, Long startTime) {
        String caller = null;
        if (this.callerHeader != null) {
            caller = request.getHeader(this.callerHeader);
        }
        SmallTagMap.Builder builder = SmallTagMap.builder();
        for (MetricsTagProvider tagProvider : this.tagProviders) {
            Map<String, String> tags = tagProvider.httpRequestTags(request, response, handler, caller);
            for (Map.Entry<String, String> tag : tags.entrySet()) {
                builder.add(Tags.newTag((String)tag.getKey(), (String)tag.getValue()));
            }
        }
        MonitorConfig.Builder monitorConfigBuilder = MonitorConfig.builder((String)this.metricName);
        monitorConfigBuilder.withTags(builder);
        this.servoMonitorCache.getTimer(monitorConfigBuilder.build()).record(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
    }
}

