/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.any;

import io.protostuff.InputEx;
import io.protostuff.OutputEx;
import io.protostuff.compiler.model.Field;
import io.protostuff.runtime.FieldSchema;
import java.io.IOException;
import org.apache.servicecomb.foundation.common.utils.bean.Getter;
import org.apache.servicecomb.foundation.common.utils.bean.Setter;
import org.apache.servicecomb.foundation.protobuf.ProtoMapper;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;
import org.apache.servicecomb.foundation.protobuf.internal.schema.any.AnyEntrySchema;

public class AnySchema<T>
extends FieldSchema<T> {
    private final AnyEntrySchema anyEntrySchema;
    private final Getter<T, Object> getter;
    private final Setter<T, Object> setter;

    public AnySchema(ProtoMapper protoMapper, Field protoField, PropertyDescriptor propertyDescriptor) {
        super(protoField, propertyDescriptor.getJavaType());
        this.anyEntrySchema = new AnyEntrySchema(protoMapper);
        this.getter = (Getter)propertyDescriptor.getGetter();
        this.setter = (Setter)propertyDescriptor.getSetter();
    }

    @Override
    public final int mergeFrom(InputEx input, T message) throws IOException {
        Object anyValue = this.anyEntrySchema.deseriaze(input);
        this.setter.set(message, anyValue);
        return input.readFieldNumber();
    }

    @Override
    public void getAndWriteTo(OutputEx output, T message) throws IOException {
        Object anyEntry = this.getter.get(message);
        if (anyEntry == null) {
            return;
        }
        output.writeObject(this.tag, this.tagSize, anyEntry, this.anyEntrySchema);
    }

    @Override
    public final void writeTo(OutputEx output, Object value) throws IOException {
        output.writeObject(this.tag, this.tagSize, value, this.anyEntrySchema);
    }
}

