/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.servo;

import io.reactivex.netty.servo.ServoUtils;
import java.util.concurrent.atomic.AtomicInteger;

public class RefCountingMonitor {
    protected final String monitorId;
    private final AtomicInteger subscriptionCount = new AtomicInteger();

    public RefCountingMonitor(String monitorId) {
        this.monitorId = monitorId;
    }

    public void onCompleted(Object monitor) {
        if (this.subscriptionCount.decrementAndGet() == 0) {
            ServoUtils.unregisterObject(this.monitorId, monitor);
        }
    }

    public void onSubscribe(Object monitor) {
        if (this.subscriptionCount.getAndIncrement() == 0) {
            ServoUtils.registerObject(this.monitorId, monitor);
        }
    }
}

