/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.utils;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.foundation.common.utils.SPIEnabled;
import org.apache.servicecomb.foundation.common.utils.SPIOrder;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.context.ApplicationContext;

public final class BeanUtils {
    private static ApplicationContext context;

    private BeanUtils() {
    }

    public static ApplicationContext getContext() {
        return context;
    }

    public static void setContext(ApplicationContext applicationContext) {
        context = applicationContext;
    }

    public static <T> T getBean(String name) {
        return (T)context.getBean(name);
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> type) {
        if (context == null) {
            return Collections.emptyMap();
        }
        return context.getBeansOfType(type);
    }

    public static <T> T getBean(Class<T> type) {
        if (context == null) {
            return null;
        }
        return (T)context.getBean(type);
    }

    public static Class<?> getImplClassFromBean(Object bean) {
        return AopProxyUtils.ultimateTargetClass((Object)bean);
    }

    public static <T extends SPIOrder & SPIEnabled> void addBeans(Class<T> cls, List<T> exists) {
        if (context == null) {
            return;
        }
        for (SPIOrder instance : exists) {
            context.getAutowireCapableBeanFactory().autowireBean((Object)instance);
        }
        for (SPIOrder bean : context.getBeansOfType(cls).values()) {
            if (!((SPIEnabled)bean).enabled()) continue;
            exists.add(bean);
        }
        exists.sort(Comparator.comparingInt(rec$ -> ((SPIOrder)rec$).getOrder()));
    }
}

