/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.edge.core;

import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.config.ConfigurationChangedEvent;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.filter.AbstractFilter;
import org.apache.servicecomb.core.filter.EdgeFilter;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.transport.rest.client.RestClientTransportContext;
import org.springframework.core.env.Environment;

public class EdgeAddHeaderFilter
extends AbstractFilter
implements EdgeFilter {
    public static final String NAME = "edge-add-headers";
    private static final String PREFIX = "servicecomb.edge.filter.addHeader";
    private static final String KEY_HEADERS = "servicecomb.edge.filter.addHeader.allowedHeaders";
    private final Environment environment;
    private List<String> publicHeaders = new ArrayList<String>();

    public EdgeAddHeaderFilter(Environment environment) {
        this.environment = environment;
        this.init();
        EventManager.register((Object)((Object)this));
    }

    @Subscribe
    public void onConfigurationChangedEvent(ConfigurationChangedEvent event) {
        for (String changed : event.getChanged()) {
            if (!changed.startsWith(PREFIX)) continue;
            this.init();
            break;
        }
    }

    private void init() {
        String publicHeaderStr = this.environment.getProperty(KEY_HEADERS);
        if (StringUtils.isEmpty((CharSequence)publicHeaderStr)) {
            return;
        }
        this.publicHeaders = Arrays.asList(publicHeaderStr.split(","));
    }

    public String getName() {
        return NAME;
    }

    public boolean enabledForTransport(String transport) {
        return "rest".equals(transport);
    }

    public int getOrder() {
        return 1995;
    }

    public CompletableFuture<Response> onFilter(Invocation invocation, FilterNode nextNode) {
        if (this.publicHeaders.isEmpty()) {
            return nextNode.onFilter(invocation);
        }
        RestClientTransportContext transportContext = (RestClientTransportContext)invocation.getTransportContext();
        HttpServletRequestEx oldRequest = invocation.getRequestEx();
        this.publicHeaders.forEach(key -> {
            String value = oldRequest.getHeader(key);
            if (StringUtils.isNotEmpty((CharSequence)value)) {
                transportContext.getHttpClientRequest().putHeader(key, value);
            }
        });
        return nextNode.onFilter(invocation);
    }
}

