/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry;

import io.vertx.core.json.jackson.JacksonFactory;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.servicecomb.foundation.common.utils.LambdaUtils;
import org.apache.servicecomb.foundation.common.utils.SPIEnabled;
import org.apache.servicecomb.registry.api.LifeCycle;
import org.apache.servicecomb.registry.api.MicroserviceInstanceStatus;
import org.apache.servicecomb.registry.api.Registration;
import org.apache.servicecomb.registry.api.RegistrationInstance;
import org.springframework.util.CollectionUtils;

public class RegistrationManager {
    private final List<Registration<? extends RegistrationInstance>> registrationList;

    public RegistrationManager(List<Registration<? extends RegistrationInstance>> registrationList) {
        if (registrationList == null) {
            this.registrationList = Collections.emptyList();
            return;
        }
        this.registrationList = registrationList.stream().filter(SPIEnabled::enabled).collect(Collectors.toList());
    }

    public String getInstanceId(String registryName) {
        if (CollectionUtils.isEmpty(this.registrationList)) {
            return "";
        }
        Optional registration = this.registrationList.stream().filter(r -> registryName.equals(r.name())).collect(Collectors.toList()).stream().findFirst();
        if (!registration.isPresent()) {
            return "";
        }
        return ((Registration)registration.get()).getMicroserviceInstance().getInstanceId();
    }

    public String getServiceId(String registryName) {
        if (CollectionUtils.isEmpty(this.registrationList)) {
            return "";
        }
        Optional registration = this.registrationList.stream().filter(r -> registryName.equals(r.name())).collect(Collectors.toList()).stream().findFirst();
        if (!registration.isPresent()) {
            return "";
        }
        return ((Registration)registration.get()).getMicroserviceInstance().getServiceId();
    }

    public Registration<? extends RegistrationInstance> getPrimaryRegistration() {
        return this.registrationList.get(0);
    }

    public void updateMicroserviceInstanceStatus(MicroserviceInstanceStatus status) {
        this.registrationList.forEach(registration -> registration.updateMicroserviceInstanceStatus(status));
    }

    public void addProperty(String key, String value) {
        this.registrationList.forEach(registration -> registration.addProperty(key, value));
    }

    public void addSchema(String schemaId, String content) {
        this.registrationList.forEach(registration -> registration.addSchema(schemaId, content));
    }

    public void addEndpoint(String endpoint) {
        this.registrationList.forEach(registration -> registration.addEndpoint(endpoint));
    }

    public void destroy() {
        this.registrationList.forEach(LambdaUtils.ignoreException(LifeCycle::destroy));
    }

    public void run() {
        this.registrationList.forEach(LifeCycle::run);
    }

    public void init() {
        this.registrationList.forEach(LifeCycle::init);
    }

    public String info() {
        StringBuilder result = new StringBuilder();
        AtomicBoolean first = new AtomicBoolean(true);
        this.registrationList.forEach(registration -> {
            if (first.getAndSet(false)) {
                result.append("App ID: ").append(registration.getMicroserviceInstance().getApplication()).append("\n");
                result.append("Service Name: ").append(registration.getMicroserviceInstance().getServiceName()).append("\n");
                result.append("Version: ").append(registration.getMicroserviceInstance().getVersion()).append("\n");
                result.append("Environment: ").append(registration.getMicroserviceInstance().getEnvironment()).append("\n");
                result.append("Endpoints: ").append(this.getEndpoints(registration.getMicroserviceInstance().getEndpoints())).append("\n");
                result.append("Registration implementations:\n");
            }
            result.append("  name:").append(registration.name()).append("\n");
            result.append("    Instance ID: ").append(registration.getMicroserviceInstance().getInstanceId()).append("\n");
        });
        return result.toString();
    }

    private String getEndpoints(List<String> endpoints) {
        return JacksonFactory.CODEC.toString(endpoints);
    }
}

