/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx;

import io.vertx.core.dns.AddressResolverOptions;
import java.util.Arrays;
import java.util.List;
import org.apache.servicecomb.foundation.common.LegacyPropertyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressResolverConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddressResolverConfig.class);

    public static AddressResolverOptions getAddressResolverOptions(String tag) {
        AddressResolverOptions addressResolverOptions = new AddressResolverOptions();
        addressResolverOptions.setServers(AddressResolverConfig.getStringListProperty(AddressResolverOptions.DEFAULT_SERVERS, "addressResolver." + tag + ".servers", "addressResolver.servers"));
        addressResolverOptions.setOptResourceEnabled(AddressResolverConfig.getBooleanProperty(false, "addressResolver." + tag + ".optResourceEnabled", "addressResolver.optResourceEnabled"));
        addressResolverOptions.setCacheMinTimeToLive(AddressResolverConfig.getPositiveIntProperty(0, "addressResolver." + tag + ".cacheMinTimeToLive", "addressResolver.cacheMinTimeToLive"));
        addressResolverOptions.setCacheMaxTimeToLive(AddressResolverConfig.getPositiveIntProperty(Integer.MAX_VALUE, "addressResolver." + tag + ".cacheMaxTimeToLive", "addressResolver.cacheMaxTimeToLive"));
        addressResolverOptions.setCacheNegativeTimeToLive(AddressResolverConfig.getPositiveIntProperty(0, "addressResolver." + tag + ".cacheNegativeTimeToLive", "addressResolver.cacheNegativeTimeToLive"));
        addressResolverOptions.setQueryTimeout((long)AddressResolverConfig.getPositiveIntProperty(5000, "addressResolver." + tag + ".queryTimeout", "addressResolver.queryTimeout"));
        addressResolverOptions.setMaxQueries(AddressResolverConfig.getPositiveIntProperty(4, "addressResolver." + tag + ".maxQueries", "addressResolver.maxQueries"));
        addressResolverOptions.setRdFlag(AddressResolverConfig.getBooleanProperty(true, "addressResolver." + tag + ".rdFlag", "addressResolver.rdFlag"));
        addressResolverOptions.setSearchDomains(AddressResolverConfig.getStringListProperty(AddressResolverOptions.DEFAULT_SEARCH_DOMAINS, "addressResolver." + tag + ".searchDomains", "addressResolver.searchDomains"));
        addressResolverOptions.setNdots(AddressResolverConfig.getPositiveIntProperty(AddressResolverOptions.DEFAULT_NDOTS, "addressResolver." + tag + ".ndots", "addressResolver.ndots"));
        addressResolverOptions.setRotateServers(AddressResolverConfig.getBooleanProperty(AddressResolverOptions.DEFAULT_ROTATE_SERVERS, "addressResolver." + tag + ".rotateServers", "addressResolver.rotateServers"));
        return addressResolverOptions;
    }

    private static List<String> getStringListProperty(List<String> defaultValue, String ... keys) {
        for (String key : keys) {
            String[] vals = (String[])LegacyPropertyFactory.getProperty((String)key, String[].class);
            if (vals == null || vals.length <= 0) continue;
            return Arrays.asList(vals);
        }
        return defaultValue;
    }

    private static int getPositiveIntProperty(int defaultValue, String ... keys) {
        for (String key : keys) {
            Integer val = (Integer)LegacyPropertyFactory.getProperty((String)key, Integer.class);
            if (val != null && val <= 0) {
                LOGGER.warn("Address resover key:{}'s value:{} is not positive, please check!", (Object)key, (Object)val);
                continue;
            }
            if (val == null) continue;
            return val;
        }
        return defaultValue;
    }

    private static boolean getBooleanProperty(boolean defaultValue, String ... keys) {
        for (String key : keys) {
            Boolean val = (Boolean)LegacyPropertyFactory.getProperty((String)key, Boolean.class);
            if (val == null) continue;
            return val;
        }
        return defaultValue;
    }
}

