/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.bnd.plugin.headers.parameters.remove;

import aQute.bnd.header.Attrs;
import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.service.AnalyzerPlugin;
import aQute.service.reporter.Reporter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Plugin
implements aQute.bnd.service.Plugin,
AnalyzerPlugin {
    private Map<String, String> properties;
    private Reporter reporter;

    public void setProperties(Map<String, String> properties) throws Exception {
        this.properties = properties;
    }

    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    public boolean analyzeJar(Analyzer analyzer) throws Exception {
        this.process(analyzer, this.properties, this.reporter);
        return false;
    }

    private void process(Analyzer analyzer, Map<String, String> headers, Reporter reporter) {
        for (Map.Entry<String, String> header : headers.entrySet()) {
            reporter.trace("Processing header '%s'", new Object[]{header.getKey()});
            HashMap<String, Set> mapping = new HashMap<String, Set>();
            for (Map.Entry parameter : OSGiHeader.parseHeader((String)header.getValue()).entrySet()) {
                String key = this.cleanKey((String)parameter.getKey());
                mapping.computeIfAbsent(key, k -> new HashSet());
                reporter.trace("Mapping '%s' \u2192 '%s'", new Object[]{key, parameter.getValue()});
                ((Set)mapping.get(key)).add(((Attrs)parameter.getValue()).toString());
            }
            Parameters parameters = analyzer.getParameters(header.getKey());
            HashSet remove = new HashSet();
            for (Map.Entry parameter : parameters.entrySet()) {
                String key = this.cleanKey((String)parameter.getKey());
                if (!mapping.containsKey(key) || !((Set)mapping.get(key)).contains(((Attrs)parameter.getValue()).toString())) continue;
                reporter.trace("Parameter for removal found: %s;%s", new Object[]{key, parameter.getValue()});
                remove.add(parameter.getKey());
            }
            if (remove.isEmpty()) continue;
            for (String key : remove) {
                Attrs attrs = parameters.remove(key);
                reporter.trace("Parameter removed: %s;%s", new Object[]{this.cleanKey(key), attrs});
            }
            reporter.trace("Setting header '%s'", new Object[]{header.getKey()});
            analyzer.set(header.getKey(), parameters.toString());
        }
    }

    private String cleanKey(String key) {
        return key.replace("~", "");
    }
}

