<%-- /*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */ --%>
 <%@include file="/libs/sling-cms/global.jsp"%>
<sling:adaptTo var="breadcrumb" adaptable="${slingRequest}" adaptTo="org.apache.sling.cms.core.models.ContentBreadcrumb" />
<nav class="breadcrumb" aria-label="breadcrumbs">
    <ul>
        <c:forEach var="parent" items="${breadcrumb.parents}" varStatus="status">
            <li>
                <a href="${sling:encode(parent.left,'HTML_ATTR')}">
                    <sling:encode value="${parent.right}" mode="HTML" />
                </a>
            </li>
        </c:forEach>
        <li class="is-active">
            <div role="heading" aria-level="1">
                <a href="#">
                    <sling:encode value="${breadcrumb.currentItem}" mode="HTML" />
                </a>
            </div>
        </li>
    </ul>
    <c:if test="${!properties.hideSearch}">
        <div class="contentnav-search">
            <p class="control has-icons-left">
                <label class="is-sr-only" for="search-term"><fmt:message key="Search" /></label>
                <input class="input is-small" type="text" name="search" id="search-term">
                <span class="icon is-small is-left">
                    <i class="jam jam-search" aria-hidden="true"></i>
                </span>
            </p>
        </div>
    </c:if>
</nav>
