/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentConfigurationDTO;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;
import org.osgi.util.tracker.ServiceTracker;

public class ExtendedServiceTracker<T>
implements AutoCloseable {
    private final Class<T> trackedClass;
    private final ServiceTracker<T, T> serviceTracker;
    private final ServiceTracker<ServiceComponentRuntime, ServiceComponentRuntime> scrServiceTracker;

    public ExtendedServiceTracker(BundleContext bundleContext, Class<T> trackedClass) {
        this.trackedClass = trackedClass;
        this.serviceTracker = new ServiceTracker(bundleContext, trackedClass, null);
        this.serviceTracker.open();
        this.scrServiceTracker = new ServiceTracker(bundleContext, ServiceComponentRuntime.class, null);
        this.scrServiceTracker.open();
    }

    public Optional<T> getOptional() {
        return Optional.ofNullable(this.serviceTracker.getService());
    }

    public T getNotNull() {
        Object service = this.serviceTracker.getService();
        if (service == null) {
            ServiceComponentRuntime scr = (ServiceComponentRuntime)this.scrServiceTracker.getService();
            if (scr == null) {
                throw new IllegalStateException("Could not get service of type " + String.valueOf(this.trackedClass) + " and 'ServiceComponentRuntime' is not available either for further debugging hints");
            }
            List<ComponentDescriptionDTO> components = ExtendedServiceTracker.getComponentDescriptionDTOs(scr, this.trackedClass);
            if (components.isEmpty()) {
                throw new IllegalStateException("Could not get service of type " + String.valueOf(this.trackedClass) + ". The providing bundle is probably not properly installed or was not started as no DS component was found providing that service interface");
            }
            throw new IllegalStateException("Could not get service of type " + String.valueOf(this.trackedClass) + ": Providing " + this.getRelevantComponentInfo(scr, components.get(0)));
        }
        return (T)service;
    }

    static List<ComponentDescriptionDTO> getComponentDescriptionDTOs(ServiceComponentRuntime scr, Class<?> serviceInterface) {
        return scr.getComponentDescriptionDTOs(new Bundle[0]).stream().filter(c -> Arrays.asList(c.serviceInterfaces).contains(serviceInterface.getName())).collect(Collectors.toList());
    }

    public String getRelevantComponentInfo(ServiceComponentRuntime scr, ComponentDescriptionDTO component) {
        StringBuilder info = new StringBuilder("DS Component ").append(component.name).append(" from bundle ").append(component.bundle.symbolicName);
        Collection componentConfigurations = scr.getComponentConfigurationDTOs(component);
        if (componentConfigurations.isEmpty()) {
            info.append(" is not available");
        } else {
            for (ComponentConfigurationDTO componentConfiguration : componentConfigurations) {
                info.append(" has state \"").append(ExtendedServiceTracker.getState(componentConfiguration)).append("\"");
            }
        }
        return info.toString();
    }

    static String getState(ComponentConfigurationDTO componentConfiguration) {
        return switch (componentConfiguration.state) {
            case 1 -> "Unsatisfied configuration";
            case 2 -> "Unsatisfied reference(s): " + Arrays.toString(componentConfiguration.unsatisfiedReferences);
            case 4 -> "Satisfied";
            case 8 -> "Active";
            case 16 -> "Activate method failed: " + componentConfiguration.failure;
            default -> "Unknown state: " + componentConfiguration.state;
        };
    }

    @Override
    public void close() throws Exception {
        this.serviceTracker.close();
        this.scrServiceTracker.close();
    }
}

