/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.sling.models.impl.AdapterImplementations;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.apache.sling.models.impl.ModelPackageBundleListener;
import org.apache.sling.models.testmodels.classes.ChildModel;
import org.apache.sling.models.testmodels.classes.SimpleModelWithInvalidSecondAnnotation;
import org.apache.sling.models.testmodels.classes.annotations.Hidden;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.stubbing.Answer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.springframework.core.OverridingClassLoader;

@ExtendWith(value={MockitoExtension.class})
class ModelPackageBundleListenerTest {
    @Mock
    private BundleContext mockBundleContext;
    @Mock
    private ModelAdapterFactory mockModelAdapterFactory;
    @Mock
    private Bundle mockBundle;
    final AdapterImplementations adapterImplementations = new AdapterImplementations();

    ModelPackageBundleListenerTest() {
    }

    @Test
    void testAddingBundleWithResolvableModelAnnotation() throws ClassNotFoundException {
        Assertions.assertFalse((boolean)this.adapterImplementations.isModelClass(ChildModel.class), (String)"Model should not yet have been registered but was");
        ModelPackageBundleListener listener = this.createListenerForBundleWithClass(ChildModel.class);
        listener.addingBundle(this.mockBundle, new BundleEvent(2, this.mockBundle));
        Assertions.assertTrue((boolean)this.adapterImplementations.isModelClass(ChildModel.class), (String)"Model should have been registered but was not");
    }

    @Test
    void testAddingBundleWithNonResolvableNonModelAnnotation() throws ClassNotFoundException {
        HideClassesClassLoader classLoader = new HideClassesClassLoader(this.getClass().getClassLoader(), Hidden.class.getName());
        ModelPackageBundleListener listener = this.createListenerForBundleWithClass((ClassLoader)((Object)classLoader), SimpleModelWithInvalidSecondAnnotation.class.getName());
        listener.addingBundle(this.mockBundle, new BundleEvent(2, this.mockBundle));
        Assertions.assertFalse((boolean)this.adapterImplementations.isModelClass(SimpleModelWithInvalidSecondAnnotation.class), (String)"Model should not yet have been registered but was");
    }

    private ModelPackageBundleListener createListenerForBundleWithClass(Class<?> modelClass) throws ClassNotFoundException {
        return this.createListenerForBundleWithClass(modelClass.getClassLoader(), modelClass.getName());
    }

    private ModelPackageBundleListener createListenerForBundleWithClass(final ClassLoader classLoader, final String className) throws ClassNotFoundException {
        Hashtable<String, String> headers = new Hashtable<String, String>();
        ((Dictionary)headers).put("Sling-Model-Classes", className);
        Mockito.when((Object)this.mockBundle.getHeaders()).thenReturn(headers);
        Mockito.when((Object)this.mockBundle.loadClass(ArgumentMatchers.anyString())).thenAnswer(new Answer<Class<?>>(){

            public Class<?> answer(InvocationOnMock invocation) throws Throwable {
                Object argument = invocation.getArguments()[0];
                if (argument.equals(className)) {
                    return classLoader.loadClass(className);
                }
                throw new ClassNotFoundException("Could not find class with name " + String.valueOf(argument));
            }
        });
        return new ModelPackageBundleListener(this.mockBundleContext, this.mockModelAdapterFactory, this.adapterImplementations, null, null);
    }

    private static final class HideClassesClassLoader
    extends OverridingClassLoader {
        private final Collection<String> classNamesToHide;

        public HideClassesClassLoader(ClassLoader parent, String ... classNamesToHide) {
            super(parent);
            this.classNamesToHide = Arrays.asList(classNamesToHide);
            this.excludeClass(Hidden.class.getName());
        }

        protected Class<?> loadClassForOverriding(String name) throws ClassNotFoundException {
            if (this.classNamesToHide.contains(name)) {
                throw new ClassNotFoundException("Could not find class " + name + " as it is hidden by this class loader!");
            }
            return super.loadClassForOverriding(name);
        }
    }
}

