/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.util.Collections;
import javax.script.Bindings;
import javax.script.ScriptEngineFactory;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.adapter.AdapterManager;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.impl.AdapterFactoryTest;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.apache.sling.scripting.api.BindingsValuesProvider;
import org.apache.sling.scripting.api.BindingsValuesProvidersByContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
class RequestWrapperTest {
    @Mock
    private AdapterManager adapterManager;
    @Mock
    private BindingsValuesProvidersByContext bindingsValuesProvidersByContext;
    @Mock
    private BindingsValuesProvider bindingsValuesProvider;
    @Mock
    private Resource resource;
    @Mock
    private SlingJakartaHttpServletRequest request;
    @InjectMocks
    private ModelAdapterFactory factory;

    RequestWrapperTest() {
    }

    @BeforeEach
    void setup() {
        this.factory = AdapterFactoryTest.createModelAdapterFactory();
        this.factory.bindingsValuesProvidersByContext = this.bindingsValuesProvidersByContext;
        this.factory.adapterManager = this.adapterManager;
        Mockito.lenient().when((Object)this.bindingsValuesProvidersByContext.getBindingsValuesProviders((ScriptEngineFactory)ArgumentMatchers.any(ScriptEngineFactory.class), (String)ArgumentMatchers.eq((Object)"request"))).thenReturn(Collections.singleton(this.bindingsValuesProvider));
    }

    @Test
    void testWrapper() {
        Target expected = new Target();
        Mockito.when((Object)((Target)this.adapterManager.getAdapter(ArgumentMatchers.any(SlingJakartaHttpServletRequest.class), (Class)ArgumentMatchers.eq(Target.class)))).thenReturn((Object)expected);
        Target actual = (Target)this.factory.getModelFromWrappedRequest(this.request, this.resource, Target.class);
        Assertions.assertEquals((Object)expected, (Object)actual);
        ((AdapterManager)Mockito.verify((Object)this.adapterManager, (VerificationMode)Mockito.times((int)1))).getAdapter(ArgumentMatchers.argThat(this.requestHasResource(this.resource)), (Class)ArgumentMatchers.eq(Target.class));
        ((BindingsValuesProvider)Mockito.verify((Object)this.bindingsValuesProvider, (VerificationMode)Mockito.times((int)1))).addBindings((Bindings)ArgumentMatchers.argThat(this.bindingsHasResource(this.resource)));
    }

    private ArgumentMatcher<Bindings> bindingsHasResource(final Resource resource) {
        return new ArgumentMatcher<Bindings>(){

            public boolean matches(Bindings bindings) {
                return bindings.get("resource") == resource;
            }
        };
    }

    private ArgumentMatcher<SlingJakartaHttpServletRequest> requestHasResource(final Resource resource) {
        return new ArgumentMatcher<SlingJakartaHttpServletRequest>(){

            public boolean matches(SlingJakartaHttpServletRequest slingHttpServletRequest) {
                return slingHttpServletRequest.getResource().equals((Object)resource);
            }
        };
    }

    class Target {
        Target() {
        }
    }
}

