/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.it.testing;

import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.junit.rules.TeleporterRule;
import org.apache.sling.models.it.testbundle.models.ConstructorInjectionTestModel;
import org.apache.sling.models.it.testbundle.models.FieldInjectionTestModel;
import org.apache.sling.models.it.testbundle.models.InterfaceInjectionTestModel;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class SimpleIT {
    @Rule
    public final TeleporterRule teleporter = TeleporterRule.forClass(this.getClass(), (String)"SM_Teleporter");
    private String value;
    private String childValue;
    private ResourceResolver resolver;
    private Resource resource;
    private Node createdNode;

    @Before
    public void setUp() throws Exception {
        ResourceResolverFactory rrFactory = (ResourceResolverFactory)this.teleporter.getService(ResourceResolverFactory.class);
        this.value = RandomStringUtils.secure().nextAlphanumeric(10);
        this.childValue = RandomStringUtils.secure().nextAlphanumeric(10);
        this.resolver = rrFactory.getServiceResourceResolver(null);
        Session session = (Session)this.resolver.adaptTo(Session.class);
        Node rootNode = session.getRootNode();
        this.createdNode = rootNode.addNode("test_" + RandomStringUtils.secure().nextAlphanumeric(10));
        this.createdNode.setProperty("testProperty", this.value);
        Node child = this.createdNode.addNode("child");
        child.setProperty("childProperty", this.childValue);
        session.save();
        this.resource = this.resolver.getResource(this.createdNode.getPath());
    }

    @After
    public void tearDown() throws Exception {
        if (this.createdNode != null) {
            this.createdNode.remove();
        }
        if (this.resolver != null) {
            this.resolver.close();
        }
    }

    @Test
    public void testFieldInjection() {
        FieldInjectionTestModel model = (FieldInjectionTestModel)this.resource.adaptTo(FieldInjectionTestModel.class);
        Assert.assertNotNull((String)"Model is null", (Object)model);
        Assert.assertEquals((String)"Test Property is not set correctly", (Object)this.value, (Object)model.getTestProperty());
        Assert.assertEquals((String)"Child Test Property is not set correctly", (Object)this.childValue, (Object)model.getChildProperty());
        Assert.assertNotNull((String)"Filters is null", model.getFilters());
        Assert.assertSame((String)"Adaptable is not injected", (Object)this.resource, (Object)model.getResource());
    }

    @Test
    public void testInterfaceInjection() {
        InterfaceInjectionTestModel model = (InterfaceInjectionTestModel)this.resource.adaptTo(InterfaceInjectionTestModel.class);
        Assert.assertNotNull((String)"Model is null", (Object)model);
        Assert.assertEquals((String)"Test Property is not set correctly", (Object)this.value, (Object)model.getTestProperty());
        Assert.assertNotNull((String)"Filters is null", model.getFilters());
        Assert.assertSame((String)"Adaptable is not injected", (Object)this.resource, (Object)model.getResource());
    }

    @Test
    public void testConstructorInjection() {
        ConstructorInjectionTestModel model = (ConstructorInjectionTestModel)this.resource.adaptTo(ConstructorInjectionTestModel.class);
        Assert.assertNotNull((String)"Model is null", (Object)model);
        Assert.assertEquals((String)"Test Property is not set correctly", (Object)this.value, (Object)model.getTestProperty());
        Assert.assertNotNull((String)"Filters is null", model.getFilters());
        Assert.assertSame((String)"Adaptable is not injected", (Object)this.resource, (Object)model.getResource());
    }
}

