/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.js.impl.jsapi;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.scripting.LazyBindings;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.scripting.core.ScriptNameAwareReader;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.js.impl.JsEnvironment;
import org.apache.sling.scripting.sightly.js.impl.async.AsyncContainer;
import org.apache.sling.scripting.sightly.js.impl.async.AsyncExtractor;
import org.apache.sling.scripting.sightly.js.impl.async.TimingBindingsValuesProvider;
import org.apache.sling.scripting.sightly.js.impl.async.TimingFunction;
import org.apache.sling.scripting.sightly.js.impl.cjs.CommonJsModule;
import org.apache.sling.scripting.sightly.js.impl.rhino.HybridObject;
import org.apache.sling.scripting.sightly.js.impl.rhino.JsValueAdapter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SlyBindingsValuesProvider.class}, configurationPid={"org.apache.sling.scripting.sightly.js.impl.jsapi.SlyBindingsValuesProvider"})
@Designate(ocd=Configuration.class)
public class SlyBindingsValuesProvider {
    public static final String SCR_PROP_JS_BINDING_IMPLEMENTATIONS = "org.apache.sling.scripting.sightly.js.bindings";
    public static final String SLING_NS_PATH = "/libs/sling/sightly/js/internal/sly.js";
    public static final String Q_PATH = "/libs/sling/sightly/js/3rd-party/q.js";
    private static final String REQ_NS = SlyBindingsValuesProvider.class.getCanonicalName();
    private static final Logger LOGGER = LoggerFactory.getLogger(SlyBindingsValuesProvider.class);
    private final AsyncExtractor asyncExtractor = new AsyncExtractor();
    private final JsValueAdapter jsValueAdapter = new JsValueAdapter(this.asyncExtractor);
    private Map<String, String> scriptPaths = new HashMap<String, String>();
    private Map<String, Function> factories = new HashMap<String, Function>();
    private Script qScript;
    private final ScriptableObject qScope = this.createQScope();

    public void initialise(ResourceResolver resourceResolver, JsEnvironment environment, Bindings bindings) {
        if (this.needsInit()) {
            this.init(resourceResolver, environment, bindings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processBindings(Bindings bindings) {
        if (this.needsInit()) {
            throw new SightlyException("Attempted to call processBindings without calling initialise first.");
        }
        Context context = null;
        try {
            context = Context.enter();
            Object qInstance = this.obtainQInstance(context, bindings);
            if (qInstance == null) {
                return;
            }
            for (Map.Entry<String, Function> entry : this.factories.entrySet()) {
                this.addBinding(context, entry.getValue(), bindings, entry.getKey(), qInstance);
            }
        }
        finally {
            if (context != null) {
                Context.exit();
            }
        }
    }

    public Map<String, String> getScriptPaths() {
        return Collections.unmodifiableMap(this.scriptPaths);
    }

    @Activate
    protected void activate(Configuration configuration) {
        String[] factories = PropertiesUtil.toStringArray((Object)configuration.org_apache_sling_scripting_sightly_js_bindings(), (String[])new String[]{SLING_NS_PATH});
        this.scriptPaths = new LinkedHashMap<String, String>(factories.length);
        for (String f : factories) {
            String[] parts = f.split(":");
            if (parts.length != 2) continue;
            this.scriptPaths.put(parts[0], parts[1]);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext componentContext) {
        if (this.scriptPaths != null) {
            this.scriptPaths.clear();
        }
        if (this.factories != null) {
            this.factories.clear();
        }
    }

    private void addBinding(Context context, Function factory, Bindings bindings, String globalName, Object qInstance) {
        if (factory == null) {
            return;
        }
        Object result = factory.call(context, (Scriptable)factory, (Scriptable)factory, new Object[]{bindings, qInstance});
        HybridObject global = new HybridObject((Scriptable)result, this.jsValueAdapter);
        bindings.put(globalName, (Object)global);
    }

    private boolean needsInit() {
        return this.factories == null || this.factories.isEmpty() || this.qScript == null;
    }

    private synchronized void init(ResourceResolver resourceResolver, JsEnvironment jsEnvironment, Bindings bindings) {
        if (this.needsInit()) {
            this.factories = new HashMap<String, Function>(this.scriptPaths.size());
            for (Map.Entry<String, String> entry : this.scriptPaths.entrySet()) {
                this.factories.put(entry.getKey(), this.loadFactory(resourceResolver, jsEnvironment, entry.getValue(), bindings));
            }
            this.qScript = this.loadQScript(resourceResolver);
        }
    }

    private Function loadFactory(ResourceResolver resolver, JsEnvironment jsEnvironment, String path, Bindings bindings) {
        Resource resource = resolver.getResource(path);
        if (resource == null) {
            throw new SightlyException("Sly namespace loader could not find the following script: " + path);
        }
        try {
            AsyncContainer container = jsEnvironment.runScript(new ScriptNameAwareReader((Reader)new StringReader(IOUtils.toString((InputStream)((InputStream)resource.adaptTo(InputStream.class)), (Charset)StandardCharsets.UTF_8)), resource.getPath()), this.createBindings(bindings, resource.getPath()), new SimpleBindings());
            Object obj = container.getResult();
            if (!(obj instanceof Function)) {
                throw new SightlyException("Script " + path + " was expected to return a function.");
            }
            return (Function)obj;
        }
        catch (IOException e) {
            throw new SightlyException("Cannot read script " + path + " .");
        }
    }

    private Bindings createBindings(Bindings global, String factoryPath) {
        LazyBindings bindings = new LazyBindings();
        bindings.putAll(global);
        bindings.put("javax.script.filename", (Object)factoryPath);
        TimingBindingsValuesProvider.INSTANCE.addBindings((Bindings)bindings);
        return bindings;
    }

    private Object obtainQInstance(Context context, Bindings bindings) {
        if (this.qScript == null) {
            return null;
        }
        HttpServletRequest request = (HttpServletRequest)bindings.get("request");
        Object qInstance = null;
        if (request != null) {
            qInstance = request.getAttribute(REQ_NS);
        }
        if (qInstance == null) {
            qInstance = this.createQInstance(context, this.qScript);
            if (request != null) {
                request.setAttribute(REQ_NS, qInstance);
            }
        }
        return qInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScriptableObject createQScope() {
        Context context = Context.enter();
        try {
            ScriptableObject scope = context.initStandardObjects();
            ScriptableObject.putProperty((Scriptable)scope, (String)"setImmediate", (Object)((Object)TimingFunction.INSTANCE));
            ScriptableObject.putProperty((Scriptable)scope, (String)"setTimeout", (Object)((Object)TimingFunction.INSTANCE));
            ScriptableObject scriptableObject = scope;
            return scriptableObject;
        }
        finally {
            Context.exit();
        }
    }

    private Object createQInstance(Context context, Script qScript) {
        CommonJsModule module = new CommonJsModule();
        Scriptable tempScope = context.newObject((Scriptable)this.qScope);
        ScriptableObject.putProperty((Scriptable)tempScope, (String)"module", (Object)((Object)module));
        ScriptableObject.putProperty((Scriptable)tempScope, (String)"exports", (Object)module.getExports());
        qScript.exec(context, tempScope);
        return module.getExports();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Script loadQScript(ResourceResolver resolver) {
        Script script;
        InputStream reader;
        block11: {
            Script script2;
            block10: {
                Script script3;
                block9: {
                    Context context = Context.enter();
                    context.initStandardObjects();
                    context.setOptimizationLevel(9);
                    reader = null;
                    try {
                        Resource resource = resolver.getResource(Q_PATH);
                        if (resource == null) {
                            LOGGER.warn("Could not load Q library at path: /libs/sling/sightly/js/3rd-party/q.js");
                            script3 = null;
                            Context.exit();
                            break block9;
                        }
                        reader = (InputStream)resource.adaptTo(InputStream.class);
                        if (reader == null) {
                            LOGGER.warn("Could not read content of Q library");
                            script2 = null;
                            Context.exit();
                            break block10;
                        }
                        script = context.compileReader((Reader)new InputStreamReader(reader, StandardCharsets.UTF_8), Q_PATH, 0, null);
                        Context.exit();
                        break block11;
                    }
                    catch (IOException e) {
                        LOGGER.error("Unable to compile the Q library at path /libs/sling/sightly/js/3rd-party/q.js.", (Throwable)e);
                        return null;
                    }
                }
                IOUtils.closeQuietly((InputStream)reader);
                return script3;
            }
            IOUtils.closeQuietly((InputStream)reader);
            return script2;
        }
        IOUtils.closeQuietly((InputStream)reader);
        return script;
        finally {
            Context.exit();
            IOUtils.closeQuietly(reader);
        }
    }

    @ObjectClassDefinition(name="Apache Sling Scripting HTL JavaScript Use-API Factories Configuration", description="HTL JavaScript Use-API Factories configuration options")
    static @interface Configuration {
        @AttributeDefinition(name="Script Factories", description="Script factories to load in the bindings map. The entries should be in the form 'namespace:/path/from/repository'. If the factories depend on each other, add them in the correct order of their dependency chain.")
        public String[] org_apache_sling_scripting_sightly_js_bindings() default {"sightly:/libs/sling/sightly/js/internal/sly.js"};
    }
}

