/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.thumbnails.internal.transformers;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.coobird.thumbnailator.Thumbnails;
import net.coobird.thumbnailator.filters.Colorize;
import net.coobird.thumbnailator.filters.ImageFilter;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.thumbnails.BadRequestException;
import org.apache.sling.thumbnails.TransformationHandlerConfig;
import org.apache.sling.thumbnails.extension.TransformationHandler;
import org.osgi.service.component.annotations.Component;

@Component(service={TransformationHandler.class}, immediate=true)
public class ColorizeHandler
implements TransformationHandler {
    public static final String RESOURCE_TYPE = "sling/thumbnails/transformers/colorize";
    public static final String PN_RED = "red";
    public static final String PN_GREEN = "green";
    public static final String PN_BLUE = "blue";
    public static final String PN_ALPHA = "alpha";

    @Override
    public String getResourceType() {
        return RESOURCE_TYPE;
    }

    @Override
    public void handle(InputStream inputStream, OutputStream outputStream, TransformationHandlerConfig config) throws IOException {
        Thumbnails.Builder builder = Thumbnails.of((InputStream[])new InputStream[]{inputStream});
        ValueMap properties = config.getProperties();
        int red = this.getColor(properties, PN_RED);
        int green = this.getColor(properties, PN_GREEN);
        int blue = this.getColor(properties, PN_BLUE);
        float alpha = (float)((Double)config.getProperties().get(PN_ALPHA, (Object)0.0)).doubleValue();
        if (alpha < 0.0f || (double)alpha > 1.0) {
            throw new BadRequestException("Unable to colorize, bad alpha value " + alpha);
        }
        builder.addFilter((ImageFilter)new Colorize(new Color(red, green, blue), alpha));
        builder.scale(1.0);
        builder.toOutputStream(outputStream);
    }

    protected int getColor(ValueMap properties, String name) {
        int color = (Integer)properties.get(name, (Object)0);
        if (color < 0 || color > 255) {
            throw new BadRequestException("Unable to colorize, bad " + name + " value " + color);
        }
        return color;
    }
}

