/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.mr;

import java.util.ArrayList;
import org.apache.sysml.lops.AppendM;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.mr.AppendInstruction;
import org.apache.sysml.runtime.instructions.mr.IDistributedCacheConsumer;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.data.OperationsOnMatrixValues;
import org.apache.sysml.runtime.matrix.mapred.CachedValueMap;
import org.apache.sysml.runtime.matrix.mapred.DistributedCacheInput;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.mapred.MRBaseForCommonInstructions;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class AppendMInstruction
extends AppendInstruction
implements IDistributedCacheConsumer {
    private long _offset = -1L;

    private AppendMInstruction(Operator op, byte in1, byte in2, long offset, AppendM.CacheType type, byte out, boolean cbind, String istr) {
        super(op, in1, in2, out, cbind, istr);
        this._offset = offset;
    }

    public static AppendMInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionParts(str);
        InstructionUtils.checkNumFields(parts, 6);
        byte in1 = Byte.parseByte(parts[1]);
        byte in2 = Byte.parseByte(parts[2]);
        long offset = (long)Double.parseDouble(parts[3]);
        byte out = Byte.parseByte(parts[4]);
        AppendM.CacheType type = AppendM.CacheType.valueOf(parts[5]);
        boolean cbind = Boolean.parseBoolean(parts[6]);
        return new AppendMInstruction(null, in1, in2, offset, type, out, cbind, str);
    }

    @Override
    public boolean isDistCacheOnlyIndex(String inst, byte index) {
        return index == this.input2 && index != this.input1;
    }

    @Override
    public void addDistCacheIndex(String inst, ArrayList<Byte> indexes) {
        indexes.add(this.input2);
    }

    @Override
    public void processInstruction(Class<? extends MatrixValue> valueClass, CachedValueMap cachedValues, IndexedMatrixValue tempValue, IndexedMatrixValue zeroInput, int blockRowFactor, int blockColFactor) {
        ArrayList<IndexedMatrixValue> blkList = cachedValues.get(this.input1);
        if (blkList == null) {
            return;
        }
        for (IndexedMatrixValue in1 : blkList) {
            IndexedMatrixValue second;
            DistributedCacheInput dcInput;
            if (in1 == null) continue;
            int blen = this._cbind ? blockColFactor : blockRowFactor;
            long lastBlockColIndex = Math.max((long)Math.ceil((double)this._offset / (double)blen), 1L);
            MatrixIndexes ix = in1.getIndexes();
            if ((this._cbind ? ix.getColumnIndex() : ix.getRowIndex()) != lastBlockColIndex) {
                cachedValues.add(this.output, in1);
                continue;
            }
            if (this._cbind && in1.getValue().getNumColumns() == blen || !this._cbind && in1.getValue().getNumRows() == blen) {
                cachedValues.add(this.output, in1);
                dcInput = MRBaseForCommonInstructions.dcValues.get(this.input2);
                if (this._cbind) {
                    cachedValues.add(this.output, new IndexedMatrixValue(new MatrixIndexes(ix.getRowIndex(), ix.getColumnIndex() + 1L), dcInput.getDataBlock((int)ix.getRowIndex(), 1).getValue()));
                    continue;
                }
                cachedValues.add(this.output, new IndexedMatrixValue(new MatrixIndexes(ix.getRowIndex() + 1L, ix.getColumnIndex()), dcInput.getDataBlock(1, (int)ix.getColumnIndex()).getValue()));
                continue;
            }
            dcInput = MRBaseForCommonInstructions.dcValues.get(this.input2);
            ArrayList<IndexedMatrixValue> outlist = new ArrayList<IndexedMatrixValue>(2);
            IndexedMatrixValue first = cachedValues.holdPlace(this.output, valueClass);
            first.getIndexes().setIndexes(ix);
            outlist.add(first);
            MatrixValue value_in2 = null;
            if (this._cbind) {
                value_in2 = dcInput.getDataBlock((int)ix.getRowIndex(), 1).getValue();
                if (in1.getValue().getNumColumns() + value_in2.getNumColumns() > blen) {
                    second = cachedValues.holdPlace(this.output, valueClass);
                    second.getIndexes().setIndexes(ix.getRowIndex(), ix.getColumnIndex() + 1L);
                    outlist.add(second);
                }
            } else {
                value_in2 = dcInput.getDataBlock(1, (int)ix.getColumnIndex()).getValue();
                if (in1.getValue().getNumRows() + value_in2.getNumRows() > blen) {
                    second = cachedValues.holdPlace(this.output, valueClass);
                    second.getIndexes().setIndexes(ix.getRowIndex() + 1L, ix.getColumnIndex());
                    outlist.add(second);
                }
            }
            OperationsOnMatrixValues.performAppend(in1.getValue(), value_in2, outlist, blockRowFactor, blockColFactor, this._cbind, true, 0);
        }
    }
}

