/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.nn.layers;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.Script;
import org.apache.sysml.scripts.nn.layers.scale_shift2d.Backward_output;
import org.apache.sysml.scripts.nn.layers.scale_shift2d.Init_output;

public class Scale_shift2d
extends Script {
    public Scale_shift2d() {
        String string = "scripts/nn/layers/scale_shift2d.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public Init_output init(Object object) {
        String string = "source('scripts/nn/layers/scale_shift2d.dml') as mlcontextns;[gamma, beta] = mlcontextns::init(C);";
        Script script = new Script(string);
        script.in("C", object).out("gamma").out("beta");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("gamma");
        Matrix matrix2 = mLResults.getMatrix("beta");
        Init_output init_output = new Init_output(matrix, matrix2);
        return init_output;
    }

    public String init__docs() {
        String string = "init = function(int C)\n    return (matrix[double] gamma, matrix[double] beta) {\n  /*\n   * Initialize the parameters of this layer.\n   *\n   * By default, we initialize to an identity function, with a scale\n   * filler of `1`, and a shift filler of `0`.\n   *\n   * Note: This is just a convenience function, and parameters\n   * may be initialized manually if needed.\n   *\n   * Inputs:\n   *  - C: Number of input channels (dimensionality of input depth).\n   *\n   * Outputs:\n   *  - gamma: Scale parameters, of shape (C, 1).\n   *  - beta: Shift parameters, of shape (C, 1).\n   */\n";
        return string;
    }

    public String init__source() {
        String string = "init = function(int C)\n    return (matrix[double] gamma, matrix[double] beta) {\n  /*\n   * Initialize the parameters of this layer.\n   *\n   * By default, we initialize to an identity function, with a scale\n   * filler of `1`, and a shift filler of `0`.\n   *\n   * Note: This is just a convenience function, and parameters\n   * may be initialized manually if needed.\n   *\n   * Inputs:\n   *  - C: Number of input channels (dimensionality of input depth).\n   *\n   * Outputs:\n   *  - gamma: Scale parameters, of shape (C, 1).\n   *  - beta: Shift parameters, of shape (C, 1).\n   */\n   gamma = matrix(1, rows=C, cols=1)\n   beta = matrix(0, rows=C, cols=1)\n}\n";
        return string;
    }

    public Matrix forward(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        String string = "source('scripts/nn/layers/scale_shift2d.dml') as mlcontextns;out = mlcontextns::forward(X, gamma, beta, C, Hin, Win);";
        Script script = new Script(string);
        script.in("X", object).in("gamma", object2).in("beta", object3).in("C", object4).in("Hin", object5).in("Win", object6).out("out");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("out");
        return matrix;
    }

    public String forward__docs() {
        String string = "forward = function(matrix[double] X, matrix[double] gamma, matrix[double] beta,\n                   int C, int Hin, int Win)\n    return (matrix[double] out) {\n  /*\n   * Computes the forward pass for a 2D scale & shift layer.  The input\n   * data has N examples, each represented as a 3D volume unrolled into\n   * a single vector.\n   *\n   * A 2D scale & shift layer introduces learnable parameters\n   * (gamma, beta) to scale and shift the input on a per-channel basis.\n   *\n   *   `y = x*gamma + beta`\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (N, C*Hin*Win).\n   *  - gamma: Scale parameters, of shape (C, 1).\n   *  - beta: Shift parameters, of shape (C, 1).\n   *  - C: Number of input channels (dimensionality of input depth).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *\n   * Outputs:\n   *  - out: Outputs, of shape (N, C*Hin*Win).\n   */\n";
        return string;
    }

    public String forward__source() {
        String string = "forward = function(matrix[double] X, matrix[double] gamma, matrix[double] beta,\n                   int C, int Hin, int Win)\n    return (matrix[double] out) {\n  /*\n   * Computes the forward pass for a 2D scale & shift layer.  The input\n   * data has N examples, each represented as a 3D volume unrolled into\n   * a single vector.\n   *\n   * A 2D scale & shift layer introduces learnable parameters\n   * (gamma, beta) to scale and shift the input on a per-channel basis.\n   *\n   *   `y = x*gamma + beta`\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (N, C*Hin*Win).\n   *  - gamma: Scale parameters, of shape (C, 1).\n   *  - beta: Shift parameters, of shape (C, 1).\n   *  - C: Number of input channels (dimensionality of input depth).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *\n   * Outputs:\n   *  - out: Outputs, of shape (N, C*Hin*Win).\n   */\n  # Scale and shift\n  scaled = bias_multiply(X, gamma)  # shape (N, C*Hin*Win)\n  out = bias_add(scaled, beta)  # shape (N, C*Hin*Win)\n}\n";
        return string;
    }

    public Backward_output backward(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        String string = "source('scripts/nn/layers/scale_shift2d.dml') as mlcontextns;[dX, dgamma, dbeta] = mlcontextns::backward(dout, out, X, gamma, beta, C, Hin, Win);";
        Script script = new Script(string);
        script.in("dout", object).in("out", object2).in("X", object3).in("gamma", object4).in("beta", object5).in("C", object6).in("Hin", object7).in("Win", object8).out("dX").out("dgamma").out("dbeta");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("dX");
        Matrix matrix2 = mLResults.getMatrix("dgamma");
        Matrix matrix3 = mLResults.getMatrix("dbeta");
        Backward_output backward_output = new Backward_output(matrix, matrix2, matrix3);
        return backward_output;
    }

    public String backward__docs() {
        String string = "backward = function(matrix[double] dout, matrix[double] out,\n                    matrix[double] X, matrix[double] gamma, matrix[double] beta,\n                    int C, int Hin, int Win)\n      return (matrix[double] dX, matrix[double] dgamma, matrix[double] dbeta) {\n  /*\n   * Computes the backward pass for a 2D scale & shift layer.\n   *\n   * Inputs:\n   *  - dout: Gradient wrt `out` from upstream, of shape (N, C*Hin*Win).\n   *  - out: Outputs from the forward pass, of shape (N, C*Hin*Win).\n   *  - X: Input data matrix to the forward pass, of\n   *      shape (N, C*Hin*Win).\n   *  - gamma: Scale parameters, of shape (C, 1).\n   *  - beta: Shift parameters, of shape (C, 1).\n   *  - C: Number of input channels (dimensionality of input depth).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *\n   * Outputs:\n   *  - dX: Gradient wrt `X`, of shape (N, C*Hin*Win).\n   *  - dgamma: Gradient wrt `W`, of shape (C, 1).\n   *  - dbeta: Gradient wrt `b`, of shape (C, 1).\n   *\n   */\n";
        return string;
    }

    public String backward__source() {
        String string = "backward = function(matrix[double] dout, matrix[double] out,\n                    matrix[double] X, matrix[double] gamma, matrix[double] beta,\n                    int C, int Hin, int Win)\n      return (matrix[double] dX, matrix[double] dgamma, matrix[double] dbeta) {\n  /*\n   * Computes the backward pass for a 2D scale & shift layer.\n   *\n   * Inputs:\n   *  - dout: Gradient wrt `out` from upstream, of shape (N, C*Hin*Win).\n   *  - out: Outputs from the forward pass, of shape (N, C*Hin*Win).\n   *  - X: Input data matrix to the forward pass, of\n   *      shape (N, C*Hin*Win).\n   *  - gamma: Scale parameters, of shape (C, 1).\n   *  - beta: Shift parameters, of shape (C, 1).\n   *  - C: Number of input channels (dimensionality of input depth).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *\n   * Outputs:\n   *  - dX: Gradient wrt `X`, of shape (N, C*Hin*Win).\n   *  - dgamma: Gradient wrt `W`, of shape (C, 1).\n   *  - dbeta: Gradient wrt `b`, of shape (C, 1).\n   *\n   */\n  # Compute gradients during training\n  dgamma = util::channel_sums(dout*X, C, Hin, Win)  # shape (C, 1)\n  dbeta = util::channel_sums(dout, C, Hin, Win)  # shape (C, 1)\n  dX = bias_multiply(dout, gamma)  # shape (N, C*Hin*Win)\n}\n";
        return string;
    }
}

