/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.AggUnaryOp;
import org.apache.sysds.hops.BinaryOp;
import org.apache.sysds.hops.DataOp;
import org.apache.sysds.hops.FunctionOp;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.hops.HopsException;
import org.apache.sysds.hops.IndexingOp;
import org.apache.sysds.hops.LiteralOp;
import org.apache.sysds.hops.MemoTable;
import org.apache.sysds.hops.MultiThreadedHop;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.hops.ReorgOp;
import org.apache.sysds.hops.UnaryOp;
import org.apache.sysds.hops.rewrite.HopRewriteUtils;
import org.apache.sysds.lops.Data;
import org.apache.sysds.lops.GroupedAggregate;
import org.apache.sysds.lops.GroupedAggregateM;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.lops.ParameterizedBuiltin;
import org.apache.sysds.parser.DMLProgram;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;
import org.apache.sysds.runtime.util.UtilFunctions;

public class ParameterizedBuiltinOp
extends MultiThreadedHop {
    private static final Log LOG = LogFactory.getLog((String)ParameterizedBuiltinOp.class.getName());
    public static boolean FORCE_DIST_RM_EMPTY = false;
    private Types.ParamBuiltinOp _op;
    private boolean _outputPermutationMatrix = false;
    private boolean _bRmEmptyBC = false;
    private HashMap<String, Integer> _paramIndexMap = new HashMap();

    private ParameterizedBuiltinOp() {
    }

    public ParameterizedBuiltinOp(String l, Types.DataType dt, Types.ValueType vt, Types.ParamBuiltinOp op, LinkedHashMap<String, Hop> inputParameters) {
        super(l, dt, vt);
        this._op = op;
        int index = 0;
        for (Map.Entry<String, Hop> e : inputParameters.entrySet()) {
            String s = e.getKey();
            Hop input = e.getValue();
            this.getInput().add(input);
            input.getParent().add(this);
            this._paramIndexMap.put(s, index);
            ++index;
        }
        this.refreshSizeInformation();
    }

    @Override
    public void checkArity() {
        int pz;
        int sz = this._input.size();
        HopsException.check(sz == (pz = this._paramIndexMap.size()), this, "has %d inputs but %d parameters", sz, pz);
    }

    public HashMap<String, Integer> getParamIndexMap() {
        return this._paramIndexMap;
    }

    @Override
    public String getOpString() {
        return "" + (Object)((Object)this._op);
    }

    public Types.ParamBuiltinOp getOp() {
        return this._op;
    }

    public void setOutputPermutationMatrix(boolean flag) {
        this._outputPermutationMatrix = flag;
    }

    public Hop getTargetHop() {
        return this.getParameterHop("target");
    }

    public Hop getParameterHop(String name) {
        return this._paramIndexMap.containsKey(name) ? this.getInput().get(this._paramIndexMap.get(name)) : null;
    }

    @Override
    public boolean isGPUEnabled() {
        return false;
    }

    @Override
    public boolean isMultiThreadedOpType() {
        return HopRewriteUtils.isValidOp(this._op, Types.ParamBuiltinOp.GROUPEDAGG, Types.ParamBuiltinOp.REXPAND, Types.ParamBuiltinOp.PARAMSERV);
    }

    @Override
    public Lop constructLops() {
        if (this.getLops() != null) {
            return this.getLops();
        }
        HashMap<String, Lop> inputlops = new HashMap<String, Lop>();
        for (Map.Entry<String, Integer> cur : this._paramIndexMap.entrySet()) {
            inputlops.put(cur.getKey(), this.getInput().get(cur.getValue()).constructLops());
        }
        switch (this._op) {
            case GROUPEDAGG: {
                Types.ExecType et = this.optFindExecType();
                this.constructLopsGroupedAggregate(inputlops, et);
                break;
            }
            case RMEMPTY: {
                Types.ExecType et = this.optFindExecType();
                this.constructLopsRemoveEmpty(inputlops, et);
                break;
            }
            case REXPAND: {
                Types.ExecType et = this.optFindExecType();
                this.constructLopsRExpand(inputlops, et);
                break;
            }
            case CDF: 
            case INVCDF: 
            case REPLACE: 
            case LOWER_TRI: 
            case UPPER_TRI: 
            case TOKENIZE: 
            case TRANSFORMAPPLY: 
            case TRANSFORMDECODE: 
            case TRANSFORMCOLMAP: 
            case TRANSFORMMETA: 
            case TOSTRING: 
            case PARAMSERV: 
            case LIST: 
            case AUTODIFF: {
                Types.ExecType et = this.optFindExecType();
                ParameterizedBuiltin pbilop = new ParameterizedBuiltin(inputlops, this._op, this.getDataType(), this.getValueType(), et);
                this.setOutputDimensions(pbilop);
                this.setLineNumbers(pbilop);
                this.setLops(pbilop);
                break;
            }
            default: {
                throw new HopsException("Unknown ParamBuiltinOp: " + (Object)((Object)this._op));
            }
        }
        this.constructAndSetLopsDataFlowProperties();
        return this.getLops();
    }

    private void constructLopsGroupedAggregate(HashMap<String, Lop> inputlops, Types.ExecType et) {
        this.setRequiresReblock(false);
        long outputDim1 = -1L;
        long outputDim2 = -1L;
        Lop numGroups = inputlops.get("ngroups");
        if (!this.dimsKnown() && numGroups != null && numGroups instanceof Data && ((Data)numGroups).isLiteral()) {
            boolean rowwise;
            long ngroups = ((Data)numGroups).getLongValue();
            Lop input = inputlops.get("combinedinput");
            long inDim1 = input.getOutputParameters().getNumRows();
            long inDim2 = input.getOutputParameters().getNumCols();
            boolean bl = rowwise = inDim1 == 1L && inDim2 > 1L;
            if (rowwise) {
                outputDim1 = ngroups;
                outputDim2 = 1L;
            } else {
                outputDim1 = inDim2;
                outputDim2 = ngroups;
            }
        }
        Lop grp_agg = null;
        if (et == Types.ExecType.CP) {
            int k = OptimizerUtils.getConstrainedNumThreads(this._maxNumThreads);
            grp_agg = new GroupedAggregate(inputlops, this.getDataType(), this.getValueType(), et, k);
            grp_agg.getOutputParameters().setDimensions(outputDim1, outputDim2, this.getBlocksize(), -1L);
        } else if (et == Types.ExecType.SPARK) {
            boolean broadcastGroups;
            Hop groups = this.getParameterHop("groups");
            boolean bl = broadcastGroups = this._paramIndexMap.get("weights") == null && OptimizerUtils.checkSparkBroadcastMemoryBudget(groups.getDim1(), groups.getDim2(), groups.getBlocksize(), groups.getNnz());
            if (broadcastGroups && this.getParameterHop("fn") instanceof LiteralOp && ((LiteralOp)this.getParameterHop("fn")).getStringValue().equals("sum") && inputlops.get("ngroups") != null) {
                Hop target = this.getTargetHop();
                grp_agg = new GroupedAggregateM(inputlops, this.getDataType(), this.getValueType(), true, Types.ExecType.SPARK);
                grp_agg.getOutputParameters().setDimensions(outputDim1, outputDim2, target.getBlocksize(), -1L);
            } else {
                grp_agg = new GroupedAggregate(inputlops, this.getDataType(), this.getValueType(), et, broadcastGroups);
                grp_agg.getOutputParameters().setDimensions(outputDim1, outputDim2, -1L, -1L);
                this.setRequiresReblock(true);
            }
        }
        this.setLineNumbers(grp_agg);
        this.setLops(grp_agg);
    }

    private void constructLopsRemoveEmpty(HashMap<String, Lop> inputlops, Types.ExecType et) {
        Hop targetHop = this.getTargetHop();
        Hop marginHop = this.getParameterHop("margin");
        Hop selectHop = this.getParameterHop("select");
        if (et == Types.ExecType.CP) {
            ParameterizedBuiltin pbilop = new ParameterizedBuiltin(inputlops, this._op, this.getDataType(), this.getValueType(), et);
            this.setOutputDimensions(pbilop);
            this.setLineNumbers(pbilop);
            this.setLops(pbilop);
        } else if (et == Types.ExecType.SPARK) {
            if (!(marginHop instanceof LiteralOp)) {
                throw new HopsException("Parameter 'margin' must be a literal argument.");
            }
            Hop input = targetHop;
            long rlen = input.getDim1();
            long clen = input.getDim2();
            int blen = input.getBlocksize();
            boolean rmRows = ((LiteralOp)marginHop).getStringValue().equals("rows");
            BinaryOp ppred0 = null;
            Hop emptyInd = null;
            if (selectHop == null) {
                ppred0 = HopRewriteUtils.createBinary(input, (Hop)new LiteralOp(0L), Types.OpOp2.NOTEQUAL);
                ppred0.setForcedExecType(Types.ExecType.SPARK);
                emptyInd = ppred0;
                if (!(rmRows && clen == 1L || !rmRows && rlen == 1L)) {
                    emptyInd = HopRewriteUtils.createAggUnaryOp(ppred0, Types.AggOp.MAX, rmRows ? Types.Direction.Row : Types.Direction.Col);
                    emptyInd.setForcedExecType(Types.ExecType.SPARK);
                }
            } else {
                emptyInd = selectHop;
            }
            Hop cumsumInput = emptyInd;
            if (!rmRows) {
                cumsumInput = HopRewriteUtils.createTranspose(emptyInd);
                HopRewriteUtils.updateHopCharacteristics(cumsumInput, blen, this);
            }
            UnaryOp cumsum = HopRewriteUtils.createUnary(cumsumInput, Types.OpOp1.CUMSUM);
            HopRewriteUtils.updateHopCharacteristics(cumsum, blen, this);
            MultiThreadedHop cumsumOutput = cumsum;
            if (!rmRows) {
                cumsumOutput = HopRewriteUtils.createTranspose(cumsum);
                HopRewriteUtils.updateHopCharacteristics(cumsumOutput, blen, this);
            }
            AggUnaryOp maxDim = HopRewriteUtils.createAggUnaryOp(cumsumOutput, Types.AggOp.MAX, Types.Direction.RowCol);
            HopRewriteUtils.updateHopCharacteristics(maxDim, blen, this);
            BinaryOp offsets = HopRewriteUtils.createBinary((Hop)cumsumOutput, emptyInd, Types.OpOp2.MULT);
            HopRewriteUtils.updateHopCharacteristics(offsets, blen, this);
            Lop linput = input.constructLops();
            Lop loffset = offsets.constructLops();
            Lop lmaxdim = ((Hop)maxDim).constructLops();
            HashMap<String, Lop> inMap = new HashMap<String, Lop>();
            inMap.put("target", linput);
            inMap.put("offset", loffset);
            inMap.put("maxdim", lmaxdim);
            inMap.put("margin", inputlops.get("margin"));
            inMap.put("empty.return", inputlops.get("empty.return"));
            if (!FORCE_DIST_RM_EMPTY && this.isRemoveEmptyBcSP()) {
                this._bRmEmptyBC = true;
            }
            ParameterizedBuiltin pbilop = new ParameterizedBuiltin(inMap, this._op, this.getDataType(), this.getValueType(), et, this._bRmEmptyBC);
            this.setOutputDimensions(pbilop);
            this.setLineNumbers(pbilop);
            if (selectHop == null) {
                HopRewriteUtils.removeChildReference(ppred0, input);
            }
            this.setLops(pbilop);
        }
    }

    private void constructLopsRExpand(HashMap<String, Lop> inputlops, Types.ExecType et) {
        int k = OptimizerUtils.getConstrainedNumThreads(this._maxNumThreads);
        ParameterizedBuiltin pbilop = new ParameterizedBuiltin(inputlops, this._op, this.getDataType(), this.getValueType(), et, k);
        this.setOutputDimensions(pbilop);
        this.setLineNumbers(pbilop);
        this.setLops(pbilop);
    }

    @Override
    protected double computeOutputMemEstimate(long dim1, long dim2, long nnz) {
        if (this.getOp() == Types.ParamBuiltinOp.TOSTRING) {
            long numCols;
            long numRows;
            long AVERAGE_CHARS_PER_VALUE = 7L;
            long AVERAGE_CHARS_PER_INDEX = 4L;
            long specifiedRows = 100L;
            long specifiedCols = 100L;
            boolean sparsePrint = false;
            String sep = " ";
            String linesep = "\n";
            Hop rowsHop = this.getParameterHop("rows");
            Hop colsHop = this.getParameterHop("cols");
            Hop sparsePrintHOP = this.getParameterHop("sparse");
            Hop sepHop = this.getParameterHop("sep");
            Hop linesepHop = this.getParameterHop("linesep");
            long numNonZeroes = this.getInput().get(0).getNnz();
            if (numNonZeroes < 0L) {
                numNonZeroes = specifiedRows * specifiedCols;
            }
            if ((numRows = this.getInput().get(0).getDim1()) < 0L) {
                numRows = specifiedRows;
            }
            if ((numCols = this.getInput().get(0).getDim2()) < 0L) {
                numCols = specifiedCols;
            }
            long DEFAULT_SIZE = 160036L;
            try {
                if (rowsHop != null && rowsHop instanceof LiteralOp) {
                    specifiedRows = ((LiteralOp)rowsHop).getLongValue();
                }
                long l = numRows = numRows < specifiedRows ? numRows : specifiedRows;
                if (colsHop != null && colsHop instanceof LiteralOp) {
                    specifiedCols = ((LiteralOp)colsHop).getLongValue();
                }
                long l2 = numCols = numCols < specifiedCols ? numCols : specifiedCols;
                if (sparsePrintHOP != null && sparsePrintHOP instanceof LiteralOp) {
                    sparsePrint = ((LiteralOp)sparsePrintHOP).getBooleanValue();
                }
                if (sepHop != null && sepHop instanceof LiteralOp) {
                    sep = ((LiteralOp)sepHop).getStringValue();
                }
                if (linesepHop != null && linesepHop instanceof LiteralOp) {
                    linesep = ((LiteralOp)linesepHop).getStringValue();
                }
                long numberOfChars = -1L;
                numberOfChars = sparsePrint ? 7L * numNonZeroes + 8L * numNonZeroes + (long)sep.length() * 2L * numNonZeroes + (long)linesep.length() * numNonZeroes : 7L * numRows * numCols + (long)sep.length() * numRows * (numCols - 1L) + (long)linesep.length() * numRows;
                return 36L + numberOfChars * 2L;
            }
            catch (HopsException e) {
                LOG.warn((Object)"Invalid values when trying to compute dims1, dims2 & nnz", (Throwable)e);
                return 160036.0;
            }
        }
        double sparsity = OptimizerUtils.getSparsity(dim1, dim2, nnz);
        return OptimizerUtils.estimateSizeExactSparsity(dim1, dim2, sparsity);
    }

    @Override
    protected double computeIntermediateMemEstimate(long dim1, long dim2, long nnz) {
        Hop dir;
        String dirVal;
        double ret = 0.0;
        if (this._op == Types.ParamBuiltinOp.RMEMPTY) {
            boolean cols;
            Hop marginHop = this.getParameterHop("margin");
            boolean bl = cols = marginHop instanceof LiteralOp && "cols".equals(((LiteralOp)marginHop).getStringValue());
            if (cols) {
                ret += (double)(1L * dim2);
                ret += (double)(4L * dim2);
            } else {
                ret += (double)(1L * dim1);
            }
        } else if (this._op == Types.ParamBuiltinOp.REXPAND && "rows".equals(dirVal = ((LiteralOp)(dir = this.getParameterHop("dir"))).getStringValue())) {
            ret = 12L * Math.min(dim1, 0x100000L);
        }
        return ret;
    }

    @Override
    protected DataCharacteristics inferOutputCharacteristics(MemoTable memo) {
        MatrixCharacteristics ret = null;
        Hop input = this.getTargetHop();
        DataCharacteristics dc = memo.getAllInputStats(input);
        if (this._op == Types.ParamBuiltinOp.GROUPEDAGG) {
            long n;
            Hop ngroups;
            if (this._paramIndexMap.get("ngroups") != null && (ngroups = this.getParameterHop("ngroups")) != null && ngroups instanceof LiteralOp) {
                long m = HopRewriteUtils.getIntValueSafe((LiteralOp)ngroups);
                long n2 = dc.getRows() == 1L ? 1L : dc.getCols();
                return new MatrixCharacteristics(m, n2, -1, m);
            }
            long m = dc.getRows();
            long l = n = dc.getRows() == 1L ? 1L : dc.getCols();
            if (m >= 1L) {
                ret = new MatrixCharacteristics(m, n, -1, m);
            }
        } else if (this._op == Types.ParamBuiltinOp.RMEMPTY) {
            if (dc.dimsKnown()) {
                String margin = "rows";
                Hop marginHop = this.getParameterHop("margin");
                if (marginHop instanceof LiteralOp && "cols".equals(((LiteralOp)marginHop).getStringValue())) {
                    margin = new String("cols");
                }
                DataCharacteristics dcSelect = null;
                if (this._paramIndexMap.get("select") != null) {
                    Hop select = this.getParameterHop("select");
                    dcSelect = memo.getAllInputStats(select);
                }
                long lDim1 = 0L;
                long lDim2 = 0L;
                if (margin.equals("rows")) {
                    lDim1 = dcSelect == null || !dcSelect.nnzKnown() ? dc.getRows() : dcSelect.getNonZeros();
                    lDim2 = dc.getCols();
                } else {
                    lDim1 = dc.getRows();
                    lDim2 = dcSelect == null || !dcSelect.nnzKnown() ? dc.getCols() : dcSelect.getNonZeros();
                }
                ret = new MatrixCharacteristics(lDim1, lDim2, -1, dc.getNonZeros());
            }
        } else if (this._op == Types.ParamBuiltinOp.REPLACE) {
            if (dc.dimsKnown()) {
                long lnnz = this.isNonZeroReplaceArguments() ? dc.getNonZeros() : -1L;
                ret = new MatrixCharacteristics(dc.getRows(), dc.getCols(), -1, lnnz);
            }
        } else if (this._op == Types.ParamBuiltinOp.REXPAND) {
            Hop max = this.getParameterHop("max");
            Hop dir = this.getParameterHop("dir");
            long maxVal = this.computeDimParameterInformation(max, memo);
            String dirVal = ((LiteralOp)dir).getStringValue();
            if (dc.dimsKnown()) {
                long lnnz;
                long l = lnnz = dc.nnzKnown() ? dc.getNonZeros() : dc.getRows();
                if ("cols".equals(dirVal)) {
                    ret = new MatrixCharacteristics(dc.getRows(), maxVal, -1, lnnz);
                } else if ("rows".equals(dirVal)) {
                    ret = new MatrixCharacteristics(maxVal, dc.getRows(), -1, lnnz);
                }
            }
        } else if (this._op == Types.ParamBuiltinOp.TRANSFORMDECODE ? dc.dimsKnown() : this._op == Types.ParamBuiltinOp.TRANSFORMAPPLY && dc.dimsKnown()) {
            return new MatrixCharacteristics(dc.getRows(), dc.getCols(), -1, dc.getLength());
        }
        return ret;
    }

    @Override
    public boolean allowsAllExecTypes() {
        return false;
    }

    @Override
    protected Types.ExecType optFindExecType(boolean transitive) {
        this.checkAndSetForcedPlatform();
        if (this._etypeForced != null) {
            this._etype = this._etypeForced;
        } else {
            this._etype = OptimizerUtils.isMemoryBasedOptLevel() ? this.findExecTypeByMemEstimate() : (this._op == Types.ParamBuiltinOp.GROUPEDAGG && this.getTargetHop().areDimsBelowThreshold() ? Types.ExecType.CP : Types.ExecType.SPARK);
            this.checkAndSetInvalidCPDimsAndSize();
        }
        if (this._op == Types.ParamBuiltinOp.TRANSFORMCOLMAP || this._op == Types.ParamBuiltinOp.TRANSFORMMETA || this._op == Types.ParamBuiltinOp.TOSTRING || this._op == Types.ParamBuiltinOp.LIST || this._op == Types.ParamBuiltinOp.CDF || this._op == Types.ParamBuiltinOp.INVCDF || this._op == Types.ParamBuiltinOp.PARAMSERV) {
            this._etype = Types.ExecType.CP;
        }
        this.setRequiresRecompileIfNecessary();
        return this._etype;
    }

    @Override
    public void refreshSizeInformation() {
        switch (this._op) {
            case CDF: 
            case INVCDF: {
                break;
            }
            case GROUPEDAGG: {
                Hop target;
                Hop ngroups;
                long ldim1 = -1L;
                if (this._paramIndexMap.get("ngroups") != null && (ngroups = this.getParameterHop("ngroups")) != null && ngroups instanceof LiteralOp) {
                    ldim1 = HopRewriteUtils.getIntValueSafe((LiteralOp)ngroups);
                }
                long ldim2 = (target = this.getTargetHop()).getDim1() == 1L ? 1L : target.getDim2();
                this.setDim1(ldim1);
                this.setDim2(ldim2);
                break;
            }
            case RMEMPTY: {
                Hop target = this.getTargetHop();
                Hop margin = this.getParameterHop("margin");
                Hop select = this.getParameterHop("select");
                if (margin instanceof LiteralOp) {
                    LiteralOp lmargin = (LiteralOp)margin;
                    if ("rows".equals(lmargin.getStringValue())) {
                        this.setDim2(target.getDim2());
                        if (select != null) {
                            this.setDim1(select.getNnz());
                        }
                    } else if ("cols".equals(lmargin.getStringValue())) {
                        this.setDim1(target.getDim1());
                        if (select != null) {
                            this.setDim2(select.getNnz());
                        }
                    }
                }
                this.setNnz(target.getNnz());
                break;
            }
            case LOWER_TRI: 
            case UPPER_TRI: {
                Hop target = this.getTargetHop();
                this.setDim1(target.getDim1());
                this.setDim2(target.getDim2());
                break;
            }
            case REPLACE: {
                Hop target = this.getTargetHop();
                this.setDim1(target.getDim1());
                this.setDim2(target.getDim2());
                if (!this.isNonZeroReplaceArguments()) break;
                this.setNnz(target.getNnz());
                break;
            }
            case REXPAND: {
                Hop target = this.getTargetHop();
                Hop max = this.getParameterHop("max");
                Hop dir = this.getParameterHop("dir");
                double maxVal = ParameterizedBuiltinOp.computeSizeInformation(max);
                String dirVal = ((LiteralOp)dir).getStringValue();
                if ("cols".equals(dirVal)) {
                    this.setDim1(target.getDim1());
                    this.setDim2(UtilFunctions.toLong(maxVal));
                    break;
                }
                if (!"rows".equals(dirVal)) break;
                this.setDim1(UtilFunctions.toLong(maxVal));
                this.setDim2(target.getDim1());
                break;
            }
            case TRANSFORMDECODE: {
                Hop target = this.getTargetHop();
                this.setDim1(target.getDim1());
                break;
            }
            case TRANSFORMAPPLY: {
                break;
            }
            case TRANSFORMCOLMAP: {
                Hop target = this.getTargetHop();
                this.setDim1(target.getDim2());
                this.setDim2(3L);
                break;
            }
            case LIST: {
                this.setDim1(this.getInput().size());
                this.setDim2(1L);
                break;
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ParameterizedBuiltinOp ret = new ParameterizedBuiltinOp();
        ret.clone(this, false);
        ret._op = this._op;
        ret._outputEmptyBlocks = this._outputEmptyBlocks;
        ret._outputPermutationMatrix = this._outputPermutationMatrix;
        ret._paramIndexMap = (HashMap)this._paramIndexMap.clone();
        return ret;
    }

    @Override
    public boolean compare(Hop that) {
        boolean ret;
        if (!(that instanceof ParameterizedBuiltinOp)) {
            return false;
        }
        ParameterizedBuiltinOp that2 = (ParameterizedBuiltinOp)that;
        boolean bl = ret = this._op == that2._op && this._paramIndexMap != null && that2._paramIndexMap != null && this._paramIndexMap.size() == that2._paramIndexMap.size() && this._outputEmptyBlocks == that2._outputEmptyBlocks && this._outputPermutationMatrix == that2._outputPermutationMatrix;
        if (ret) {
            for (Map.Entry<String, Integer> e : this._paramIndexMap.entrySet()) {
                String key1 = e.getKey();
                int pos1 = e.getValue();
                int pos2 = that2._paramIndexMap.get(key1);
                ret &= that2.getInput().get(pos2) != null && this.getInput().get(pos1) == that2.getInput().get(pos2);
            }
        }
        return ret;
    }

    @Override
    public boolean isTransposeSafe() {
        boolean ret = false;
        try {
            if (this._op == Types.ParamBuiltinOp.GROUPEDAGG) {
                int ix = this._paramIndexMap.get("fn");
                Hop fnHop = this.getInput().get(ix);
                ret = fnHop instanceof LiteralOp && "sum".equals(((LiteralOp)fnHop).getStringValue());
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)"Check for transpose-safeness failed, continue assuming false.", (Throwable)ex);
        }
        return ret;
    }

    public boolean isCountFunction() {
        boolean ret = false;
        try {
            if (this._op == Types.ParamBuiltinOp.GROUPEDAGG) {
                Hop fnHop = this.getParameterHop("fn");
                ret = fnHop instanceof LiteralOp && "count".equals(((LiteralOp)fnHop).getStringValue());
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)"Check for count function failed, continue assuming false.", (Throwable)ex);
        }
        return ret;
    }

    private boolean isNonZeroReplaceArguments() {
        boolean ret = false;
        try {
            Hop pattern = this.getParameterHop("pattern");
            Hop replace = this.getParameterHop("replacement");
            if (pattern instanceof LiteralOp && ((LiteralOp)pattern).getDoubleValue() != 0.0 && replace instanceof LiteralOp && ((LiteralOp)replace).getDoubleValue() != 0.0) {
                ret = true;
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)("Non Zero Replace Arguments exception: " + ex.getMessage()));
        }
        return ret;
    }

    public boolean isKnownNGroups() {
        try {
            Hop ngroups = this.getParameterHop("ngroups");
            return ngroups != null && ngroups instanceof LiteralOp | ngroups instanceof DataOp;
        }
        catch (Exception ex) {
            LOG.warn((Object)("Known groups check exception: " + ex.getMessage()));
            return false;
        }
    }

    public boolean isTargetDiagInput() {
        Hop targetHop = this.getTargetHop();
        return targetHop instanceof ReorgOp && ((ReorgOp)targetHop).getOp() == Types.ReOrgOp.DIAG && targetHop.getInput().get(0).getDim2() == 1L;
    }

    public List<FunctionOp> getParamservPseudoFunctionCalls() {
        try {
            String[] supd = DMLProgram.splitFunctionKey(((LiteralOp)this.getParameterHop("upd")).getStringValue());
            String[] sagg = DMLProgram.splitFunctionKey(((LiteralOp)this.getParameterHop("agg")).getStringValue());
            String[] sval = this.getParameterHop("val") == null ? null : DMLProgram.splitFunctionKey(((LiteralOp)this.getParameterHop("val")).getStringValue());
            Hop model = this.getParameterHop("model");
            Hop hyp = this.getParameterHop("hyperparams");
            Hop batch = (Hop)ObjectUtils.defaultIfNull((Object)this.getParameterHop("batchsize"), (Object)new LiteralOp(64L));
            IndexingOp X = HopRewriteUtils.createIndexingOp(this.getParameterHop("features"), batch);
            IndexingOp y = HopRewriteUtils.createIndexingOp(this.getParameterHop("labels"), batch);
            FunctionOp fupd = new FunctionOp(FunctionOp.FunctionType.DML, supd[0], supd[1], new String[]{"model", "hyperparams", "features", "labels"}, Arrays.asList(model, hyp, X, y), new String[]{"gradients"}, false, true);
            FunctionOp fagg = new FunctionOp(FunctionOp.FunctionType.DML, sagg[0], sagg[1], new String[]{"model", "hyperparams", "gradients"}, Arrays.asList(model, hyp, fupd), new String[]{"model"}, false, true);
            FunctionOp fval = sval == null ? null : new FunctionOp(FunctionOp.FunctionType.DML, sval[0], sval[1], new String[]{"model", "hyperparams", "valfeatures", "vallabels"}, Arrays.asList(model, hyp, this.getParameterHop("val_features"), this.getParameterHop("val_labels")), new String[]{"loss", "accuracy"}, false, true);
            return sval == null ? Arrays.asList(fupd, fagg) : Arrays.asList(fupd, fagg, fval);
        }
        catch (Exception ex) {
            return Collections.emptyList();
        }
    }

    private boolean isRemoveEmptyBcSP() {
        boolean col;
        Hop input = this.getInput().get(0);
        Hop margin = this.getParameterHop("margin");
        boolean bl = col = margin instanceof LiteralOp ? ((LiteralOp)margin).getStringValue().equals("cols") : false;
        double size = input.dimsKnown() ? (double)OptimizerUtils.estimateSize(col ? input.getDim2() : input.getDim1(), 1L) : input.getOutputMemEstimate();
        return OptimizerUtils.checkSparkBroadcastMemoryBudget(size);
    }
}

