/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.spark;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.broadcast.Broadcast;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.caching.FrameObject;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.functionobjects.KahanPlus;
import org.apache.sysds.runtime.functionobjects.ParameterizedBuiltin;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.BooleanObject;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObjectFactory;
import org.apache.sysds.runtime.instructions.spark.ComputationSPInstruction;
import org.apache.sysds.runtime.instructions.spark.SPInstruction;
import org.apache.sysds.runtime.instructions.spark.data.IndexedMatrixValue;
import org.apache.sysds.runtime.instructions.spark.data.LazyIterableIterator;
import org.apache.sysds.runtime.instructions.spark.data.PartitionedBroadcast;
import org.apache.sysds.runtime.instructions.spark.functions.ExtractGroup;
import org.apache.sysds.runtime.instructions.spark.functions.ExtractGroupNWeights;
import org.apache.sysds.runtime.instructions.spark.functions.PerformGroupByAggInCombiner;
import org.apache.sysds.runtime.instructions.spark.functions.PerformGroupByAggInReducer;
import org.apache.sysds.runtime.instructions.spark.functions.ReplicateVectorFunction;
import org.apache.sysds.runtime.instructions.spark.utils.FrameRDDAggregateUtils;
import org.apache.sysds.runtime.instructions.spark.utils.FrameRDDConverterUtils;
import org.apache.sysds.runtime.instructions.spark.utils.RDDAggregateUtils;
import org.apache.sysds.runtime.instructions.spark.utils.RDDConverterUtils;
import org.apache.sysds.runtime.instructions.spark.utils.SparkUtils;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.lineage.LineageItemUtils;
import org.apache.sysds.runtime.matrix.data.LibMatrixReorg;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixCell;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.matrix.data.OperationsOnMatrixValues;
import org.apache.sysds.runtime.matrix.data.WeightedCell;
import org.apache.sysds.runtime.matrix.operators.AggregateOperator;
import org.apache.sysds.runtime.matrix.operators.CMOperator;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.matrix.operators.SimpleOperator;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;
import org.apache.sysds.runtime.transform.TfUtils;
import org.apache.sysds.runtime.transform.decode.Decoder;
import org.apache.sysds.runtime.transform.decode.DecoderFactory;
import org.apache.sysds.runtime.transform.encode.EncoderFactory;
import org.apache.sysds.runtime.transform.encode.MultiColumnEncoder;
import org.apache.sysds.runtime.transform.meta.TfMetaUtils;
import org.apache.sysds.runtime.transform.meta.TfOffsetMap;
import org.apache.sysds.runtime.transform.tokenize.Tokenizer;
import org.apache.sysds.runtime.transform.tokenize.TokenizerFactory;
import org.apache.sysds.runtime.util.DataConverter;
import org.apache.sysds.runtime.util.UtilFunctions;
import org.apache.sysds.utils.stats.SparkStatistics;
import scala.Tuple2;

public class ParameterizedBuiltinSPInstruction
extends ComputationSPInstruction {
    protected HashMap<String, String> params;

    ParameterizedBuiltinSPInstruction(Operator op, HashMap<String, String> paramsMap, CPOperand out, String opcode, String istr) {
        super(SPInstruction.SPType.ParameterizedBuiltin, op, null, null, out, opcode, istr);
        this.params = paramsMap;
    }

    public HashMap<String, String> getParams() {
        return this.params;
    }

    public CacheableData<?> getTarget(ExecutionContext ec) {
        return ec.getCacheableData(this.params.get("target"));
    }

    public static HashMap<String, String> constructParameterMap(String[] params) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (int i = 1; i <= params.length - 2; ++i) {
            String[] parts = params[i].split("=");
            paramMap.put(parts[0], parts[1]);
        }
        return paramMap;
    }

    public static ParameterizedBuiltinSPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (opcode.equalsIgnoreCase("mapgroupedagg")) {
            CPOperand target = new CPOperand(parts[1]);
            CPOperand groups = new CPOperand(parts[2]);
            CPOperand out = new CPOperand(parts[3]);
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            paramsMap.put("target", target.getName());
            paramsMap.put("groups", groups.getName());
            paramsMap.put("ngroups", parts[4]);
            AggregateOperator op = new AggregateOperator(0.0, KahanPlus.getKahanPlusFnObject(), Types.CorrectionLocationType.LASTCOLUMN);
            return new ParameterizedBuiltinSPInstruction(op, paramsMap, out, opcode, str);
        }
        CPOperand out = new CPOperand(parts[parts.length - 1]);
        HashMap<String, String> paramsMap = ParameterizedBuiltinSPInstruction.constructParameterMap(parts);
        ParameterizedBuiltin func = null;
        if (opcode.equalsIgnoreCase("groupedagg")) {
            String fnStr = paramsMap.get("fn");
            if (fnStr == null) {
                throw new DMLRuntimeException("Function parameter is missing in groupedAggregate.");
            }
            if (fnStr.equalsIgnoreCase("centralmoment") && paramsMap.get("order") == null) {
                throw new DMLRuntimeException("Mandatory \"order\" must be specified when fn=\"centralmoment\" in groupedAggregate.");
            }
            Operator op = InstructionUtils.parseGroupedAggOperator(fnStr, paramsMap.get("order"));
            return new ParameterizedBuiltinSPInstruction(op, paramsMap, out, opcode, str);
        }
        if (opcode.equalsIgnoreCase("rmempty")) {
            func = ParameterizedBuiltin.getParameterizedBuiltinFnObject(opcode);
            return new ParameterizedBuiltinSPInstruction(new SimpleOperator(func), paramsMap, out, opcode, str);
        }
        if (opcode.equalsIgnoreCase("rexpand") || opcode.equalsIgnoreCase("replace") || opcode.equalsIgnoreCase("lowertri") || opcode.equalsIgnoreCase("uppertri") || opcode.equalsIgnoreCase("tokenize") || opcode.equalsIgnoreCase("transformapply") || opcode.equalsIgnoreCase("transformdecode")) {
            func = ParameterizedBuiltin.getParameterizedBuiltinFnObject(opcode);
            return new ParameterizedBuiltinSPInstruction(new SimpleOperator(func), paramsMap, out, opcode, str);
        }
        if (opcode.equalsIgnoreCase("contains")) {
            return new ParameterizedBuiltinSPInstruction(null, paramsMap, out, opcode, str);
        }
        throw new DMLRuntimeException("Unknown opcode (" + opcode + ") for ParameterizedBuiltin Instruction.");
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        String opcode = this.getOpcode();
        if (opcode.equalsIgnoreCase("mapgroupedagg")) {
            String targetVar = this.params.get("target");
            String groupsVar = this.params.get("groups");
            JavaPairRDD<MatrixIndexes, MatrixBlock> target = sec.getBinaryMatrixBlockRDDHandleForVariable(targetVar);
            PartitionedBroadcast<MatrixBlock> groups = sec.getBroadcastForVariable(groupsVar);
            DataCharacteristics mc1 = sec.getDataCharacteristics(targetVar);
            DataCharacteristics mcOut = sec.getDataCharacteristics(this.output.getName());
            CPOperand ngrpOp = new CPOperand(this.params.get("ngroups"));
            int ngroups = (int)sec.getScalarInput(ngrpOp).getLongValue();
            if (ngroups <= mc1.getBlocksize() && mc1.getCols() <= (long)mc1.getBlocksize()) {
                JavaRDD<MatrixBlock> out = target.map(new RDDMapGroupedAggFunction2(groups, this._optr, ngroups));
                MatrixBlock out2 = RDDAggregateUtils.sumStable(out);
                sec.setMatrixOutput(this.output.getName(), out2);
            } else {
                JavaPairRDD<MatrixIndexes, MatrixBlock> out = target.flatMapToPair(new RDDMapGroupedAggFunction(groups, this._optr, ngroups, mc1.getBlocksize()));
                out = RDDAggregateUtils.sumByKeyStable(out, false);
                mcOut.set(ngroups, mc1.getCols(), mc1.getBlocksize(), -1L);
                sec.setRDDHandleForVariable(this.output.getName(), out);
                sec.addLineageRDD(this.output.getName(), targetVar);
                sec.addLineageBroadcast(this.output.getName(), groupsVar);
            }
        } else if (opcode.equalsIgnoreCase("groupedagg")) {
            boolean broadcastGroups = Boolean.parseBoolean(this.params.get("broadcast"));
            String groupsVar = this.params.get("groups");
            JavaPairRDD<MatrixIndexes, MatrixBlock> target = sec.getBinaryMatrixBlockRDDHandleForVariable(this.params.get("target"));
            JavaPairRDD<MatrixIndexes, MatrixBlock> groups = broadcastGroups ? null : sec.getBinaryMatrixBlockRDDHandleForVariable(groupsVar);
            JavaPairRDD<MatrixIndexes, MatrixBlock> weights = null;
            DataCharacteristics mc1 = sec.getDataCharacteristics(this.params.get("target"));
            DataCharacteristics mc2 = sec.getDataCharacteristics(groupsVar);
            if (mc1.dimsKnown() && mc2.dimsKnown() && (mc1.getRows() != mc2.getRows() || mc2.getCols() != 1L)) {
                throw new DMLRuntimeException("Grouped Aggregate dimension mismatch between target and groups.");
            }
            DataCharacteristics mcOut = sec.getDataCharacteristics(this.output.getName());
            JavaPairRDD<MatrixIndexes, WeightedCell> groupWeightedCells = null;
            if (this.params.get("weights") != null) {
                weights = sec.getBinaryMatrixBlockRDDHandleForVariable(this.params.get("weights"));
                DataCharacteristics mc3 = sec.getDataCharacteristics(this.params.get("weights"));
                if (mc1.dimsKnown() && mc3.dimsKnown() && (mc1.getRows() != mc3.getRows() || mc1.getCols() != mc3.getCols())) {
                    throw new DMLRuntimeException("Grouped Aggregate dimension mismatch between target, groups, and weights.");
                }
                groupWeightedCells = groups.join(target).join(weights).flatMapToPair(new ExtractGroupNWeights());
            } else {
                long ngroups;
                String ngroupsStr = this.params.get("ngroups");
                long l = ngroups = ngroupsStr != null ? (long)Double.parseDouble(ngroupsStr) : -1L;
                if (broadcastGroups) {
                    PartitionedBroadcast<MatrixBlock> pbm = sec.getBroadcastForVariable(groupsVar);
                    groupWeightedCells = target.flatMapToPair(new ExtractGroup.ExtractGroupBroadcast(pbm, mc1.getBlocksize(), ngroups, this._optr));
                } else {
                    if (mc1.getNumColBlocks() > 1L) {
                        groups = groups.flatMapToPair(new ReplicateVectorFunction(false, mc1.getNumColBlocks()));
                    }
                    groupWeightedCells = groups.join(target).flatMapToPair(new ExtractGroup.ExtractGroupJoin(mc1.getBlocksize(), ngroups, this._optr));
                }
            }
            if (mc1.getBlocksize() == -1) {
                throw new DMLRuntimeException("The block sizes are not specified for grouped aggregate");
            }
            int blen = mc1.getBlocksize();
            JavaPairRDD<MatrixIndexes, MatrixCell> out = null;
            out = this._optr instanceof CMOperator && ((CMOperator)this._optr).isPartialAggregateOperator() || this._optr instanceof AggregateOperator ? groupWeightedCells.reduceByKey(new PerformGroupByAggInCombiner(this._optr)).mapValues(new CreateMatrixCell(blen, this._optr)) : groupWeightedCells.groupByKey().mapValues(new PerformGroupByAggInReducer(this._optr)).mapValues(new CreateMatrixCell(blen, this._optr));
            this.setOutputCharacteristicsForGroupedAgg(mc1, mcOut, out);
            sec.setRDDHandleForVariable(this.output.getName(), out);
            sec.addLineageRDD(this.output.getName(), this.params.get("target"));
            sec.addLineage(this.output.getName(), groupsVar, broadcastGroups);
            if (this.params.get("weights") != null) {
                sec.addLineageRDD(this.output.getName(), this.params.get("weights"));
            }
        } else if (opcode.equalsIgnoreCase("rmempty")) {
            String rddInVar = this.params.get("target");
            String rddOffVar = this.params.get("offset");
            boolean rows = sec.getScalarInput(this.params.get("margin"), Types.ValueType.STRING, true).getStringValue().equals("rows");
            boolean emptyReturn = Boolean.parseBoolean(this.params.get("empty.return").toLowerCase());
            long maxDim = sec.getScalarInput(this.params.get("maxdim"), Types.ValueType.FP64, false).getLongValue();
            boolean bRmEmptyBC = Boolean.parseBoolean(this.params.get("bRmEmptyBC"));
            DataCharacteristics mcIn = sec.getDataCharacteristics(rddInVar);
            if (maxDim > 0L) {
                JavaPairRDD<MatrixIndexes, MatrixBlock> out;
                JavaPairRDD<MatrixIndexes, MatrixBlock> in = sec.getBinaryMatrixBlockRDDHandleForVariable(rddInVar);
                long blen = mcIn.getBlocksize();
                long numRep = (long)Math.ceil(rows ? (double)mcIn.getCols() / (double)blen : (double)mcIn.getRows() / (double)blen);
                if (bRmEmptyBC) {
                    PartitionedBroadcast<MatrixBlock> broadcastOff = sec.getBroadcastForVariable(rddOffVar);
                    out = in.flatMapToPair(new RDDRemoveEmptyFunctionInMem(rows, maxDim, blen, broadcastOff));
                } else {
                    JavaPairRDD<MatrixIndexes, MatrixBlock> off = sec.getBinaryMatrixBlockRDDHandleForVariable(rddOffVar);
                    out = in.join(off.flatMapToPair(new ReplicateVectorFunction(!rows, numRep))).flatMapToPair(new RDDRemoveEmptyFunction(rows, maxDim, blen));
                }
                out = RDDAggregateUtils.mergeByKey(out, false);
                sec.setRDDHandleForVariable(this.output.getName(), out);
                sec.addLineageRDD(this.output.getName(), rddInVar);
                if (bRmEmptyBC) {
                    sec.addLineageBroadcast(this.output.getName(), rddOffVar);
                } else {
                    sec.addLineageRDD(this.output.getName(), rddOffVar);
                }
                DataCharacteristics mcOut = sec.getDataCharacteristics(this.output.getName());
                mcOut.set(rows ? maxDim : mcIn.getRows(), rows ? mcIn.getCols() : maxDim, (int)blen, mcIn.getNonZeros());
            } else {
                int n = emptyReturn ? 1 : 0;
                MatrixBlock out = new MatrixBlock(rows ? n : (int)mcIn.getRows(), rows ? (int)mcIn.getCols() : n, true);
                sec.setMatrixOutput(this.output.getName(), out);
            }
        } else if (opcode.equalsIgnoreCase("contains")) {
            JavaPairRDD<MatrixIndexes, MatrixBlock> in1 = sec.getBinaryMatrixBlockRDDHandleForVariable(this.params.get("target"));
            Data pattern = ec.getVariable(this.params.get("pattern"));
            if (pattern == null) {
                pattern = ScalarObjectFactory.createScalarObject(Types.ValueType.FP64, this.params.get("pattern"));
            }
            boolean ret = false;
            if (pattern.getDataType().isScalar()) {
                double dpattern = ((ScalarObject)pattern).getDoubleValue();
                ret = (Double)in1.values().map(new RDDContainsFunction(dpattern)).reduce((Function2 & Serializable)(a, b) -> a + b) > 0.0;
            } else {
                DataCharacteristics dc;
                PartitionedBroadcast<MatrixBlock> bc = sec.getBroadcastForVariable(this.params.get("pattern"));
                ret = (long)((Integer)in1.flatMapToPair(new RDDContainsVectFunction(bc, (dc = sec.getDataCharacteristics(this.params.get("target"))).getBlocksize())).reduceByKey((Function2<Integer, Integer, Integer>)(Function2 & Serializable)(a, b) -> a + b).values().reduce((Function2 & Serializable)(a, b) -> Math.max(a, b))).intValue() == dc.getNumColBlocks();
            }
            ec.setScalarOutput(this.output.getName(), new BooleanObject(ret));
        } else if (opcode.equalsIgnoreCase("replace")) {
            if (sec.isFrameObject(this.params.get("target"))) {
                this.params.get("target");
                JavaPairRDD<Long, FrameBlock> in1 = sec.getFrameBinaryBlockRDDHandleForVariable(this.params.get("target"));
                DataCharacteristics mcIn = sec.getDataCharacteristics(this.params.get("target"));
                String pattern = this.params.get("pattern");
                String replacement = this.params.get("replacement");
                JavaPairRDD<Long, FrameBlock> out = in1.mapValues(new RDDFrameReplaceFunction(pattern, replacement));
                sec.setRDDHandleForVariable(this.output.getName(), out);
                sec.addLineageRDD(this.output.getName(), this.params.get("target"));
                sec.getDataCharacteristics(this.output.getName()).set(mcIn.getRows(), mcIn.getCols(), mcIn.getBlocksize(), mcIn.getNonZeros());
            } else {
                JavaPairRDD<MatrixIndexes, MatrixBlock> in1 = sec.getBinaryMatrixBlockRDDHandleForVariable(this.params.get("target"));
                DataCharacteristics mcIn = sec.getDataCharacteristics(this.params.get("target"));
                double pattern = Double.parseDouble(this.params.get("pattern"));
                double replacement = Double.parseDouble(this.params.get("replacement"));
                JavaPairRDD<MatrixIndexes, MatrixBlock> out = in1.mapValues(new RDDReplaceFunction(pattern, replacement));
                sec.setRDDHandleForVariable(this.output.getName(), out);
                sec.addLineageRDD(this.output.getName(), this.params.get("target"));
                sec.getDataCharacteristics(this.output.getName()).set(mcIn.getRows(), mcIn.getCols(), mcIn.getBlocksize(), pattern != 0.0 && replacement != 0.0 ? mcIn.getNonZeros() : -1L);
            }
        } else if (opcode.equalsIgnoreCase("lowertri") || opcode.equalsIgnoreCase("uppertri")) {
            JavaPairRDD<MatrixIndexes, MatrixBlock> in1 = sec.getBinaryMatrixBlockRDDHandleForVariable(this.params.get("target"));
            DataCharacteristics mcIn = sec.getDataCharacteristics(this.params.get("target"));
            boolean lower = opcode.equalsIgnoreCase("lowertri");
            boolean diag = Boolean.parseBoolean(this.params.get("diag"));
            boolean values = Boolean.parseBoolean(this.params.get("values"));
            JavaPairRDD<MatrixIndexes, MatrixBlock> out = in1.mapPartitionsToPair(new RDDExtractTriangularFunction(lower, diag, values), true);
            sec.setRDDHandleForVariable(this.output.getName(), out);
            sec.addLineageRDD(this.output.getName(), this.params.get("target"));
            sec.getDataCharacteristics(this.output.getName()).setDimension(mcIn.getRows(), mcIn.getCols());
        } else if (opcode.equalsIgnoreCase("rexpand")) {
            long blen;
            String rddInVar = this.params.get("target");
            JavaPairRDD<MatrixIndexes, MatrixBlock> in = sec.getBinaryMatrixBlockRDDHandleForVariable(rddInVar);
            DataCharacteristics mcIn = sec.getDataCharacteristics(rddInVar);
            String maxValName = this.params.get("max");
            long lmaxVal = maxValName.startsWith("_Var") ? ec.getScalarInput(maxValName, Types.ValueType.FP64, false).getLongValue() : UtilFunctions.toLong(Double.parseDouble(maxValName));
            boolean dirRows = this.params.get("dir").equals("rows");
            boolean cast = Boolean.parseBoolean(this.params.get("cast"));
            boolean ignore = Boolean.parseBoolean(this.params.get("ignore"));
            MatrixCharacteristics mcTmp = new MatrixCharacteristics(dirRows ? lmaxVal : mcIn.getRows(), dirRows ? mcIn.getRows() : lmaxVal, (int)(blen = (long)mcIn.getBlocksize()), mcIn.getRows());
            int numParts = (int)Math.min((long)SparkUtils.getNumPreferredPartitions((DataCharacteristics)mcTmp, in), mcIn.getNumBlocks());
            if (numParts > in.getNumPartitions() * 2) {
                in = in.repartition(numParts);
            }
            JavaPairRDD<MatrixIndexes, MatrixBlock> out = in.flatMapToPair(new RDDRExpandFunction(lmaxVal, dirRows, cast, ignore, blen));
            sec.setRDDHandleForVariable(this.output.getName(), out);
            sec.addLineageRDD(this.output.getName(), rddInVar);
            DataCharacteristics mcOut = sec.getDataCharacteristics(this.output.getName());
            mcOut.set(dirRows ? lmaxVal : mcIn.getRows(), dirRows ? mcIn.getRows() : lmaxVal, (int)blen, -1L);
            mcOut.setNonZerosBound(mcIn.getRows());
            SparkUtils.postprocessUltraSparseOutput(sec.getMatrixObject(this.output), mcOut);
        } else if (opcode.equalsIgnoreCase("tokenize")) {
            FrameObject fo = sec.getFrameObject(this.params.get("target"));
            JavaPairRDD<?, ?> in = sec.getRDDHandleForFrameObject(fo, Types.FileFormat.BINARY);
            DataCharacteristics mc = sec.getDataCharacteristics(this.params.get("target"));
            Tokenizer tokenizer = TokenizerFactory.createTokenizer(this.params.get("spec"), Integer.parseInt(this.params.get("max_tokens")));
            JavaPairRDD<Long, FrameBlock> out = in.mapToPair(new RDDTokenizeFunction(tokenizer, mc.getBlocksize()));
            sec.setRDDHandleForVariable(this.output.getName(), out);
            sec.addLineageRDD(this.output.getName(), this.params.get("target"));
            long numRows = tokenizer.getMaxNumRows((int)mc.getRows());
            long numCols = tokenizer.getNumCols();
            sec.getDataCharacteristics(this.output.getName()).set(numRows, numCols, mc.getBlocksize());
            sec.getFrameObject(this.output.getName()).setSchema(tokenizer.getSchema());
        } else if (opcode.equalsIgnoreCase("transformapply")) {
            JavaPairRDD<MatrixIndexes, MatrixBlock> out;
            Broadcast<TfOffsetMap> bomap;
            FrameObject fo = sec.getFrameObject(this.params.get("target"));
            JavaPairRDD<Long, FrameBlock> in = sec.getRDDHandleForFrameObject(fo, Types.FileFormat.BINARY);
            FrameBlock meta = sec.getFrameInput(this.params.get("meta"));
            MatrixBlock embeddings = this.params.get("embedding") != null ? ec.getMatrixInput(this.params.get("embedding")) : null;
            DataCharacteristics mcIn = sec.getDataCharacteristics(this.params.get("target"));
            DataCharacteristics mcOut = sec.getDataCharacteristics(this.output.getName());
            String[] colnames = !TfMetaUtils.isIDSpec(this.params.get("spec")) ? ((FrameBlock)in.lookup(1L).get(0)).getColumnNames() : null;
            TfOffsetMap omap = null;
            if (TfMetaUtils.containsOmitSpec(this.params.get("spec"), colnames)) {
                omap = new TfOffsetMap(SparkUtils.toIndexedLong(in.mapToPair(new RDDTransformApplyOffsetFunction(this.params.get("spec"), colnames)).collect()));
            }
            MultiColumnEncoder encoder = EncoderFactory.createEncoder(this.params.get("spec"), colnames, fo.getSchema(), (int)fo.getNumColumns(), meta, embeddings);
            encoder.updateAllDCEncoders();
            mcOut.setDimension(mcIn.getRows() - (omap != null ? omap.getNumRmRows() : 0L), encoder.getNumOutCols());
            long t0 = System.nanoTime();
            Broadcast<MultiColumnEncoder> bmeta = sec.getSparkContext().broadcast(encoder);
            Broadcast<TfOffsetMap> broadcast = bomap = omap != null ? sec.getSparkContext().broadcast(omap) : null;
            if (DMLScript.STATISTICS) {
                SparkStatistics.accBroadCastTime(System.nanoTime() - t0);
                SparkStatistics.incBroadcastCount(1L);
            }
            Tuple2<Boolean, Integer> aligned = FrameRDDAggregateUtils.checkRowAlignment(in, -1);
            if (((Boolean)aligned._1).booleanValue() && mcOut.getCols() <= (long)((Integer)aligned._2).intValue() && !encoder.hasLegacyEncoder()) {
                JavaPairRDD<Long, MatrixBlock> tmp = in.mapToPair(new RDDTransformApplyFunction2(bmeta, bomap));
                mcIn.setBlocksize((Integer)aligned._2);
                mcIn.setDimension(mcIn.getRows(), mcOut.getCols());
                JavaPairRDD<MatrixIndexes, MatrixBlock> tmp2 = tmp.mapToPair((PairFunction & Serializable)in12 -> new Tuple2((Object)new MatrixIndexes(UtilFunctions.computeBlockIndex((Long)in12._1, (Integer)aligned._2), 1L), (Object)((MatrixBlock)in12._2)));
                out = RDDConverterUtils.binaryBlockToBinaryBlock(tmp2, mcIn, mcOut);
            } else {
                JavaPairRDD<Long, FrameBlock> tmp = in.mapToPair(new RDDTransformApplyFunction(bmeta, bomap));
                out = FrameRDDConverterUtils.binaryBlockToMatrixBlock(tmp, mcOut, mcOut);
            }
            sec.setRDDHandleForVariable(this.output.getName(), out);
            sec.addLineageRDD(this.output.getName(), this.params.get("target"));
            ec.releaseFrameInput(this.params.get("meta"));
            if (this.params.get("embedding") != null) {
                ec.releaseMatrixInput(this.params.get("embedding"));
            }
        } else if (opcode.equalsIgnoreCase("transformdecode")) {
            JavaPairRDD<MatrixIndexes, MatrixBlock> in = sec.getBinaryMatrixBlockRDDHandleForVariable(this.params.get("target"));
            DataCharacteristics mc = sec.getDataCharacteristics(this.params.get("target"));
            FrameBlock meta = sec.getFrameInput(this.params.get("meta"));
            String[] colnames = meta.getColumnNames();
            if (mc.getCols() > mc.getNumColBlocks()) {
                in = in.mapToPair(new RDDTransformDecodeExpandFunction((int)mc.getCols(), mc.getBlocksize()));
                in = RDDAggregateUtils.mergeByKey(in, false);
            }
            Decoder decoder = DecoderFactory.createDecoder(this.params.get("spec"), colnames, null, meta);
            JavaPairRDD<Long, FrameBlock> out = in.mapToPair(new RDDTransformDecodeFunction(decoder, mc.getBlocksize()));
            sec.setRDDHandleForVariable(this.output.getName(), out);
            sec.addLineageRDD(this.output.getName(), this.params.get("target"));
            ec.releaseFrameInput(this.params.get("meta"));
            sec.getDataCharacteristics(this.output.getName()).set(mc.getRows(), meta.getNumColumns(), mc.getBlocksize(), -1L);
            sec.getFrameObject(this.output.getName()).setSchema(decoder.getSchema());
        } else {
            throw new DMLRuntimeException("Unknown parameterized builtin opcode: " + opcode);
        }
    }

    @Override
    public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
        String opcode = this.getOpcode();
        if (opcode.equalsIgnoreCase("replace")) {
            CPOperand target = this.getTargetOperand();
            CPOperand pattern = this.getFP64Literal("pattern");
            CPOperand replace = this.getFP64Literal("replacement");
            return Pair.of((Object)this.output.getName(), (Object)new LineageItem(this.getOpcode(), LineageItemUtils.getLineage(ec, target, pattern, replace)));
        }
        if (opcode.equalsIgnoreCase("rmempty")) {
            CPOperand target = this.getTargetOperand();
            String off = this.params.get("offset");
            CPOperand offset = new CPOperand(off, Types.ValueType.FP64, Types.DataType.MATRIX);
            CPOperand margin = this.getStringLiteral("margin");
            CPOperand emptyReturn = this.getBoolLiteral("empty.return");
            CPOperand maxDim = this.getLiteral("maxdim", Types.ValueType.FP64);
            CPOperand bRmEmptyBC = this.getBoolLiteral("bRmEmptyBC");
            return Pair.of((Object)this.output.getName(), (Object)new LineageItem(this.getOpcode(), LineageItemUtils.getLineage(ec, target, offset, margin, emptyReturn, maxDim, bRmEmptyBC)));
        }
        if (opcode.equalsIgnoreCase("transformdecode") || opcode.equalsIgnoreCase("transformapply")) {
            CPOperand target = new CPOperand(this.params.get("target"), Types.ValueType.FP64, Types.DataType.FRAME);
            CPOperand meta = this.getLiteral("meta", Types.ValueType.UNKNOWN, Types.DataType.FRAME);
            CPOperand spec = this.getStringLiteral("spec");
            return Pair.of((Object)this.output.getName(), (Object)new LineageItem(this.getOpcode(), LineageItemUtils.getLineage(ec, target, meta, spec)));
        }
        if (opcode.equalsIgnoreCase("contains")) {
            CPOperand target = this.getTargetOperand();
            CPOperand pattern = this.getFP64Literal("pattern");
            return Pair.of((Object)this.output.getName(), (Object)new LineageItem(this.getOpcode(), LineageItemUtils.getLineage(ec, target, pattern)));
        }
        throw new DMLRuntimeException("Unsupported lineage tracing for: " + opcode);
    }

    private CPOperand getTargetOperand() {
        return new CPOperand(this.params.get("target"), Types.ValueType.FP64, Types.DataType.MATRIX);
    }

    private CPOperand getFP64Literal(String name) {
        return this.getLiteral(name, Types.ValueType.FP64);
    }

    private CPOperand getStringLiteral(String name) {
        return this.getLiteral(name, Types.ValueType.STRING);
    }

    private CPOperand getLiteral(String name, Types.ValueType vt) {
        return new CPOperand(this.params.get(name), vt, Types.DataType.SCALAR, true);
    }

    private CPOperand getLiteral(String name, Types.ValueType vt, Types.DataType dt) {
        return new CPOperand(this.params.get(name), vt, dt);
    }

    private CPOperand getBoolLiteral(String name) {
        return this.getLiteral(name, Types.ValueType.BOOLEAN);
    }

    public HashMap<String, String> getParameterMap() {
        return this.params;
    }

    public void setOutputCharacteristicsForGroupedAgg(DataCharacteristics mc1, DataCharacteristics mcOut, JavaPairRDD<MatrixIndexes, MatrixCell> out) {
        if (!mcOut.dimsKnown()) {
            if (!mc1.dimsKnown()) {
                throw new DMLRuntimeException("The output dimensions are not specified for grouped aggregate");
            }
            if (this.params.get("ngroups") != null) {
                int ngroups = (int)Double.parseDouble(this.params.get("ngroups"));
                mcOut.set(ngroups, mc1.getCols(), -1, -1L);
            } else {
                out = SparkUtils.cacheBinaryCellRDD(out);
                mcOut.set(SparkUtils.computeDataCharacteristics(out));
                mcOut.setBlocksize(-1);
            }
        }
    }

    public static class RDDTransformDecodeExpandFunction
    implements PairFunction<Tuple2<MatrixIndexes, MatrixBlock>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = -8187400248076127598L;
        private int _clen = -1;
        private int _blen = -1;

        public RDDTransformDecodeExpandFunction(int clen, int blen) {
            this._clen = clen;
            this._blen = blen;
        }

        public Tuple2<MatrixIndexes, MatrixBlock> call(Tuple2<MatrixIndexes, MatrixBlock> in) throws Exception {
            MatrixIndexes inIx = (MatrixIndexes)in._1();
            MatrixBlock inBlk = (MatrixBlock)in._2();
            int cl = (int)UtilFunctions.computeCellIndex(inIx.getColumnIndex(), this._blen, 0) - 1;
            int cu = (int)UtilFunctions.computeCellIndex(inIx.getColumnIndex(), this._blen, inBlk.getNumColumns() - 1) - 1;
            MatrixBlock out = new MatrixBlock(inBlk.getNumRows(), this._clen, false);
            out = out.leftIndexingOperations(inBlk, 0, inBlk.getNumRows() - 1, cl, cu, null, MatrixObject.UpdateType.INPLACE_PINNED);
            return new Tuple2((Object)new MatrixIndexes(inIx.getRowIndex(), 1L), (Object)out);
        }
    }

    public static class RDDTransformDecodeFunction
    implements PairFunction<Tuple2<MatrixIndexes, MatrixBlock>, Long, FrameBlock> {
        private static final long serialVersionUID = -4797324742568170756L;
        private Decoder _decoder = null;
        private int _blen = -1;

        public RDDTransformDecodeFunction(Decoder decoder, int blen) {
            this._decoder = decoder;
            this._blen = blen;
        }

        public Tuple2<Long, FrameBlock> call(Tuple2<MatrixIndexes, MatrixBlock> in) throws Exception {
            long rix = UtilFunctions.computeCellIndex(((MatrixIndexes)in._1()).getRowIndex(), this._blen, 0);
            FrameBlock fbout = this._decoder.decode((MatrixBlock)in._2(), new FrameBlock(this._decoder.getSchema()));
            fbout.setColumnNames(Arrays.copyOfRange(this._decoder.getColnames(), 0, fbout.getNumColumns()));
            return new Tuple2((Object)rix, (Object)fbout);
        }
    }

    public static class RDDTransformApplyFunction2
    implements PairFunction<Tuple2<Long, FrameBlock>, Long, MatrixBlock> {
        private static final long serialVersionUID = 5759813006068230916L;
        private Broadcast<MultiColumnEncoder> _bencoder = null;
        private Broadcast<TfOffsetMap> _omap = null;

        public RDDTransformApplyFunction2(Broadcast<MultiColumnEncoder> bencoder, Broadcast<TfOffsetMap> omap) {
            this._bencoder = bencoder;
            this._omap = omap;
        }

        public Tuple2<Long, MatrixBlock> call(Tuple2<Long, FrameBlock> in) throws Exception {
            long key = (Long)in._1();
            FrameBlock blk = (FrameBlock)in._2();
            MultiColumnEncoder encoder = this._bencoder.getValue();
            MatrixBlock tmp = encoder.apply(blk);
            if (this._omap != null) {
                key = this._omap.getValue().getOffset(key);
            }
            return new Tuple2((Object)key, (Object)tmp);
        }
    }

    public static class RDDTransformApplyOffsetFunction
    implements PairFunction<Tuple2<Long, FrameBlock>, Long, Long> {
        private static final long serialVersionUID = 3450977356721057440L;
        private int[] _omitColList = null;

        public RDDTransformApplyOffsetFunction(String spec, String[] colnames) {
            try {
                this._omitColList = TfMetaUtils.parseJsonIDList(spec, colnames, TfUtils.TfMethod.OMIT.toString());
            }
            catch (DMLRuntimeException e) {
                throw new RuntimeException(e);
            }
        }

        public Tuple2<Long, Long> call(Tuple2<Long, FrameBlock> in) throws Exception {
            long key = (Long)in._1();
            long rmRows = 0L;
            FrameBlock blk = (FrameBlock)in._2();
            for (int i = 0; i < blk.getNumRows(); ++i) {
                boolean valid = true;
                for (int j = 0; j < this._omitColList.length; ++j) {
                    int colID = this._omitColList[j];
                    Object val = blk.get(i, colID - 1);
                    valid &= val != null && (blk.getSchema()[colID - 1] != Types.ValueType.STRING || !val.toString().isEmpty());
                }
                rmRows += valid ? 0L : 1L;
            }
            return new Tuple2((Object)key, (Object)rmRows);
        }
    }

    public static class RDDTransformApplyFunction
    implements PairFunction<Tuple2<Long, FrameBlock>, Long, FrameBlock> {
        private static final long serialVersionUID = 5759813006068230916L;
        private Broadcast<MultiColumnEncoder> _bencoder = null;
        private Broadcast<TfOffsetMap> _omap = null;

        public RDDTransformApplyFunction(Broadcast<MultiColumnEncoder> bencoder, Broadcast<TfOffsetMap> omap) {
            this._bencoder = bencoder;
            this._omap = omap;
        }

        public Tuple2<Long, FrameBlock> call(Tuple2<Long, FrameBlock> in) throws Exception {
            long key = (Long)in._1();
            FrameBlock blk = (FrameBlock)in._2();
            MultiColumnEncoder encoder = this._bencoder.getValue();
            MatrixBlock tmp = encoder.apply(blk);
            if (this._omap != null) {
                key = this._omap.getValue().getOffset(key);
            }
            return new Tuple2((Object)key, (Object)DataConverter.convertToFrameBlock(tmp));
        }
    }

    public static class RDDTokenizeFunction
    implements PairFunction<Tuple2<Long, FrameBlock>, Long, FrameBlock> {
        private static final long serialVersionUID = -8788298032616522019L;
        private Tokenizer _tokenizer = null;

        public RDDTokenizeFunction(Tokenizer tokenizer, int blen) {
            this._tokenizer = tokenizer;
        }

        public Tuple2<Long, FrameBlock> call(Tuple2<Long, FrameBlock> in) throws Exception {
            long key = (Long)in._1();
            FrameBlock blk = (FrameBlock)in._2();
            FrameBlock fbout = this._tokenizer.tokenize(blk, OptimizerUtils.getTokenizeNumThreads());
            return new Tuple2((Object)key, (Object)fbout);
        }
    }

    public static class CreateMatrixCell
    implements Function<WeightedCell, MatrixCell> {
        private static final long serialVersionUID = -5783727852453040737L;
        int blen;
        Operator op;

        public CreateMatrixCell(int blen, Operator op) {
            this.blen = blen;
            this.op = op;
        }

        public MatrixCell call(WeightedCell kv) throws Exception {
            double val = -1.0;
            if (this.op instanceof CMOperator) {
                CMOperator.AggregateOperationTypes agg = ((CMOperator)this.op).aggOpType;
                switch (agg) {
                    case COUNT: {
                        val = kv.getWeight();
                        break;
                    }
                    case MEAN: {
                        val = kv.getValue();
                        break;
                    }
                    case MIN: {
                        val = kv.getValue();
                        break;
                    }
                    case MAX: {
                        val = kv.getValue();
                        break;
                    }
                    case CM2: {
                        val = kv.getValue() / kv.getWeight();
                        break;
                    }
                    case CM3: {
                        val = kv.getValue() / kv.getWeight();
                        break;
                    }
                    case CM4: {
                        val = kv.getValue() / kv.getWeight();
                        break;
                    }
                    case VARIANCE: {
                        val = kv.getValue() / kv.getWeight();
                        break;
                    }
                    default: {
                        throw new DMLRuntimeException("Invalid aggreagte in CM_CV_Object: " + agg);
                    }
                }
            } else {
                val = kv.getValue() / kv.getWeight();
            }
            return new MatrixCell(val);
        }
    }

    public static class RDDMapGroupedAggFunction2
    implements Function<Tuple2<MatrixIndexes, MatrixBlock>, MatrixBlock> {
        private static final long serialVersionUID = -6820599604299797661L;
        private PartitionedBroadcast<MatrixBlock> _pbm = null;
        private Operator _op = null;
        private int _ngroups = -1;

        public RDDMapGroupedAggFunction2(PartitionedBroadcast<MatrixBlock> pbm, Operator op, int ngroups) {
            this._pbm = pbm;
            this._op = op;
            this._ngroups = ngroups;
        }

        public MatrixBlock call(Tuple2<MatrixIndexes, MatrixBlock> arg0) throws Exception {
            MatrixIndexes ix = (MatrixIndexes)arg0._1();
            MatrixBlock target = (MatrixBlock)arg0._2();
            MatrixBlock groups = this._pbm.getBlock((int)ix.getRowIndex(), 1);
            return groups.groupedAggOperations(target, null, new MatrixBlock(), this._ngroups, this._op);
        }
    }

    public static class RDDMapGroupedAggFunction
    implements PairFlatMapFunction<Tuple2<MatrixIndexes, MatrixBlock>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = 6795402640178679851L;
        private PartitionedBroadcast<MatrixBlock> _pbm = null;
        private Operator _op = null;
        private int _ngroups = -1;
        private int _blen = -1;

        public RDDMapGroupedAggFunction(PartitionedBroadcast<MatrixBlock> pbm, Operator op, int ngroups, int blen) {
            this._pbm = pbm;
            this._op = op;
            this._ngroups = ngroups;
            this._blen = blen;
        }

        public Iterator<Tuple2<MatrixIndexes, MatrixBlock>> call(Tuple2<MatrixIndexes, MatrixBlock> arg0) throws Exception {
            MatrixIndexes ix = (MatrixIndexes)arg0._1();
            MatrixBlock target = (MatrixBlock)arg0._2();
            MatrixBlock groups = this._pbm.getBlock((int)ix.getRowIndex(), 1);
            IndexedMatrixValue in1 = SparkUtils.toIndexedMatrixBlock(ix, target);
            ArrayList<IndexedMatrixValue> outlist = new ArrayList<IndexedMatrixValue>();
            OperationsOnMatrixValues.performMapGroupedAggregate(this._op, in1, groups, this._ngroups, this._blen, outlist);
            return SparkUtils.fromIndexedMatrixBlock(outlist).iterator();
        }
    }

    public static class RDDRExpandFunction
    implements PairFlatMapFunction<Tuple2<MatrixIndexes, MatrixBlock>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = -6153643261956222601L;
        private final long _maxVal;
        private final boolean _dirRows;
        private final boolean _cast;
        private final boolean _ignore;
        private final long _blen;

        public RDDRExpandFunction(long maxVal, boolean dirRows, boolean cast, boolean ignore, long blen) {
            this._maxVal = maxVal;
            this._dirRows = dirRows;
            this._cast = cast;
            this._ignore = ignore;
            this._blen = blen;
        }

        public Iterator<Tuple2<MatrixIndexes, MatrixBlock>> call(Tuple2<MatrixIndexes, MatrixBlock> arg0) throws Exception {
            IndexedMatrixValue data = SparkUtils.toIndexedMatrixBlock((MatrixIndexes)arg0._1(), (MatrixBlock)arg0._2());
            ArrayList<IndexedMatrixValue> out = new ArrayList<IndexedMatrixValue>();
            LibMatrixReorg.rexpand(data, this._maxVal, this._dirRows, this._cast, this._ignore, this._blen, out);
            return SparkUtils.fromIndexedMatrixBlock(out).iterator();
        }
    }

    public static class RDDRemoveEmptyFunctionInMem
    implements PairFlatMapFunction<Tuple2<MatrixIndexes, MatrixBlock>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = 4906304771183325289L;
        private final boolean _rmRows;
        private final long _len;
        private final long _blen;
        private PartitionedBroadcast<MatrixBlock> _off = null;

        public RDDRemoveEmptyFunctionInMem(boolean rmRows, long len, long blen, PartitionedBroadcast<MatrixBlock> off) {
            this._rmRows = rmRows;
            this._len = len;
            this._blen = blen;
            this._off = off;
        }

        public Iterator<Tuple2<MatrixIndexes, MatrixBlock>> call(Tuple2<MatrixIndexes, MatrixBlock> arg0) throws Exception {
            IndexedMatrixValue data = SparkUtils.toIndexedMatrixBlock((MatrixIndexes)arg0._1(), (MatrixBlock)arg0._2());
            IndexedMatrixValue offsets = this._rmRows ? SparkUtils.toIndexedMatrixBlock((MatrixIndexes)arg0._1(), this._off.getBlock((int)((MatrixIndexes)arg0._1()).getRowIndex(), 1)) : SparkUtils.toIndexedMatrixBlock((MatrixIndexes)arg0._1(), this._off.getBlock(1, (int)((MatrixIndexes)arg0._1()).getColumnIndex()));
            ArrayList<IndexedMatrixValue> out = new ArrayList<IndexedMatrixValue>();
            LibMatrixReorg.rmempty(data, offsets, this._rmRows, this._len, this._blen, out);
            return SparkUtils.fromIndexedMatrixBlock(out).iterator();
        }
    }

    public static class RDDRemoveEmptyFunction
    implements PairFlatMapFunction<Tuple2<MatrixIndexes, Tuple2<MatrixBlock, MatrixBlock>>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = 4906304771183325289L;
        private final boolean _rmRows;
        private final long _len;
        private final long _blen;

        public RDDRemoveEmptyFunction(boolean rmRows, long len, long blen) {
            this._rmRows = rmRows;
            this._len = len;
            this._blen = blen;
        }

        public Iterator<Tuple2<MatrixIndexes, MatrixBlock>> call(Tuple2<MatrixIndexes, Tuple2<MatrixBlock, MatrixBlock>> arg0) throws Exception {
            IndexedMatrixValue data = SparkUtils.toIndexedMatrixBlock((MatrixIndexes)arg0._1(), (MatrixBlock)((Tuple2)arg0._2())._1());
            IndexedMatrixValue offsets = SparkUtils.toIndexedMatrixBlock((MatrixIndexes)arg0._1(), (MatrixBlock)((Tuple2)arg0._2())._2());
            ArrayList<IndexedMatrixValue> out = new ArrayList<IndexedMatrixValue>();
            LibMatrixReorg.rmempty(data, offsets, this._rmRows, this._len, this._blen, out);
            return SparkUtils.fromIndexedMatrixBlock(out).iterator();
        }
    }

    private static class RDDExtractTriangularFunction
    implements PairFlatMapFunction<Iterator<Tuple2<MatrixIndexes, MatrixBlock>>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = 2754868819184155702L;
        private final boolean _lower;
        private final boolean _diag;
        private final boolean _values;

        public RDDExtractTriangularFunction(boolean lower, boolean diag, boolean values) {
            this._lower = lower;
            this._diag = diag;
            this._values = values;
        }

        public LazyIterableIterator<Tuple2<MatrixIndexes, MatrixBlock>> call(Iterator<Tuple2<MatrixIndexes, MatrixBlock>> arg0) {
            return new ExtractTriangularIterator(arg0);
        }

        private class ExtractTriangularIterator
        extends LazyIterableIterator<Tuple2<MatrixIndexes, MatrixBlock>> {
            public ExtractTriangularIterator(Iterator<Tuple2<MatrixIndexes, MatrixBlock>> in) {
                super(in);
            }

            @Override
            protected Tuple2<MatrixIndexes, MatrixBlock> computeNext(Tuple2<MatrixIndexes, MatrixBlock> arg) {
                MatrixIndexes ix = (MatrixIndexes)arg._1();
                MatrixBlock mb = (MatrixBlock)arg._2();
                if (RDDExtractTriangularFunction.this._lower && ix.getRowIndex() > ix.getColumnIndex() || !RDDExtractTriangularFunction.this._lower && ix.getRowIndex() < ix.getColumnIndex()) {
                    return RDDExtractTriangularFunction.this._values ? arg : new Tuple2((Object)ix, (Object)new MatrixBlock(mb.getNumRows(), mb.getNumColumns(), 1.0));
                }
                if (RDDExtractTriangularFunction.this._lower && ix.getRowIndex() < ix.getColumnIndex() || !RDDExtractTriangularFunction.this._lower && ix.getRowIndex() > ix.getColumnIndex()) {
                    return new Tuple2((Object)ix, (Object)new MatrixBlock(mb.getNumRows(), mb.getNumColumns(), true));
                }
                assert (ix.getRowIndex() == ix.getColumnIndex());
                return new Tuple2((Object)ix, (Object)mb.extractTriangular(new MatrixBlock(), RDDExtractTriangularFunction.this._lower, RDDExtractTriangularFunction.this._diag, RDDExtractTriangularFunction.this._values));
            }
        }
    }

    public static class RDDFrameReplaceFunction
    implements Function<FrameBlock, FrameBlock> {
        private static final long serialVersionUID = 6576713401901671660L;
        private final String _pattern;
        private final String _replacement;

        public RDDFrameReplaceFunction(String pattern, String replacement) {
            this._pattern = pattern;
            this._replacement = replacement;
        }

        public FrameBlock call(FrameBlock arg0) {
            return arg0.replaceOperations(this._pattern, this._replacement);
        }
    }

    public static class RDDContainsVectFunction
    implements PairFlatMapFunction<Tuple2<MatrixIndexes, MatrixBlock>, Long, Integer> {
        private static final long serialVersionUID = 2228503788469700742L;
        private final PartitionedBroadcast<MatrixBlock> _pbcPattern;
        private final int _blocksize;

        public RDDContainsVectFunction(PartitionedBroadcast<MatrixBlock> bc, int blocksize) {
            this._pbcPattern = bc;
            this._blocksize = blocksize;
        }

        public Iterator<Tuple2<Long, Integer>> call(Tuple2<MatrixIndexes, MatrixBlock> input) throws Exception {
            MatrixIndexes ix = (MatrixIndexes)input._1();
            MatrixBlock pattern = this._pbcPattern.getBlock(1, (int)ix.getColumnIndex());
            List<Integer> tmp = ((MatrixBlock)input._2()).containsVector(pattern, false);
            ArrayList<Tuple2> ret = new ArrayList<Tuple2>();
            ret.add(new Tuple2((Object)(ix.getRowIndex() * (long)this._blocksize), (Object)0));
            for (int rix : tmp) {
                ret.add(new Tuple2((Object)UtilFunctions.computeCellIndex(ix.getRowIndex(), this._blocksize, rix), (Object)1));
            }
            return ret.iterator();
        }
    }

    public static class RDDContainsFunction
    implements Function<MatrixBlock, Double> {
        private static final long serialVersionUID = 6576713401901671659L;
        private final double _pattern;

        public RDDContainsFunction(double pattern) {
            this._pattern = pattern;
        }

        public Double call(MatrixBlock arg0) {
            return arg0.containsValue(this._pattern) ? 1.0 : 0.0;
        }
    }

    public static class RDDReplaceFunction
    implements Function<MatrixBlock, MatrixBlock> {
        private static final long serialVersionUID = 6576713401901671659L;
        private final double _pattern;
        private final double _replacement;

        public RDDReplaceFunction(double pattern, double replacement) {
            this._pattern = pattern;
            this._replacement = replacement;
        }

        public MatrixBlock call(MatrixBlock arg0) {
            return arg0.replaceOperations(new MatrixBlock(), this._pattern, this._replacement);
        }
    }
}

