/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.iogen;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.iogen.ColIndexStructure;
import org.apache.sysds.runtime.iogen.CustomProperties;
import org.apache.sysds.runtime.iogen.LongestCommonSubsequence;
import org.apache.sysds.runtime.iogen.MappingProperties;
import org.apache.sysds.runtime.iogen.RawIndex;
import org.apache.sysds.runtime.iogen.ReaderMapping;
import org.apache.sysds.runtime.iogen.RowIndexStructure;
import org.apache.sysds.runtime.iogen.TextTrie;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.util.CommonThreadPool;

public class FormatIdentifyer {
    private int[][] mapRow;
    private int[][] mapCol;
    private int[][] mapLen;
    private int actualValueCount;
    private MappingProperties mappingProperties;
    private RawIndex[] sampleRawIndexes;
    private int nrows;
    private int ncols;
    private int nlines;
    private int suffixStringLength = 50;
    private ReaderMapping mappingValues;
    private CustomProperties properties;
    private BitSet staticColIndexes;
    Comparator<ArrayList<String>> AscendingArrayOfStringComparator = new Comparator<ArrayList<String>>(){

        @Override
        public int compare(ArrayList<String> strings, ArrayList<String> t1) {
            return Integer.compare(strings.size(), t1.size());
        }
    };
    Comparator<String> AscendingStringLengthComparator = new Comparator<String>(){

        @Override
        public int compare(String s, String t1) {
            return s.length() - t1.length();
        }
    };
    Comparator<Pair<String, Integer>> AscendingPairStringComparator = new Comparator<Pair<String, Integer>>(){

        @Override
        public int compare(Pair<String, Integer> stringIntegerPair, Pair<String, Integer> t1) {
            return stringIntegerPair.getKey().length() - t1.getKey().length();
        }
    };
    Comparator<Pair<String, ArrayList<Integer>>> AscendingPairListComparator = new Comparator<Pair<String, ArrayList<Integer>>>(){

        @Override
        public int compare(Pair<String, ArrayList<Integer>> stringArrayListPair, Pair<String, ArrayList<Integer>> t1) {
            boolean flag = true;
            for (int i = 0; i < stringArrayListPair.getValue().size() && flag; ++i) {
                flag = stringArrayListPair.getValue().get(i) > t1.getValue().get(i);
            }
            if (flag) {
                return 1;
            }
            return -1;
        }
    };

    public FormatIdentifyer(String raw, MatrixBlock matrix) throws Exception {
        this.mappingValues = new ReaderMapping(raw, matrix);
        this.runIdentification();
    }

    public FormatIdentifyer(String raw, FrameBlock frame) throws Exception {
        this.mappingValues = new ReaderMapping(raw, frame);
        this.runIdentification();
    }

    private void runIdentification() {
        this.mapRow = this.mappingValues.getMapRow();
        this.mapCol = this.mappingValues.getMapCol();
        this.mapLen = this.mappingValues.getMapLen();
        this.mappingProperties = this.mappingValues.getMappingProperties();
        this.sampleRawIndexes = this.mappingValues.getSampleRawIndexes();
        this.nrows = this.mappingValues.getNrows();
        this.ncols = this.mappingValues.getNcols();
        this.nlines = this.mappingValues.getNlines();
        this.actualValueCount = this.mappingValues.getActualValueCount();
        this.staticColIndexes = new BitSet(this.ncols);
        RowIndexStructure rowIndexStructure = this.getRowIndexStructure();
        ColIndexStructure colIndexStructure = this.getColIndexStructure();
        this.properties = new CustomProperties(this.mappingProperties, rowIndexStructure, colIndexStructure);
        this.properties.setNcols(this.ncols);
        if (this.mappingProperties.getRecordProperties() == MappingProperties.RecordProperties.SINGLELINE) {
            if (rowIndexStructure.getProperties() == RowIndexStructure.IndexProperties.Identity && colIndexStructure.getProperties() == ColIndexStructure.IndexProperties.Identity) {
                Pair<ArrayList<String>[], HashSet<String>[]> bckpsr = this.buildColsKeyPatternSingleRow();
                this.properties.setColKeyPatterns(bckpsr.getKey());
                this.properties.setEndWithValueStrings(bckpsr.getValue());
            } else if (rowIndexStructure.getProperties() == RowIndexStructure.IndexProperties.Identity && colIndexStructure.getProperties() == ColIndexStructure.IndexProperties.CellWiseExist) {
                RawIndex raw = null;
                for (int c = 0; c < this.ncols; ++c) {
                    if (this.mapCol[0][c] == -1) continue;
                    raw = this.sampleRawIndexes[this.mapRow[0][c]];
                    raw.cloneReservedPositions();
                    break;
                }
                HashMap<String, Long> indexDelimCount = new HashMap<String, Long>();
                String valueDelim = null;
                String indexDelim = null;
                Long maxCount = 0L;
                int begin = colIndexStructure.getColIndexBegin();
                for (int c = 0; c < this.ncols; ++c) {
                    int nextPos;
                    if (this.mapCol[0][c] == -1) continue;
                    Pair<Integer, Integer> pair = raw.findValue(c + begin);
                    String tmpIndexDelim = raw.getSubString(pair.getKey() + pair.getValue(), this.mapCol[0][c]);
                    if (indexDelimCount.containsKey(tmpIndexDelim)) {
                        indexDelimCount.put(tmpIndexDelim, (Long)indexDelimCount.get(tmpIndexDelim) + 1L);
                    } else {
                        indexDelimCount.put(tmpIndexDelim, 1L);
                    }
                    if (maxCount < (Long)indexDelimCount.get(tmpIndexDelim)) {
                        maxCount = (Long)indexDelimCount.get(tmpIndexDelim);
                        indexDelim = tmpIndexDelim;
                    }
                    if (valueDelim != null || (nextPos = raw.getNextNumericPosition(this.mapCol[0][c] + this.mapLen[0][c])) >= raw.getRawLength()) continue;
                    valueDelim = raw.getSubString(this.mapCol[0][c] + this.mapLen[0][c], nextPos);
                }
                colIndexStructure.setIndexDelim(indexDelim);
                colIndexStructure.setValueDelim(valueDelim);
            }
        } else {
            if (rowIndexStructure.getProperties() == RowIndexStructure.IndexProperties.CellWiseExist && colIndexStructure.getProperties() == ColIndexStructure.IndexProperties.CellWiseExist) {
                if (this.mappingProperties.getDataProperties() != MappingProperties.DataProperties.NOTEXIST) {
                    Pair<ArrayList<String>, HashSet<String>> bvkpsr = this.buildValueKeyPattern();
                    HashSet[] endWithValueStrings = new HashSet[]{bvkpsr.getValue()};
                    this.properties.setValueKeyPattern(bvkpsr.getKey());
                    this.properties.setEndWithValueStrings(endWithValueStrings);
                }
                int beginRowIndex = rowIndexStructure.getRowIndexBegin();
                int beginColIndex = colIndexStructure.getColIndexBegin();
                Pair<ArrayList<String>, HashSet<String>> rowIndexPattern = this.buildIndexKeyPattern(true, beginRowIndex);
                rowIndexStructure.setKeyPattern(rowIndexPattern.getKey());
                rowIndexStructure.setEndWithValueString(rowIndexPattern.getValue());
                Pair<ArrayList<String>, HashSet<String>> colIndexPattern = this.buildIndexKeyPattern(false, beginColIndex);
                colIndexStructure.setKeyPattern(colIndexPattern.getKey());
                colIndexStructure.setEndWithValueString(colIndexPattern.getValue());
            }
            if (rowIndexStructure.getProperties() == RowIndexStructure.IndexProperties.SeqScatter) {
                ArrayList<Pair<String, String>> prefixSuffixBeginEndCells = this.extractPrefixSuffixBeginEndCells(false);
                TextTrie textTrie = new TextTrie();
                textTrie.insert(prefixSuffixBeginEndCells.get(0).getKey(), 0);
                char startChar = prefixSuffixBeginEndCells.get(0).getKey().charAt(0);
                int minSubStringLength = Math.min(80, prefixSuffixBeginEndCells.get(0).getKey().length());
                for (int i = 1; i < prefixSuffixBeginEndCells.size(); ++i) {
                    String prefix = prefixSuffixBeginEndCells.get(i).getKey();
                    for (int j = 0; j < prefix.length(); ++j) {
                        if (startChar != prefix.charAt(j)) continue;
                        textTrie.insert(prefix.substring(j, j + Math.min(minSubStringLength, prefix.length() - j)), i);
                    }
                }
                ArrayList<Pair<String, Set<Integer>>> keys = textTrie.getAllKeys();
                String beginString = null;
                String endString = null;
                if (keys.get(0).getValue().size() == this.nrows) {
                    char intersectChar;
                    int index = keys.get(0).getKey().indexOf("\n");
                    beginString = index == -1 ? keys.get(0).getKey() : keys.get(0).getKey().substring(0, index);
                    int minSuffixStringLength = prefixSuffixBeginEndCells.get(0).getValue().length();
                    String reverseBeginString = new StringBuilder(beginString).reverse().toString();
                    ArrayList<String> suffixes = new ArrayList<String>();
                    for (int i = 0; i < prefixSuffixBeginEndCells.size() - 1; ++i) {
                        String str = new StringBuilder(prefixSuffixBeginEndCells.get(i).getValue()).reverse().toString();
                        int indexBeginString = str.indexOf(reverseBeginString);
                        if (indexBeginString != -1) {
                            for (int j = indexBeginString + reverseBeginString.length(); j < str.length() && str.charAt(j) == '\n'; ++j) {
                                ++indexBeginString;
                            }
                            minSuffixStringLength = Math.min(minSuffixStringLength, indexBeginString);
                            suffixes.add(new StringBuilder(str.substring(0, indexBeginString + reverseBeginString.length())).reverse().toString());
                            continue;
                        }
                        suffixes.add(str);
                    }
                    StringBuilder sbEndString = new StringBuilder();
                    for (int i = 0; i < minSuffixStringLength && ((String)suffixes.get(0)).length() != 0 && (intersectChar = ((String)suffixes.get(0)).charAt(i)) != '\n'; ++i) {
                        boolean flag = true;
                        for (String ss : suffixes) {
                            if (ss.charAt(i) == intersectChar) continue;
                            flag = false;
                            break;
                        }
                        if (!flag) break;
                        sbEndString.append(intersectChar);
                    }
                    endString = sbEndString.length() == 0 ? beginString : sbEndString.toString();
                    this.updateMapsAndExtractAllSuffixStringsOfColsMultiLine(beginString, endString);
                    rowIndexStructure.setSeqBeginString(beginString);
                    rowIndexStructure.setSeqEndString(endString);
                    Pair<ArrayList<String>[], HashSet<String>[]> bckpsr = this.buildColsKeyPatternSingleRow();
                    this.properties.setColKeyPatterns(bckpsr.getKey());
                    this.properties.setEndWithValueStrings(bckpsr.getValue());
                }
            }
        }
        if (rowIndexStructure.getProperties() == RowIndexStructure.IndexProperties.CellWiseExist || colIndexStructure.getProperties() == ColIndexStructure.IndexProperties.CellWiseExist) {
            this.properties.setSparse(true);
        }
    }

    private RowIndexStructure getRowIndexStructure() {
        int r;
        RowIndexStructure rowIndexStructure = new RowIndexStructure();
        if (this.mappingProperties.getDataProperties() == MappingProperties.DataProperties.NOTEXIST && this.nlines >= this.actualValueCount) {
            rowIndexStructure.setProperties(RowIndexStructure.IndexProperties.CellWiseExist);
            rowIndexStructure.setRowIndexBegin(0);
            return rowIndexStructure;
        }
        if (this.mappingProperties.getDataProperties() != MappingProperties.DataProperties.NOTEXIST) {
            boolean identity = false;
            int missedCount = 0;
            for (int r2 = 0; r2 < this.nrows; ++r2) {
                for (int c = 0; c < this.ncols; ++c) {
                    if (this.mapRow[r2][c] == -1 || this.mapRow[r2][c] == r2) continue;
                    ++missedCount;
                }
            }
            if ((double)((float)missedCount / (float)this.actualValueCount) < 0.07) {
                identity = true;
            }
            if (identity) {
                rowIndexStructure.setProperties(RowIndexStructure.IndexProperties.Identity);
                return rowIndexStructure;
            }
        }
        BitSet[] bitSets = new BitSet[this.nrows];
        int[] rowCardinality = new int[this.nrows];
        int[] rowNZ = new int[this.nrows];
        boolean isCellWise = true;
        boolean isSeqScatter = true;
        boolean isExist = true;
        for (r = 0; r < this.nrows; ++r) {
            bitSets[r] = new BitSet(this.nlines);
            rowNZ[r] = 0;
            for (int c = 0; c < this.ncols; ++c) {
                if (this.mapRow[r][c] == -1) continue;
                bitSets[r].set(this.mapRow[r][c]);
                int n = r;
                rowNZ[n] = rowNZ[n] + 1;
            }
            rowCardinality[r] = bitSets[r].cardinality();
        }
        for (r = 0; r < this.nrows && isSeqScatter; ++r) {
            BitSet bitSet = bitSets[r];
            ArrayList<Integer> list = new ArrayList<Integer>();
            int i = bitSet.nextSetBit(0);
            while (i != -1) {
                list.add(i);
                i = bitSet.nextSetBit(i + 1);
            }
            for (i = 0; i < list.size() - 1 && isSeqScatter; ++i) {
                isSeqScatter = (Integer)list.get(i) <= (Integer)list.get(i + 1);
            }
        }
        for (r = 0; r < this.nrows && isCellWise; ++r) {
            isCellWise = rowCardinality[r] == rowNZ[r];
        }
        int begin = 0;
        if (isCellWise) {
            for (int c = 0; c < this.ncols; ++c) {
                begin = this.checkRowIndexesOnColumnRaw(c, 0);
                if (begin != -1) continue;
                isExist = false;
                break;
            }
            if (isExist) {
                rowIndexStructure.setProperties(RowIndexStructure.IndexProperties.CellWiseExist);
                rowIndexStructure.setRowIndexBegin(begin);
                return rowIndexStructure;
            }
        } else {
            ArrayList<RawIndex> list = new ArrayList<RawIndex>();
            for (int r3 = 0; r3 < this.nrows; ++r3) {
                BitSet bitSet = bitSets[r3];
                int i = bitSet.nextSetBit(0);
                while (i != -1) {
                    list.add(this.sampleRawIndexes[i]);
                    i = bitSet.nextSetBit(i + 1);
                }
                begin = this.checkRowIndexOnRaws(r3, 0, list);
                if (begin != -1) continue;
                isExist = false;
                break;
            }
            if (isExist) {
                rowIndexStructure.setProperties(RowIndexStructure.IndexProperties.RowWiseExist);
                rowIndexStructure.setRowIndexBegin(begin);
                return rowIndexStructure;
            }
        }
        if (isSeqScatter) {
            rowIndexStructure.setProperties(RowIndexStructure.IndexProperties.SeqScatter);
            return rowIndexStructure;
        }
        return rowIndexStructure;
    }

    private ColIndexStructure getColIndexStructure() {
        ColIndexStructure colIndexStructure = new ColIndexStructure();
        int begin = 0;
        boolean colIndexExist = true;
        if (this.mappingProperties.getDataProperties() == MappingProperties.DataProperties.NOTEXIST && this.nlines >= this.actualValueCount) {
            colIndexStructure.setProperties(ColIndexStructure.IndexProperties.CellWiseExist);
            colIndexStructure.setColIndexBegin(0);
            return colIndexStructure;
        }
        if (this.mappingProperties.getRecordProperties() == MappingProperties.RecordProperties.SINGLELINE) {
            for (int r = 0; r < Math.min(10, this.nrows); ++r) {
                int rowIndex = -1;
                for (int c = 0; c < this.ncols && (rowIndex = this.mapRow[r][c]) == -1; ++c) {
                }
                begin = this.checkColIndexesOnRowRaw(rowIndex, 0);
                if (begin != -1) continue;
                colIndexExist = false;
                break;
            }
            if (colIndexExist) {
                colIndexStructure.setColIndexBegin(begin);
                colIndexStructure.setProperties(ColIndexStructure.IndexProperties.CellWiseExist);
                return colIndexStructure;
            }
            colIndexStructure.setProperties(ColIndexStructure.IndexProperties.Identity);
            return colIndexStructure;
        }
        for (int r = 0; r < this.nrows && colIndexExist; ++r) {
            for (int c = 0; c < Math.min(10, this.ncols) && colIndexExist; ++c) {
                if (this.mapRow[r][c] == -1) continue;
                colIndexExist = (begin = this.checkColIndexOnRowRaw(this.mapRow[r][c], c, begin)) != -1;
            }
        }
        if (colIndexExist) {
            colIndexStructure.setColIndexBegin(begin);
            colIndexStructure.setProperties(ColIndexStructure.IndexProperties.CellWiseExist);
            return colIndexStructure;
        }
        return colIndexStructure;
    }

    private int checkRowIndexesOnColumnRaw(int colIndex, int beginPos) {
        int nne = 0;
        for (int r = 0; r < this.nrows; ++r) {
            if (this.mapRow[r][colIndex] == -1) continue;
            RawIndex raw = this.sampleRawIndexes[this.mapRow[r][colIndex]];
            raw.cloneReservedPositions();
            Pair<Integer, Integer> pair = raw.findValue(r + beginPos);
            raw.restoreReservedPositions();
            if (pair != null) continue;
            ++nne;
        }
        if (nne > 0) {
            if (beginPos == 1) {
                return -1;
            }
            return this.checkRowIndexesOnColumnRaw(colIndex, 1);
        }
        return beginPos;
    }

    private int checkRowIndexOnRaws(int rowIndex, int beginPos, ArrayList<RawIndex> list) {
        int nne = 0;
        for (RawIndex raw : list) {
            raw.cloneReservedPositions();
            Pair<Integer, Integer> pair = raw.findValue(rowIndex + beginPos);
            if (pair == null) {
                ++nne;
            }
            raw.restoreReservedPositions();
        }
        if ((double)nne > (double)list.size() * 0.3) {
            if (beginPos == 1) {
                return -1;
            }
            return this.checkRowIndexOnRaws(rowIndex, 1, list);
        }
        return beginPos;
    }

    private int checkColIndexesOnRowRaw(int rowIndex, int beginPos) {
        int nne = 0;
        RawIndex raw = this.sampleRawIndexes[rowIndex];
        raw.cloneReservedPositions();
        for (int c = 0; c < this.ncols; ++c) {
            Pair<Integer, Integer> pair;
            if (this.mapCol[rowIndex][c] == -1 || (pair = raw.findValue(c + beginPos)) != null && pair.getKey() <= this.mapCol[rowIndex][c]) continue;
            ++nne;
        }
        raw.restoreReservedPositions();
        if ((double)nne > (double)this.ncols * 0.05) {
            if (beginPos == 1) {
                return -1;
            }
            return this.checkColIndexesOnRowRaw(rowIndex, 1);
        }
        return beginPos;
    }

    private int checkColIndexOnRowRaw(int rowIndex, int colIndex, int beginPos) {
        RawIndex raw = this.sampleRawIndexes[rowIndex];
        raw.cloneReservedPositions();
        Pair<Integer, Integer> pair = raw.findValue(colIndex + beginPos);
        raw.restoreReservedPositions();
        if (pair == null) {
            if (beginPos == 1) {
                return -1;
            }
            return this.checkColIndexOnRowRaw(rowIndex, colIndex, 1);
        }
        return beginPos;
    }

    private ArrayList<Pair<String, String>> extractPrefixSuffixBeginEndCells(boolean reverse) {
        int r;
        int r2;
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
        BitSet[] recordUsedLines = new BitSet[this.nlines];
        BitSet[] usedLines = new BitSet[this.nlines];
        for (r2 = 0; r2 < this.nrows; ++r2) {
            recordUsedLines[r2] = new BitSet();
        }
        for (r2 = 0; r2 < this.nrows; ++r2) {
            for (int c = 0; c < this.ncols; ++c) {
                if (this.mapRow[r2][c] == -1) continue;
                recordUsedLines[r2].set(this.mapRow[r2][c]);
            }
        }
        for (r2 = 0; r2 < this.nrows; ++r2) {
            usedLines[r2] = new BitSet(this.nlines);
            for (int i = 0; i < this.nrows; ++i) {
                if (i == r2) continue;
                usedLines[r2].or(recordUsedLines[i]);
            }
        }
        int lastLine = 0;
        int lastPos = 0;
        for (r = 0; r < this.nrows; ++r) {
            int i;
            int beginLine = 0;
            int endLine = 0;
            int beginPos = 0;
            for (i = 0; i < this.nlines; ++i) {
                if (!recordUsedLines[r].get(i)) continue;
                beginLine = i;
                break;
            }
            for (i = this.nlines - 1; i >= 0; --i) {
                if (!recordUsedLines[r].get(i)) continue;
                endLine = i;
                break;
            }
            int endPos = 0;
            beginPos = this.sampleRawIndexes[beginLine].getRawLength();
            for (int c = 0; c < this.ncols; ++c) {
                if (this.mapRow[r][c] == beginLine) {
                    beginPos = Math.min(beginPos, this.mapCol[r][c]);
                }
                if (this.mapRow[r][c] != endLine) continue;
                endPos = Math.max(endPos, this.mapCol[r][c] + this.mapLen[r][c]);
            }
            StringBuilder sbPrefix = new StringBuilder();
            if (lastLine != beginLine) {
                sbPrefix.append(this.sampleRawIndexes[lastLine].getRaw().substring(lastPos)).append("\n");
            }
            for (int i2 = lastLine + 1; i2 < beginLine; ++i2) {
                sbPrefix.append(this.sampleRawIndexes[i2].getRaw()).append("\n");
            }
            sbPrefix.append(this.sampleRawIndexes[beginLine].getRaw().substring(0, beginPos));
            lastLine = endLine;
            lastPos = endPos;
            result.add(new Pair<String, Object>(sbPrefix.toString(), null));
        }
        for (r = 0; r < this.nrows - 1; ++r) {
            ((Pair)result.get(r)).setValue((String)((Pair)result.get(r + 1)).getKey());
        }
        ((Pair)result.get(this.nrows - 1)).setValue(null);
        return result;
    }

    public CustomProperties getFormatProperties() {
        return this.properties;
    }

    private Pair<ArrayList<String>, HashSet<String>> buildValueKeyPattern() {
        int c;
        int minSelectCols = Math.min(10, this.ncols);
        ArrayList[] prefixesRemovedReverse = new ArrayList[1];
        ArrayList[] prefixesRemoved = new ArrayList[1];
        ArrayList[] prefixes = new ArrayList[1];
        ArrayList[] suffixes = new ArrayList[1];
        ArrayList[] prefixesRemovedReverseSort = new ArrayList[1];
        ArrayList[] keys = new ArrayList[minSelectCols];
        HashSet[] colSuffixes = new HashSet[minSelectCols];
        LongestCommonSubsequence lcs = new LongestCommonSubsequence();
        for (c = 0; c < minSelectCols; ++c) {
            prefixesRemovedReverse[0] = new ArrayList();
            prefixes[0] = new ArrayList();
            suffixes[0] = new ArrayList();
        }
        for (c = 0; c < minSelectCols; ++c) {
            prefixesRemovedReverse[0].addAll((Collection)this.extractAllPrefixStringsOfAColSingleLine(c, true, true).getKey());
            prefixes[0].addAll((Collection)this.extractAllPrefixStringsOfAColSingleLine(c, false, false).getKey());
            suffixes[0].addAll(this.extractAllSuffixStringsOfColsSingleLine(c, true));
        }
        HashSet<Integer> colIndexes = new HashSet<Integer>();
        colIndexes.add(0);
        try {
            ArrayList<BuildColsKeyPatternSingleRowTask> tasks = new ArrayList<BuildColsKeyPatternSingleRowTask>();
            tasks.add(new BuildColsKeyPatternSingleRowTask(prefixesRemovedReverse, prefixesRemoved, prefixes, suffixes, prefixesRemovedReverseSort, keys, colSuffixes, lcs, colIndexes));
            for (Callable callable : tasks) {
                callable.call();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed BuildValueKeyPattern.", e);
        }
        return new Pair<ArrayList<String>, HashSet<String>>(keys[0], colSuffixes[0]);
    }

    private String addToPrefixes(Set<String> list, String strValue, int value, boolean reverse) {
        String str = reverse ? new StringBuilder(strValue).reverse().toString() : strValue;
        RawIndex rawIndex = new RawIndex(str);
        Pair<Integer, Integer> pair = rawIndex.findValue(value);
        if (pair != null) {
            String pstr = str.substring(0, pair.getKey());
            list.add(pstr);
            return "\u00b0" + str.substring(pair.getKey() + pair.getValue()).replaceAll("\\d", "\u00b0");
        }
        return null;
    }

    private Pair<ArrayList<String>, HashSet<String>> buildIndexKeyPattern(boolean keyForRowIndexes, int begin) {
        HashSet<String> tmpSet;
        ArrayList<String> tmpPrefixes;
        ArrayList<String> tmpPrefixesRemoved;
        ArrayList colSet;
        int r;
        Iterator r222;
        ArrayList[] prefixesRemovedReverse = new ArrayList[1];
        ArrayList[] prefixesRemoved = new ArrayList[1];
        ArrayList[] prefixes = new ArrayList[1];
        ArrayList[] suffixes = new ArrayList[1];
        ArrayList[] prefixesRemovedReverseSort = new ArrayList[1];
        ArrayList[] keys = new ArrayList[1];
        HashSet[] colSuffixes = new HashSet[1];
        LongestCommonSubsequence lcs = new LongestCommonSubsequence();
        prefixesRemovedReverse[0] = new ArrayList();
        prefixesRemoved[0] = new ArrayList();
        prefixes[0] = new ArrayList();
        suffixes[0] = new ArrayList();
        HashMap<Integer, ArrayList> selectedRowColForIndexes = new HashMap<Integer, ArrayList>();
        int maxSize = 0;
        for (int r222 = 1; r222 < this.nrows && maxSize < 1000; ++r222) {
            for (int c = 0; c < this.ncols && maxSize < 1000; ++c) {
                if (this.mapCol[r222][c] == -1 || r222 == c) continue;
                selectedRowColForIndexes.computeIfAbsent(r222, k -> new ArrayList());
                ((ArrayList)selectedRowColForIndexes.get(r222)).add(c);
                ++maxSize;
            }
        }
        if (keyForRowIndexes) {
            r222 = selectedRowColForIndexes.keySet().iterator();
            while (r222.hasNext()) {
                r = (Integer)r222.next();
                colSet = (ArrayList)selectedRowColForIndexes.get(r);
                ArrayList<String> arrayList = this.extractAllPrefixStringsOfAColSingleLine(r, colSet, true, true).getKey();
                tmpPrefixesRemoved = this.extractAllPrefixStringsOfAColSingleLine(r, colSet, false, true).getKey();
                tmpPrefixes = this.extractAllPrefixStringsOfAColSingleLine(r, colSet, false, false).getKey();
                tmpSet = new HashSet<String>();
                for (String s : arrayList) {
                    String suf = this.addToPrefixes(tmpSet, s, r + begin, true);
                    if (suf == null) continue;
                    suffixes[0].add(suf);
                }
                prefixesRemovedReverse[0].addAll(tmpSet);
                tmpSet = new HashSet();
                for (String s : tmpPrefixesRemoved) {
                    this.addToPrefixes(tmpSet, s, r + begin, false);
                }
                prefixesRemoved[0].addAll(tmpSet);
                tmpSet = new HashSet();
                for (String s : tmpPrefixes) {
                    this.addToPrefixes(tmpSet, s, r + begin, false);
                }
                prefixes[0].addAll(tmpSet);
            }
        } else {
            r222 = selectedRowColForIndexes.keySet().iterator();
            while (r222.hasNext()) {
                int c;
                Iterator iterator;
                r = (Integer)r222.next();
                colSet = (ArrayList)selectedRowColForIndexes.get(r);
                ArrayList<String> arrayList = this.extractAllPrefixStringsOfAColSingleLine(r, colSet, true, true).getKey();
                tmpPrefixesRemoved = this.extractAllPrefixStringsOfAColSingleLine(r, colSet, false, true).getKey();
                tmpPrefixes = this.extractAllPrefixStringsOfAColSingleLine(r, colSet, false, false).getKey();
                tmpSet = new HashSet();
                for (String s : arrayList) {
                    iterator = colSet.iterator();
                    while (iterator.hasNext()) {
                        c = (Integer)iterator.next();
                        String suf = this.addToPrefixes(tmpSet, s, c + begin, true);
                        if (suf == null) continue;
                        suffixes[0].add(suf);
                    }
                }
                prefixesRemovedReverse[0].addAll(tmpSet);
                tmpSet = new HashSet();
                for (String s : tmpPrefixesRemoved) {
                    iterator = colSet.iterator();
                    while (iterator.hasNext()) {
                        c = (Integer)iterator.next();
                        this.addToPrefixes(tmpSet, s, c + begin, false);
                    }
                }
                prefixesRemoved[0].addAll(tmpSet);
                tmpSet = new HashSet();
                for (String s : tmpPrefixes) {
                    iterator = colSet.iterator();
                    while (iterator.hasNext()) {
                        c = (Integer)iterator.next();
                        this.addToPrefixes(tmpSet, s, c + begin, false);
                    }
                }
                prefixes[0].addAll(tmpSet);
            }
        }
        HashSet<Integer> colIndexe = new HashSet<Integer>();
        colIndexe.add(0);
        try {
            ArrayList<BuildColsKeyPatternSingleRowTask> tasks = new ArrayList<BuildColsKeyPatternSingleRowTask>();
            tasks.add(new BuildColsKeyPatternSingleRowTask(prefixesRemovedReverse, prefixesRemoved, prefixes, suffixes, prefixesRemovedReverseSort, keys, colSuffixes, lcs, colIndexe));
            for (Callable callable : tasks) {
                callable.call();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed BuildValueKeyPattern.", e);
        }
        return new Pair<ArrayList<String>, HashSet<String>>(keys[0], colSuffixes[0]);
    }

    public Pair<ArrayList<String>[], ArrayList<Integer>[]> extractAllPrefixStringsOfColsSingleLine(boolean reverse, boolean removesSelected) {
        ArrayList[] prefixStrings = new ArrayList[this.ncols];
        ArrayList[] rowIndexes = new ArrayList[this.ncols];
        for (int c = 0; c < this.ncols; ++c) {
            Pair<ArrayList<String>, ArrayList<Integer>> pair = this.extractAllPrefixStringsOfAColSingleLine(c, reverse, removesSelected);
            prefixStrings[c] = pair.getKey();
            rowIndexes[c] = pair.getValue();
        }
        return new Pair<ArrayList<String>[], ArrayList<Integer>[]>(prefixStrings, rowIndexes);
    }

    public Pair<ArrayList<String>, ArrayList<Integer>> extractAllPrefixStringsOfAColSingleLine(int r, ArrayList<Integer> colIndexes, boolean reverse, boolean removesSelected) {
        ArrayList<String> prefixStrings = new ArrayList<String>();
        ArrayList<Integer> rowIndexes = new ArrayList<Integer>();
        for (int c : colIndexes) {
            int rowIndex = this.mapRow[r][c];
            if (rowIndex == -1) continue;
            rowIndexes.add(rowIndex);
            String str = removesSelected ? this.sampleRawIndexes[rowIndex].getRemainedTexts(0, this.mapCol[r][c]) : this.sampleRawIndexes[rowIndex].getRaw().substring(0, this.mapCol[r][c]);
            if (reverse) {
                prefixStrings.add(new StringBuilder(str).reverse().toString());
                continue;
            }
            prefixStrings.add(str);
        }
        return new Pair<ArrayList<String>, ArrayList<Integer>>(prefixStrings, rowIndexes);
    }

    public Pair<ArrayList<String>, ArrayList<Integer>> extractAllPrefixStringsOfAColSingleLine(int colIndex, boolean reverse, boolean removesSelected) {
        ArrayList<String> prefixStrings = new ArrayList<String>();
        ArrayList<Integer> rowIndexes = new ArrayList<Integer>();
        for (int r = 0; r < this.nrows; ++r) {
            int rowIndex = this.mapRow[r][colIndex];
            if (rowIndex == -1) continue;
            rowIndexes.add(rowIndex);
            String str = removesSelected ? this.sampleRawIndexes[rowIndex].getRemainedTexts(0, this.mapCol[r][colIndex]) : this.sampleRawIndexes[rowIndex].getRaw().substring(0, this.mapCol[r][colIndex]);
            if (reverse) {
                prefixStrings.add(new StringBuilder(str).reverse().toString());
                continue;
            }
            prefixStrings.add(str);
        }
        return new Pair<ArrayList<String>, ArrayList<Integer>>(prefixStrings, rowIndexes);
    }

    private ArrayList<String>[] extractAllSuffixStringsOfColsSingleLine(boolean removeData) {
        ArrayList[] result = new ArrayList[this.ncols];
        for (int c = 0; c < this.ncols; ++c) {
            result[c] = new ArrayList();
            for (int r = 0; r < this.nrows; ++r) {
                int rowIndex = this.mapRow[r][c];
                if (rowIndex == -1) continue;
                String str = removeData ? this.sampleRawIndexes[rowIndex].getRemainedTexts(this.mapCol[r][c] + this.mapLen[r][c], -1) : this.sampleRawIndexes[rowIndex].getRaw().substring(this.mapCol[r][c] + this.mapLen[r][c]);
                result[c].add(str);
            }
        }
        return result;
    }

    private ArrayList<String> extractAllSuffixStringsOfColsSingleLine(int col, boolean removeData) {
        ArrayList<String> result = new ArrayList<String>();
        for (int r = 0; r < this.nrows; ++r) {
            int rowIndex = this.mapRow[r][col];
            if (rowIndex == -1) continue;
            String str = removeData ? this.sampleRawIndexes[rowIndex].getRemainedTexts(this.mapCol[r][col] + this.mapLen[r][col], -1) : this.sampleRawIndexes[rowIndex].getRaw().substring(this.mapCol[r][col] + this.mapLen[r][col]);
            result.add(str);
        }
        return result;
    }

    private ArrayList<String> extractAllSuffixStringsOfColsSingleLine(ArrayList<Integer> rows, int col, boolean removeData) {
        ArrayList<String> result = new ArrayList<String>();
        for (int r : rows) {
            int rowIndex = this.mapRow[r][col];
            if (rowIndex == -1) continue;
            String str = removeData ? this.sampleRawIndexes[rowIndex].getRemainedTexts(this.mapCol[r][col] + this.mapLen[r][col], -1) : this.sampleRawIndexes[rowIndex].getRaw().substring(this.mapCol[r][col] + this.mapLen[r][col]);
            result.add(str);
        }
        return result;
    }

    private void updateMapsAndExtractAllSuffixStringsOfColsMultiLine(String beginString, String endString) {
        String endToken;
        ArrayList<Pair<Integer, Integer>> endIndexes;
        RawIndex[] upRawIndexes = new RawIndex[this.nrows];
        ArrayList<Pair<Integer, Integer>> beginIndexes = this.getTokenIndexOnMultiLineRecords(beginString);
        if (!beginString.equals(endString)) {
            endIndexes = this.getTokenIndexOnMultiLineRecords(endString);
            endToken = endString;
        } else {
            endIndexes = new ArrayList();
            for (int i = 1; i < beginIndexes.size(); ++i) {
                endIndexes.add(beginIndexes.get(i));
            }
            endIndexes.add(new Pair<Integer, Integer>(this.sampleRawIndexes.length - 1, this.sampleRawIndexes[this.sampleRawIndexes.length - 1].getRawLength()));
            endToken = "";
        }
        int i = 0;
        int j = 0;
        StringBuilder sb = new StringBuilder();
        for (int r = 0; i < beginIndexes.size() && j < endIndexes.size() && r < this.nrows; ++r) {
            Pair<Integer, Integer> p1 = beginIndexes.get(i);
            Pair<Integer, Integer> p2 = endIndexes.get(j);
            int n = 0;
            while (p1.getKey() < p2.getKey() || p1.getKey() == p2.getKey() && p1.getValue() < p2.getValue()) {
                ++n;
                if (++i == beginIndexes.size()) break;
                p1 = beginIndexes.get(i);
            }
            j += n - 1;
            sb.append(this.sampleRawIndexes[beginIndexes.get(i - n).getKey()].getRaw().substring(beginIndexes.get(i - n).getValue()));
            for (int ri = beginIndexes.get(i - n).getKey() + 1; ri < endIndexes.get(j).getKey(); ++ri) {
                sb.append(this.sampleRawIndexes[ri].getRaw());
            }
            sb.append(this.sampleRawIndexes[endIndexes.get(j).getKey()].getRaw().substring(0, endIndexes.get(j).getValue())).append(endToken);
            RawIndex rawIndex = new RawIndex();
            rawIndex.setRaw(sb.toString());
            sb = new StringBuilder();
            ++j;
            for (int c = 0; c < this.ncols; ++c) {
                if (this.mapRow[r][c] == -1) continue;
                if (this.mapRow[r][c] != beginIndexes.get(i - n).getKey()) {
                    int[] nArray = this.mapCol[r];
                    int n2 = c;
                    nArray[n2] = nArray[n2] + (this.sampleRawIndexes[beginIndexes.get(i - n).getKey()].getRawLength() - beginIndexes.get(i - n).getValue());
                } else {
                    int[] nArray = this.mapCol[r];
                    int n3 = c;
                    nArray[n3] = nArray[n3] - beginIndexes.get(i - n).getValue();
                }
                for (int ci = beginIndexes.get(i - n).getKey() + 1; ci < this.mapRow[r][c]; ++ci) {
                    int[] nArray = this.mapCol[r];
                    int n4 = c;
                    nArray[n4] = nArray[n4] + this.sampleRawIndexes[ci].getRawLength();
                }
                rawIndex.setReservedPositions(this.mapCol[r][c], this.mapLen[r][c]);
                this.mapRow[r][c] = r;
            }
            upRawIndexes[r] = rawIndex;
        }
        this.sampleRawIndexes = upRawIndexes;
    }

    private ArrayList<Pair<Integer, Integer>> getTokenIndexOnMultiLineRecords(String token) {
        ArrayList<Pair<Integer, Integer>> result = new ArrayList<Pair<Integer, Integer>>();
        for (int ri = 0; ri < this.sampleRawIndexes.length; ++ri) {
            int index;
            String raw = this.sampleRawIndexes[ri].getRaw();
            int fromIndex = 0;
            while ((index = raw.indexOf(token, fromIndex)) != -1) {
                result.add(new Pair<Integer, Integer>(ri, index));
                fromIndex = index + token.length();
            }
        }
        return result;
    }

    private ArrayList<Pair<Integer, Integer>> getTokenIndexOnMultiLineRecords(String beginToken, String endToken) {
        ArrayList<Pair<Integer, Integer>> result = new ArrayList<Pair<Integer, Integer>>();
        block0: for (int ri = 0; ri < this.sampleRawIndexes.length; ++ri) {
            int index;
            String raw = this.sampleRawIndexes[ri].getRaw();
            int fromIndex = 0;
            while ((index = raw.indexOf(endToken, fromIndex)) != -1) {
                if (index + endToken.length() + beginToken.length() <= raw.length()) {
                    boolean flag = true;
                    int i = index + endToken.length();
                    int j = 0;
                    while (i < index + endToken.length() + beginToken.length() && flag) {
                        flag = raw.charAt(i) == beginToken.charAt(j);
                        ++i;
                        ++j;
                    }
                    if (flag) {
                        result.add(new Pair<Integer, Integer>(ri, index));
                        fromIndex = index + beginToken.length() + endToken.length();
                        continue;
                    }
                    ++fromIndex;
                    continue;
                }
                if (ri + 1 == this.sampleRawIndexes.length) continue block0;
                while ((raw = this.sampleRawIndexes[++ri].getRaw()).length() == 0) {
                }
                if (!raw.startsWith(beginToken)) continue;
                result.add(new Pair<Integer, Integer>(ri, 0));
                fromIndex = 1;
            }
        }
        return result;
    }

    private Pair<Set<String>, Set<String>> getNewRefineKeys(LongestCommonSubsequence lcs, String firstKey, ArrayList<String> prefixesRemoved, ArrayList<String> prefixes, Set<String> refineKeys) {
        HashSet<String> setRefineLCS = new HashSet<String>();
        HashSet<String> newSetRefineLCS = new HashSet<String>();
        for (String refineKey : refineKeys) {
            int i;
            boolean flagRefine = true;
            boolean isInTheMiddleOfString = false;
            String[] lcsKey = (refineKey + "\u00b0" + firstKey).split("\u00b0");
            ArrayList<String> tmpList = new ArrayList<String>();
            for (String sk : lcsKey) {
                if (sk.length() <= 0) continue;
                tmpList.add(sk);
            }
            for (i = 0; i < prefixes.size() && !isInTheMiddleOfString; ++i) {
                String str = prefixes.get(i);
                int indexOnString = this.getIndexOfKeyPatternOnString(str, tmpList, 0);
                if (flagRefine &= indexOnString == str.length()) continue;
                isInTheMiddleOfString = indexOnString != -1;
            }
            if (flagRefine) {
                setRefineLCS.add(refineKey);
                continue;
            }
            if (isInTheMiddleOfString) continue;
            for (i = 0; i < prefixesRemoved.size(); ++i) {
                String psStr = prefixesRemoved.get(i).substring(0, firstKey.length());
                ArrayList<String> list1 = lcs.getLCS(refineKey, psStr);
                HashSet<String> set = new HashSet<String>();
                set.addAll(list1);
                for (String lcsKeys : set) {
                    if (setRefineLCS.contains(lcsKeys)) continue;
                    String[] newLCSKey = (lcsKeys + "\u00b0" + firstKey).split("\u00b0");
                    ArrayList<String> tmpLCSKeyList = new ArrayList<String>();
                    for (String sk : newLCSKey) {
                        if (sk.length() <= 0) continue;
                        tmpLCSKeyList.add(sk);
                    }
                    boolean str1Check = this.getIndexOfKeyPatternOnString(psStr + firstKey, tmpLCSKeyList, 0).intValue() == psStr.length();
                    if (!str1Check) continue;
                    newSetRefineLCS.add(lcsKeys);
                }
            }
        }
        return new Pair<Set<String>, Set<String>>(setRefineLCS, newSetRefineLCS);
    }

    private Set<String> getRefineKeysStep(LongestCommonSubsequence lcs, String string1, String string2, String psString1, String psString2, String firstKey) {
        String str1 = string1.substring(0, string1.length() - firstKey.length());
        String str2 = string2.substring(0, string2.length() - firstKey.length());
        ArrayList<String> list1 = lcs.getLCS(str1, str2);
        HashSet<String> setLCS = new HashSet<String>();
        setLCS.addAll(list1);
        HashSet<String> refineKeysStep = new HashSet<String>();
        for (String lcsKeys : setLCS) {
            boolean str2Check;
            String[] lcsKey = (lcsKeys + "\u00b0" + firstKey).split("\u00b0");
            ArrayList<String> tmpList = new ArrayList<String>();
            for (String sk : lcsKey) {
                if (sk.length() <= 0) continue;
                tmpList.add(sk);
            }
            boolean str1Check = this.getIndexOfKeyPatternOnString(psString1, tmpList, 0).intValue() == psString1.length();
            boolean bl = str2Check = this.getIndexOfKeyPatternOnString(psString2, tmpList, 0).intValue() == psString2.length();
            if (!str1Check || !str2Check) continue;
            refineKeysStep.add(lcsKeys);
        }
        return refineKeysStep;
    }

    private ArrayList<String> cleanUPKey(ArrayList<String> keys, ArrayList<String> prefixes) {
        int i;
        ArrayList<String> result = new ArrayList<String>();
        for (i = keys.size() - 1; i >= 0; --i) {
            boolean flag = true;
            for (int j = 0; j < prefixes.size() && flag; ++j) {
                flag = this.getIndexOfKeyPatternOnString(prefixes.get(j), i, keys, 0).intValue() == prefixes.get(j).length();
            }
            if (flag) break;
        }
        if (i == -1) {
            return keys;
        }
        for (int index = i; index < keys.size(); ++index) {
            result.add(keys.get(index));
        }
        return result;
    }

    private boolean checkExtraKeyForCol(ArrayList<String> keys, String extraKey, ArrayList<String> prefixes) {
        boolean flag = true;
        for (int i = 0; i < keys.size() - 1 && flag; ++i) {
            flag = keys.get(i).equals(keys.get(i + 1));
        }
        if (!flag) {
            return false;
        }
        for (int j = 0; j < prefixes.size() && flag; ++j) {
            int index = prefixes.get(j).indexOf(extraKey);
            flag = index != -1 ? this.getIndexOfKeyPatternOnString(prefixes.get(j), 0, keys, index += extraKey.length()).intValue() == prefixes.get(j).length() : false;
        }
        return flag;
    }

    private Integer getIndexOfKeyPatternOnString(String str, ArrayList<String> key, int beginPos) {
        return this.getIndexOfKeyPatternOnString(str, 0, key, beginPos);
    }

    private Integer getIndexOfKeyPatternOnString(String str, int keyFromIndex, ArrayList<String> key, int beginPos) {
        int currPos = beginPos;
        boolean flag = true;
        for (int i = keyFromIndex; i < key.size(); ++i) {
            int index = str.indexOf(key.get(i), currPos);
            if (index == -1) {
                flag = false;
                break;
            }
            currPos = index + key.get(i).length();
        }
        if (flag) {
            return currPos;
        }
        return -1;
    }

    private Pair<ArrayList<String>[], HashSet<String>[]> buildColsKeyPatternSingleRow() {
        ArrayList<String>[] prefixesRemovedReverse = this.extractAllPrefixStringsOfColsSingleLine(true, true).getKey();
        ArrayList[] prefixesRemoved = new ArrayList[this.ncols];
        ArrayList<String>[] prefixes = this.extractAllPrefixStringsOfColsSingleLine(false, false).getKey();
        ArrayList<String>[] suffixes = this.extractAllSuffixStringsOfColsSingleLine(true);
        ArrayList[] prefixesRemovedReverseSort = new ArrayList[this.ncols];
        ArrayList[] keys = new ArrayList[this.ncols];
        HashSet[] colSuffixes = new HashSet[this.ncols];
        LongestCommonSubsequence lcs = new LongestCommonSubsequence();
        int numThreads = OptimizerUtils.getParallelTextWriteParallelism();
        try {
            ExecutorService pool = CommonThreadPool.get(numThreads);
            ArrayList<BuildColsKeyPatternSingleRowTask> tasks = new ArrayList<BuildColsKeyPatternSingleRowTask>();
            int blklen = (int)Math.ceil((double)this.ncols / (double)(numThreads * numThreads));
            for (int i = 0; i < numThreads; ++i) {
                HashSet<Integer> colIndexes = new HashSet<Integer>();
                for (int j = 0; j < numThreads && j * numThreads * blklen + i * blklen < this.ncols; ++j) {
                    int begin = j * numThreads * blklen + i * blklen;
                    int end = Math.min(j * numThreads * blklen + (i + 1) * blklen, this.ncols);
                    for (int k = begin; k < end; ++k) {
                        colIndexes.add(k);
                    }
                }
                tasks.add(new BuildColsKeyPatternSingleRowTask(prefixesRemovedReverse, prefixesRemoved, prefixes, suffixes, prefixesRemovedReverseSort, keys, colSuffixes, lcs, colIndexes));
            }
            List rt = pool.invokeAll(tasks);
            pool.shutdown();
            for (Future task : rt) {
                task.get();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed parallel ColsKeyPatternSingleRow.", e);
        }
        return new Pair<ArrayList<String>[], HashSet<String>[]>(keys, colSuffixes);
    }

    public String getConflictToken(int[] cols) {
        boolean flagStatic = true;
        for (int c = 0; c < cols.length && flagStatic; ++c) {
            flagStatic = this.staticColIndexes.get(cols[c]);
        }
        if (flagStatic) {
            return null;
        }
        int lastColIndex = cols[cols.length - 1];
        ArrayList<String> suffixesBetweenBeginEnd = new ArrayList<String>();
        ArrayList<String> suffixesRefine = this.extractAllSuffixStringsOfColsSingleLine(lastColIndex, true);
        HashSet<String> setSuffixesRefine = new HashSet<String>();
        setSuffixesRefine.addAll(suffixesRefine);
        if (setSuffixesRefine.size() == 1 && ((String)setSuffixesRefine.iterator().next()).length() == 0) {
            return null;
        }
        for (int r = 0; r < this.nrows; ++r) {
            int rowIndex;
            ArrayList<Integer> filledCols = new ArrayList<Integer>();
            for (int c : cols) {
                if (this.mapCol[r][c] == -1) continue;
                filledCols.add(c);
            }
            if (filledCols.size() <= 1 || (rowIndex = this.mapRow[r][(Integer)filledCols.get(0)]) == -1) continue;
            int ib = (Integer)filledCols.get(0);
            int ie = (Integer)filledCols.get(filledCols.size() - 1);
            String str = this.sampleRawIndexes[rowIndex].getRaw().substring(this.mapCol[r][ib] + this.mapLen[r][ib], this.mapCol[r][ie]);
            suffixesBetweenBeginEnd.add(str);
        }
        ArrayList<String> containList = new ArrayList<String>();
        int maxTokenLength = 0;
        String selectedString = "";
        for (String suf : suffixesRefine) {
            Object str;
            int index = suf.indexOf("\u00b0", 1);
            if (index == -1) {
                index = suf.length();
            }
            if (((String)(str = suf.substring(1, index))).length() <= 0) continue;
            containList.add((String)str);
            if (maxTokenLength != 0 && maxTokenLength <= ((String)str).length()) continue;
            maxTokenLength = ((String)str).length();
            selectedString = str;
        }
        if (containList.size() == 0) {
            return null;
        }
        HashMap conflicts = new HashMap();
        maxTokenLength = Math.min(maxTokenLength, 50);
        for (int tl = 1; tl < maxTokenLength; ++tl) {
            ArrayList<String> tokens = this.stringTokenize(selectedString, tl);
            conflicts.put(tl, new ArrayList());
            for (String t : tokens) {
                Object between;
                boolean flag = false;
                Iterator iterator = suffixesBetweenBeginEnd.iterator();
                while (iterator.hasNext() && !(flag = ((String)(between = (String)iterator.next())).contains(t))) {
                }
                if (flag) continue;
                ((ArrayList)conflicts.get(tl)).add(t);
            }
        }
        ArrayList<Pair<String, ArrayList<Object>>> candidate = new ArrayList<Pair<String, ArrayList<Object>>>();
        ArrayList<String> tokens = new ArrayList<String>();
        for (int i = maxTokenLength - 1; i > 0; --i) {
            for (String tc : (ArrayList)conflicts.get(i)) {
                boolean flag = false;
                for (String currenToken : tokens) {
                    if (!currenToken.startsWith(tc)) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
                flag = true;
                ArrayList<Integer> distances = new ArrayList<Integer>();
                boolean containZero = false;
                for (String s : containList) {
                    int index = s.indexOf(tc);
                    boolean bl = flag = index != -1;
                    if (!flag) break;
                    distances.add(index);
                    containZero |= index == 0;
                }
                if (!flag) continue;
                if (containZero) {
                    return tc;
                }
                candidate.add(new Pair(tc, distances));
                tokens.add(tc);
            }
        }
        if (candidate.size() > 0) {
            candidate.sort(this.AscendingPairListComparator);
            return (String)((Pair)candidate.get(0)).getKey();
        }
        return null;
    }

    public boolean isDelimAndSuffixesSame(String delim, int[] cols, String conflict) {
        HashSet<String>[] ends = this.properties.endWithValueStrings();
        boolean flag = true;
        for (int c = 0; c < cols.length && flag; ++c) {
            if (ends[cols[c]].size() == 0 || ends[cols[c]].size() == 1 && ends[cols[c]].iterator().next().equals(delim)) continue;
            flag = false;
        }
        if (!flag) {
            for (int r = 0; r < this.nrows; ++r) {
                int conflictIndex;
                ArrayList<Integer> c = new ArrayList<Integer>();
                for (int ci : cols) {
                    if (this.mapCol[r][ci] == -1) continue;
                    c.add(ci);
                }
                if (c.size() <= 1) continue;
                int c1 = (Integer)c.get(0);
                int rowIndex = this.mapRow[r][c1];
                String str = conflict == null ? this.sampleRawIndexes[rowIndex].getRaw().substring(this.mapCol[r][c1]) : ((conflictIndex = this.sampleRawIndexes[rowIndex].getRaw().indexOf(conflict, this.mapCol[r][c1])) != -1 ? this.sampleRawIndexes[rowIndex].getRaw().substring(this.mapCol[r][c1], conflictIndex) : this.sampleRawIndexes[rowIndex].getRaw().substring(this.mapCol[r][c1]));
                flag = true;
                if (str.length() > 0) {
                    String[] strValues = str.split(delim, -1);
                    for (int ci = 0; ci < c.size() && flag; ++ci) {
                        if (this.mapCol[r][(Integer)c.get(ci)] == -1) continue;
                        flag = this.mappingValues.compareCellValue(r, (Integer)c.get(ci), strValues[ci]);
                    }
                }
                if (!flag) break;
            }
        }
        return flag;
    }

    private ArrayList<String> stringTokenize(String str, int tokenLength) {
        ArrayList<String> result = new ArrayList<String>();
        HashSet<String> tokenSet = new HashSet<String>();
        for (int i = 0; i <= str.length() - tokenLength; ++i) {
            String token = str.substring(i, i + tokenLength);
            if (token.contains("\u00b0") || tokenSet.contains(token)) continue;
            result.add(token);
            tokenSet.add(token);
        }
        return result;
    }

    private ArrayList<String> optimalKeyPattern(ArrayList<String> keys, ArrayList<String> prefixes) {
        String[] keyList;
        ArrayList keysList = new ArrayList();
        for (int i = 0; i < keys.size() - 1; ++i) {
            keyList = keys.get(i).split("\\s+");
            ArrayList<String> orderedKeys = new ArrayList<String>();
            for (int j = 0; j < keyList.length; ++j) {
                orderedKeys.add(keyList[j]);
            }
            keysList.add(orderedKeys);
        }
        int lastIndex = keys.size() - 1;
        keyList = keys.get(lastIndex).split("\\s+");
        if (keyList.length == 0) {
            return keys;
        }
        StringBuilder sbToken = new StringBuilder(keyList[keyList.length - 1]);
        StringBuilder sbSource = new StringBuilder(keys.get(lastIndex));
        int index = sbSource.reverse().indexOf(sbToken.reverse().toString());
        keyList = keys.get(lastIndex).substring(0, keys.get(lastIndex).length() - index - sbToken.length()).split("\\s+");
        ArrayList<String> orderedKeys = new ArrayList<String>();
        for (int j = 0; j < keyList.length; ++j) {
            orderedKeys.add(keyList[j]);
        }
        if (orderedKeys.size() > 0) {
            keysList.add(orderedKeys);
            orderedKeys = new ArrayList();
        }
        orderedKeys.add(sbToken.reverse().toString());
        keysList.add(orderedKeys);
        ArrayList fullList = new ArrayList(keysList.size());
        for (int i = 0; i < keysList.size() - 1; ++i) {
            fullList.set(i, this.selfPropagate((ArrayList)keysList.get(i)));
        }
        ArrayList<ArrayList> tmpLastKey = new ArrayList<ArrayList>();
        tmpLastKey.add((ArrayList)keysList.get(keysList.size() - 1));
        fullList.set(keysList.size() - 1, tmpLastKey);
        ArrayList<ArrayList<String>> candidates = (ArrayList<ArrayList<String>>)fullList.get(0);
        for (int i = 1; i < keysList.size(); ++i) {
            if (candidates.size() * ((ArrayList)fullList.get(i)).size() > 500000) {
                ArrayList<ArrayList<String>> tmpCandidates = new ArrayList<ArrayList<String>>();
                for (ArrayList arrayList : candidates) {
                    ArrayList<String> tmpRemainList = new ArrayList<String>();
                    for (String s : arrayList) {
                        tmpRemainList.add(s);
                    }
                    for (int j = i; j < keys.size(); ++j) {
                        tmpRemainList.add(keys.get(j));
                    }
                    tmpCandidates.add(tmpRemainList);
                }
                candidates = new ArrayList();
                ArrayList<String> tmp = new ArrayList<String>();
                ArrayList<String> arrayList = this.checkPattern(tmpCandidates, prefixes).getKey();
                for (int j = 0; j < arrayList.size() - (keys.size() - i); ++j) {
                    tmp.add(arrayList.get(j));
                }
                candidates.add(tmp);
                candidates = this.cartesianProduct(candidates, (ArrayList)fullList.get(i));
                continue;
            }
            candidates = this.cartesianProduct(candidates, (ArrayList)fullList.get(i));
        }
        Pair<ArrayList<String>, Boolean> update = this.checkPattern(candidates, prefixes);
        if (update.getValue().booleanValue()) {
            return update.getKey();
        }
        return keys;
    }

    private Pair<ArrayList<String>, Boolean> checkPattern(ArrayList<ArrayList<String>> candidates, ArrayList<String> prefixes) {
        candidates.sort(this.AscendingArrayOfStringComparator);
        int index = -1;
        for (int i = 0; i < candidates.size(); ++i) {
            boolean tmpCheck = true;
            for (int j = 0; j < prefixes.size() && tmpCheck; ++j) {
                tmpCheck = this.getIndexOfKeyPatternOnString(prefixes.get(j), candidates.get(i), 0).intValue() == prefixes.get(j).length();
            }
            if (!tmpCheck) continue;
            index = i;
            break;
        }
        if (index != -1) {
            return new Pair<ArrayList<String>, Boolean>(candidates.get(index), true);
        }
        return new Pair<ArrayList<String>, Boolean>(new ArrayList(), false);
    }

    private ArrayList<ArrayList<String>> cartesianProduct(ArrayList<ArrayList<String>> list1, ArrayList<ArrayList<String>> list2) {
        ArrayList<ArrayList<String>> result = new ArrayList<ArrayList<String>>();
        for (ArrayList<String> stringArrayList : list1) {
            for (ArrayList<String> strings : list2) {
                ArrayList<String> tmpList = new ArrayList<String>();
                for (String s : stringArrayList) {
                    if (s.length() <= 0) continue;
                    tmpList.add(s);
                }
                for (String s : strings) {
                    if (s.length() <= 0) continue;
                    tmpList.add(s);
                }
                result.add(tmpList);
            }
        }
        return result;
    }

    private ArrayList<ArrayList<String>> selfPropagate(ArrayList<String> list) {
        ArrayList<ArrayList<String>> result = new ArrayList<ArrayList<String>>();
        int n = list.size();
        int allMasks = 1 << n;
        for (int i = 1; i < allMasks; ++i) {
            ArrayList<String> tmp = new ArrayList<String>();
            for (int j = 0; j < n; ++j) {
                if ((i & 1 << j) <= 0) continue;
                tmp.add(list.get(j));
            }
            result.add(tmp);
        }
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.add("");
        result.add(tmp);
        result.sort(this.AscendingArrayOfStringComparator);
        return result;
    }

    private class BuildColsKeyPatternSingleRowTask
    implements Callable<Object> {
        private final ArrayList<String>[] prefixesRemovedReverse;
        private final ArrayList<String>[] prefixesRemoved;
        private final ArrayList<String>[] prefixes;
        private final ArrayList<String>[] suffixes;
        private final ArrayList<Pair<String, Integer>>[] prefixesRemovedReverseSort;
        private final ArrayList<String>[] keys;
        private final HashSet<String>[] colSuffixes;
        private final LongestCommonSubsequence lcs;
        private final HashSet<Integer> colIndexes;

        public BuildColsKeyPatternSingleRowTask(ArrayList<String>[] prefixesRemovedReverse, ArrayList<String>[] prefixesRemoved, ArrayList<String>[] prefixes, ArrayList<String>[] suffixes, ArrayList<Pair<String, Integer>>[] prefixesRemovedReverseSort, ArrayList<String>[] keys, HashSet<String>[] colSuffixes, LongestCommonSubsequence lcs, HashSet<Integer> colIndexes) {
            this.prefixesRemovedReverse = prefixesRemovedReverse;
            this.prefixesRemoved = prefixesRemoved;
            this.prefixes = prefixes;
            this.suffixes = suffixes;
            this.prefixesRemovedReverseSort = prefixesRemovedReverseSort;
            this.keys = keys;
            this.colSuffixes = colSuffixes;
            this.lcs = lcs;
            this.colIndexes = colIndexes;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Object call() throws Exception {
            for (int c : this.colIndexes) {
                this.keys[c] = new ArrayList();
                HashMap mapPrefixesRemovedReverse = new HashMap();
                for (int i = 0; i < this.prefixesRemovedReverse[c].size(); ++i) {
                    StringBuilder stringBuilder = new StringBuilder();
                    String str = this.prefixesRemovedReverse[c].get(i).replaceAll("\\d", "\u00b0");
                    for (int j = 0; j < str.length(); ++j) {
                        String string = "" + str.charAt(j);
                        if (!string.equals("\u00b0")) {
                            stringBuilder.append(string);
                            continue;
                        }
                        if (stringBuilder.length() != 0 && ("" + stringBuilder.charAt(stringBuilder.length() - 1)).equals("\u00b0")) continue;
                        stringBuilder.append("\u00b0");
                    }
                    String sbStr = stringBuilder.toString();
                    if (!mapPrefixesRemovedReverse.containsKey(sbStr)) {
                        mapPrefixesRemovedReverse.put(sbStr, new ArrayList());
                    }
                    ((ArrayList)mapPrefixesRemovedReverse.get(sbStr)).add(i);
                }
                this.prefixesRemovedReverse[c] = new ArrayList();
                this.prefixesRemoved[c] = new ArrayList();
                this.prefixesRemovedReverseSort[c] = new ArrayList();
                for (String string : mapPrefixesRemovedReverse.keySet()) {
                    this.prefixesRemovedReverseSort[c].add(new Pair<String, Integer>(string, (Integer)((ArrayList)mapPrefixesRemovedReverse.get(string)).get(0)));
                }
                this.prefixesRemovedReverseSort[c].sort(FormatIdentifyer.this.AscendingPairStringComparator);
                for (Pair pair : this.prefixesRemovedReverseSort[c]) {
                    this.prefixesRemovedReverse[c].add((String)pair.getKey());
                    this.prefixesRemoved[c].add(new StringBuilder((String)pair.getKey()).reverse().toString());
                }
            }
            for (int c : this.colIndexes) {
                boolean bl;
                boolean bl2;
                if (this.prefixesRemoved[c].size() == 1) {
                    this.keys[c] = new ArrayList();
                    if (this.prefixesRemoved[c].get(0).length() == 0 || this.prefixesRemoved[c].get(0).equals("\u00b0")) {
                        this.keys[c].add("");
                    }
                    String[] lcsKey = this.prefixesRemoved[c].get(0).split("\u00b0");
                    for (String sk : lcsKey) {
                        if (sk.length() <= 0) continue;
                        this.keys[c].add(sk);
                    }
                    continue;
                }
                String selectedString = this.prefixesRemoved[c].get(0);
                int n = 1;
                StringBuilder sbToken = new StringBuilder();
                sbToken.append(selectedString.charAt(selectedString.length() - 1));
                for (int i = 2; i < selectedString.length() && bl2; ++i) {
                    char c2 = selectedString.charAt(selectedString.length() - i);
                    for (int j = 1; j < this.prefixesRemoved[c].size() && bl2; ++j) {
                        String str = this.prefixesRemoved[c].get(j);
                        bl2 = str.charAt(str.length() - i) == c2;
                    }
                    if (!bl2) continue;
                    sbToken.append(c2);
                }
                String firstKey = sbToken.reverse().toString();
                bl2 = true;
                String[] lcsKey = firstKey.split("\u00b0");
                ArrayList<String> arrayList = new ArrayList<String>();
                for (String sk : lcsKey) {
                    if (sk.length() <= 0) continue;
                    arrayList.add(sk);
                }
                for (int i = 0; i < this.prefixes[c].size() && bl; ++i) {
                    bl = FormatIdentifyer.this.getIndexOfKeyPatternOnString(this.prefixes[c].get(i), arrayList, 0).intValue() == this.prefixes[c].get(i).length();
                }
                if (bl) {
                    this.keys[c] = arrayList;
                    continue;
                }
                int indexI = 0;
                int indexJ = 0;
                Set<String> refineKeysStep = new HashSet<String>();
                while (true) {
                    if (indexI < this.prefixesRemovedReverseSort[c].size() - 1 && refineKeysStep.size() == 0) {
                        String str1 = this.prefixesRemoved[c].get(indexI);
                        String[] psStr1 = this.prefixes[c].get(this.prefixesRemovedReverseSort[c].get(indexI).getValue());
                        for (indexJ = indexI + 1; indexJ < this.prefixesRemovedReverseSort[c].size() && refineKeysStep.size() == 0; ++indexJ) {
                            String str2 = this.prefixesRemoved[c].get(indexJ);
                            String psStr2 = this.prefixes[c].get(this.prefixesRemovedReverseSort[c].get(indexJ).getValue());
                            refineKeysStep = FormatIdentifyer.this.getRefineKeysStep(this.lcs, str1, str2, (String)psStr1, psStr2, firstKey);
                        }
                        ++indexI;
                        continue;
                    }
                    if (indexI < this.prefixesRemovedReverse[c].size() - 1 && indexJ < this.prefixesRemovedReverse[c].size()) break;
                    while (true) {
                        Pair<Set<String>, Set<String>> pair = FormatIdentifyer.this.getNewRefineKeys(this.lcs, firstKey, this.prefixesRemoved[c], this.prefixes[c], refineKeysStep);
                        refineKeysStep = pair.getKey();
                        if (pair.getValue().size() == 0) break;
                        refineKeysStep.addAll((Collection<String>)pair.getValue());
                    }
                    if (refineKeysStep.size() != 0) break;
                }
                if (refineKeysStep.size() == 0) continue;
                if (refineKeysStep.size() == 1) {
                    String[] refinedLCSKey = ((String)refineKeysStep.iterator().next() + "\u00b0" + firstKey).split("\u00b0");
                    this.keys[c] = new ArrayList();
                    for (String sk : refinedLCSKey) {
                        if (sk.length() <= 0) continue;
                        this.keys[c].add(sk);
                    }
                    continue;
                }
                ArrayList<String> sortedStrings = new ArrayList<String>();
                sortedStrings.addAll(refineKeysStep);
                Collections.sort(sortedStrings, FormatIdentifyer.this.AscendingStringLengthComparator);
                String[] refinedLCSKey = ((String)sortedStrings.get(sortedStrings.size() - 1) + "\u00b0" + firstKey).split("\u00b0");
                this.keys[c] = new ArrayList();
                for (String sk : refinedLCSKey) {
                    if (sk.length() <= 0) continue;
                    this.keys[c].add(sk);
                }
            }
            for (int c : this.colIndexes) {
                void var5_14;
                ArrayList<String> cleanUPKeys = FormatIdentifyer.this.cleanUPKey(this.keys[c], this.prefixes[c]);
                Boolean flagFixCol = true;
                boolean bl = false;
                while (var5_14 < FormatIdentifyer.this.nrows && flagFixCol.booleanValue() && this.prefixes[c].size() != FormatIdentifyer.this.nrows) {
                    String rawStr = FormatIdentifyer.this.sampleRawIndexes[var5_14].getRaw();
                    flagFixCol = FormatIdentifyer.this.getIndexOfKeyPatternOnString(rawStr, cleanUPKeys, 0) != -1;
                    ++var5_14;
                }
                FormatIdentifyer.this.staticColIndexes.set(c, flagFixCol);
                if (!flagFixCol.booleanValue() && cleanUPKeys.size() < this.keys[c].size()) {
                    String string = this.keys[c].get(this.keys[c].size() - cleanUPKeys.size() - 1);
                    if (FormatIdentifyer.this.checkExtraKeyForCol(cleanUPKeys, string, this.prefixes[c])) {
                        this.keys[c] = new ArrayList();
                        this.keys[c].add(string);
                        this.keys[c].addAll(cleanUPKeys);
                    } else {
                        this.keys[c] = cleanUPKeys;
                    }
                } else {
                    this.keys[c] = cleanUPKeys;
                }
                HashSet<String> hashSet = new HashSet<String>();
                TextTrie suffixTrie = new TextTrie();
                for (String string : this.suffixes[c]) {
                    String[] suffixesList = string.split("\u00b0", -1);
                    if (suffixesList.length <= 0 || suffixesList.length == 1 && suffixesList[0].length() == 0) continue;
                    if (suffixesList[1].length() < FormatIdentifyer.this.suffixStringLength) {
                        hashSet.add(suffixesList[1]);
                        continue;
                    }
                    hashSet.add(suffixesList[1].substring(0, FormatIdentifyer.this.suffixStringLength));
                }
                if (hashSet.size() == 0) {
                    this.colSuffixes[c] = new HashSet();
                    continue;
                }
                int rowIndexSuffix = 0;
                for (String ss : hashSet) {
                    suffixTrie.insert(ss, rowIndexSuffix++);
                }
                HashSet<String> hashSet2 = new HashSet<String>();
                ArrayList<Pair<String, Set<Integer>>> allSuffixes = suffixTrie.getAllKeys();
                if (allSuffixes.get(0).getValue().size() == hashSet.size()) {
                    hashSet2.add(allSuffixes.get(0).getKey());
                } else {
                    HashSet coveredRowIndexes = new HashSet();
                    for (Pair<String, Set<Integer>> p : allSuffixes) {
                        int currentSize = coveredRowIndexes.size();
                        coveredRowIndexes.addAll(p.getValue());
                        if (currentSize == coveredRowIndexes.size()) continue;
                        hashSet2.add(p.getKey());
                    }
                }
                this.colSuffixes[c] = hashSet2;
            }
            return new Pair<ArrayList<String>[], HashSet<String>[]>(this.keys, this.colSuffixes);
        }
    }
}

