/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.matrix.data;

import java.util.Iterator;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.sysds.runtime.data.DenseBlockFP64DEDUP;
import org.apache.sysds.runtime.matrix.data.Converter;
import org.apache.sysds.runtime.matrix.data.IJV;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.util.UtilFunctions;

public class BinaryBlockToTextCellConverter
implements Converter<MatrixIndexes, MatrixBlock, NullWritable, Text> {
    private Iterator<IJV> sparseIterator = null;
    private double[] denseArray = null;
    private int denseArraySize = 0;
    private int nextInDenseArray = -1;
    private boolean sparse = true;
    private int thisBlockWidth = 0;
    private MatrixIndexes startIndexes = new MatrixIndexes();
    private boolean hasValue = false;
    private int brow;
    private int bcolumn;
    private Text value = new Text();
    private Pair<NullWritable, Text> pair = new Pair<NullWritable, Text>(NullWritable.get(), this.value);

    private void reset() {
        this.sparseIterator = null;
        this.denseArray = null;
        this.denseArraySize = 0;
        this.nextInDenseArray = -1;
        this.sparse = true;
        this.thisBlockWidth = 0;
    }

    @Override
    public void convert(MatrixIndexes k1, MatrixBlock v1) {
        this.reset();
        this.startIndexes.setIndexes(UtilFunctions.computeCellIndex(k1.getRowIndex(), this.brow, 0), UtilFunctions.computeCellIndex(k1.getColumnIndex(), this.bcolumn, 0));
        this.sparse = v1.isInSparseFormat();
        this.thisBlockWidth = v1.getNumColumns();
        if (this.sparse) {
            this.sparseIterator = v1.getSparseBlockIterator();
        } else {
            if (v1.getDenseBlock() == null) {
                return;
            }
            if (v1.getDenseBlock() instanceof DenseBlockFP64DEDUP) {
                DenseBlockFP64DEDUP db = (DenseBlockFP64DEDUP)v1.getDenseBlock();
                this.denseArray = new double[v1.rlen * v1.clen];
                for (int i = 0; i < v1.rlen; ++i) {
                    double[] row = db.values(i);
                    for (int j = 0; j < v1.clen; ++j) {
                        this.denseArray[i * v1.clen + j] = row[j];
                    }
                }
            } else {
                this.denseArray = v1.getDenseBlockValues();
            }
            this.nextInDenseArray = 0;
            this.denseArraySize = v1.getNumRows() * v1.getNumColumns();
        }
        this.hasValue = v1.getNonZeros() > 0L;
    }

    @Override
    public boolean hasNext() {
        if (this.sparse) {
            this.hasValue = this.sparseIterator == null ? false : this.sparseIterator.hasNext();
        } else if (this.denseArray == null) {
            this.hasValue = false;
        } else {
            while (this.nextInDenseArray < this.denseArraySize && this.denseArray[this.nextInDenseArray] == 0.0) {
                ++this.nextInDenseArray;
            }
            this.hasValue = this.nextInDenseArray < this.denseArraySize;
        }
        return this.hasValue;
    }

    @Override
    public Pair<NullWritable, Text> next() {
        double v;
        long j;
        long i;
        if (!this.hasValue) {
            return null;
        }
        if (this.sparse) {
            if (this.sparseIterator == null) {
                return null;
            }
            IJV cell = this.sparseIterator.next();
            i = (long)cell.getI() + this.startIndexes.getRowIndex();
            j = (long)cell.getJ() + this.startIndexes.getColumnIndex();
            v = cell.getV();
        } else {
            if (this.denseArray == null) {
                return null;
            }
            i = this.startIndexes.getRowIndex() + (long)(this.nextInDenseArray / this.thisBlockWidth);
            j = this.startIndexes.getColumnIndex() + (long)(this.nextInDenseArray % this.thisBlockWidth);
            v = this.denseArray[this.nextInDenseArray];
            ++this.nextInDenseArray;
        }
        this.value.set(i + " " + j + " " + v);
        return this.pair;
    }

    @Override
    public void setBlockSize(int nr, int nc) {
        this.brow = nr;
        this.bcolumn = nc;
    }
}

