/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.cocode;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.cocode.ColIndexes;
import org.apache.sysds.runtime.compress.estim.AComEst;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;

public class Memorizer {
    private final AComEst _sEst;
    private final Map<ColIndexes, CompressedSizeInfoColGroup> mem;
    private int st1 = 0;
    private int st2 = 0;
    private int st3 = 0;
    private int st4 = 0;

    public Memorizer(AComEst sEst) {
        this._sEst = sEst;
        this.mem = new HashMap<ColIndexes, CompressedSizeInfoColGroup>();
    }

    public void put(CompressedSizeInfoColGroup g) {
        this.mem.put(new ColIndexes(g.getColumns()), g);
    }

    public void put(ColIndexes key, CompressedSizeInfoColGroup val) {
        this.mem.put(key, val);
    }

    public CompressedSizeInfoColGroup get(ColIndexes c) {
        return this.mem.get(c);
    }

    public void remove(ColIndexes c1, ColIndexes c2) {
        Iterator<Map.Entry<ColIndexes, CompressedSizeInfoColGroup>> i = this.mem.entrySet().iterator();
        while (i.hasNext()) {
            ColIndexes eci = i.next().getKey();
            if (!eci.contains(c1, c2)) continue;
            i.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompressedSizeInfoColGroup getOrCreate(ColIndexes cI, ColIndexes c1, ColIndexes c2) {
        CompressedSizeInfoColGroup g = this.mem.get(cI);
        ++this.st2;
        if (g == null) {
            CompressedSizeInfoColGroup left = this.mem.get(c1);
            CompressedSizeInfoColGroup right = this.mem.get(c2);
            if (left != null && right != null) {
                ++this.st3;
                g = this._sEst.combine(cI._indexes, left, right);
                if (g != null && g.getNumVals() < 0) {
                    throw new DMLCompressionException("Combination returned less distinct values on: \n" + left + "\nand\n" + right + "\nEq\n" + g);
                }
                Memorizer memorizer = this;
                synchronized (memorizer) {
                    this.mem.put(cI, g);
                }
            }
        }
        return g;
    }

    public void incst1() {
        ++this.st1;
    }

    public void incst4() {
        ++this.st4;
    }

    public String stats() {
        return " possible: " + this.st1 + " requests: " + this.st2 + " combined: " + this.st3 + " outSecond: " + this.st4;
    }

    public void resetStats() {
        this.st1 = 0;
        this.st2 = 0;
        this.st3 = 0;
        this.st4 = 0;
    }

    public String toString() {
        return this.mem.toString();
    }
}

