/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.mapping;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.sysds.runtime.compress.colgroup.IMapToDataGroup;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToZero;
import org.apache.sysds.runtime.frame.data.columns.BitSetArray;
import org.apache.sysds.utils.MemoryEstimates;

public class MapToBit
extends AMapToData {
    private static final long serialVersionUID = -8065234231282619903L;
    private final long[] _data;
    private final int _size;

    protected MapToBit(int size) {
        this(2, size);
    }

    public MapToBit(int unique, int size) {
        super(Math.min(unique, 2));
        this._data = new long[MapToBit.longSize(size)];
        this._size = size;
    }

    private MapToBit(int unique, BitSet d, int size) {
        this(unique, d.toLongArray(), size);
    }

    private MapToBit(int unique, long[] bsd, int size) {
        super(unique);
        if (bsd.length == MapToBit.longSize(size)) {
            this._data = bsd;
        } else {
            this._data = new long[MapToBit.longSize(size)];
            System.arraycopy(bsd, 0, this._data, 0, bsd.length);
        }
        this._size = size;
    }

    @Override
    public MapToFactory.MAP_TYPE getType() {
        return MapToFactory.MAP_TYPE.BIT;
    }

    @Override
    public int getIndex(int n) {
        int wIdx = n >> 6;
        return (this._data[wIdx] & 1L << n) != 0L ? 1 : 0;
    }

    @Override
    public void fill(int v) {
        long fillValue;
        long re = this._data.length * 64 - this._size;
        boolean fillZero = v == 0;
        long l = fillValue = fillZero ? 0L : -1L;
        if (re == 0L || fillZero) {
            Arrays.fill(this._data, fillValue);
        } else {
            Arrays.fill(this._data, 0, this._data.length - 1, fillValue);
            this._data[this._data.length - 1] = -1L >>> (int)re;
        }
    }

    @Override
    public long getInMemorySize() {
        return MapToBit.getInMemorySize(this._size);
    }

    public static long getInMemorySize(int dataLength) {
        long size = 20L;
        size = (long)((double)size + MemoryEstimates.longArrayCost(dataLength >> 7));
        return size;
    }

    @Override
    public void set(int n, int v) {
        int wIdx = n >> 6;
        if (v == 1) {
            int n2 = wIdx;
            this._data[n2] = this._data[n2] | 1L << n;
        } else {
            int n3 = wIdx;
            this._data[n3] = this._data[n3] & (1L << n ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    @Override
    public void set(int l, int u, int off, AMapToData tm) {
        int i = l;
        while (i < u) {
            this.set(i, tm.getIndex(off));
            ++i;
            ++off;
        }
    }

    @Override
    public int setAndGet(int n, int v) {
        this.set(n, v);
        return v == 1 ? 1 : 0;
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public void replace(int v, int r) {
        if (v == 0) {
            this.fill(1);
        } else {
            this.fill(0);
        }
    }

    @Override
    public long getExactSizeOnDisk() {
        long size = 9L;
        return size += (long)(this._data.length * 8);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(MapToFactory.MAP_TYPE.BIT.ordinal());
        out.writeInt(this._size);
        out.writeInt(this._data.length);
        for (int i = 0; i < this._data.length; ++i) {
            out.writeLong(this._data[i]);
        }
    }

    protected static MapToBit readFields(DataInput in) throws IOException {
        int size = in.readInt();
        long[] data = new long[in.readInt()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = in.readLong();
        }
        return new MapToBit(2, data, size);
    }

    @Override
    public int getUpperBoundValue() {
        return 1;
    }

    @Override
    public int[] getCounts(int[] ret) {
        int sz = this.size();
        for (int i = 0; i < this._data.length; ++i) {
            ret[1] = ret[1] + Long.bitCount(this._data[i]);
        }
        ret[0] = sz - ret[1];
        return ret;
    }

    @Override
    public void preAggregateDDC_DDCSingleCol(AMapToData tm, double[] td, double[] v) {
        if (tm instanceof MapToBit) {
            this.preAggregateDDCSingleColBitBit((MapToBit)tm, td, v);
        } else {
            super.preAggregateDDC_DDCSingleCol(tm, td, v);
        }
    }

    private void preAggregateDDCSingleColBitBit(MapToBit tmb, double[] td, double[] v) {
        JoinBitSets j = new JoinBitSets(tmb, this, this._size);
        v[1] = v[1] + td[1] * (double)j.tt;
        v[0] = v[0] + td[1] * (double)j.ft;
        v[1] = v[1] + td[0] * (double)j.tf;
        v[0] = v[0] + td[0] * (double)j.ff;
    }

    @Override
    public void preAggregateDDC_DDCMultiCol(AMapToData tm, IDictionary td, double[] v, int nCol) {
        if (tm instanceof MapToBit) {
            this.preAggregateDDCMultiColBitBit((MapToBit)tm, td, v, nCol);
        } else {
            super.preAggregateDDC_DDCMultiCol(tm, td, v, nCol);
        }
    }

    private void preAggregateDDCMultiColBitBit(MapToBit tmb, IDictionary td, double[] v, int nCol) {
        JoinBitSets j = new JoinBitSets(tmb, this, this._size);
        double[] tv = td.getValues();
        int i = 0;
        while (i < nCol) {
            int off = nCol + i;
            int n = i;
            v[n] = v[n] + tv[i] * (double)j.ff;
            int n2 = off;
            v[n2] = v[n2] + tv[i] * (double)j.tf;
            int n3 = off;
            v[n3] = v[n3] + tv[off] * (double)j.tt;
            int n4 = i++;
            v[n4] = v[n4] + tv[off] * (double)j.ft;
        }
    }

    public boolean isEmpty() {
        for (int i = 0; i < this._data.length; ++i) {
            if (this._data[i] == 0L) continue;
            return false;
        }
        return true;
    }

    @Override
    public void copyInt(int[] d, int start, int end) {
        for (int i = start; i < end; ++i) {
            this.set(i, d[i]);
        }
    }

    @Override
    public void copyBit(MapToBit d) {
        long[] vals = d._data;
        System.arraycopy(vals, 0, this._data, 0, Math.min(vals.length, this._data.length));
    }

    public int nextSetBit(int fromIndex) {
        if (fromIndex >= this._size) {
            return -1;
        }
        int u = fromIndex >> 6;
        int s = this._data.length;
        long word = this._data[u] & -1L << fromIndex;
        while (word == 0L) {
            if (++u == s) {
                return -1;
            }
            word = this._data[u];
        }
        return u * 64 + Long.numberOfTrailingZeros(word);
    }

    @Override
    public AMapToData resize(int unique) {
        if (unique <= 1) {
            return new MapToZero(this.size());
        }
        return this;
    }

    @Override
    public int countRuns() {
        if (this._size <= 64) {
            long l = this._data[0];
            if (this._size != 64 && this.getIndex(this._size - 1) == 1) {
                long mask = 0xFFFFFFFFFFFFFFFFL ^ -1L << this._size - 64 ^ 0xFFFFFFFFFFFFFFFFL;
                l |= mask;
            }
            long shift1 = l << 1 | l & 1L;
            long j = l ^ shift1;
            return 1 + Long.bitCount(j);
        }
        long[] _longs = this._data;
        long lastMask = Long.MIN_VALUE;
        long l = _longs[0];
        long shift1 = l << 1 | l & 1L;
        long j = l ^ shift1;
        int c = 1 + Long.bitCount(j);
        for (int i = 1; i < _longs.length - 1; ++i) {
            shift1 = _longs[i] << 1 | (_longs[i - 1] & Long.MIN_VALUE) >>> 63;
            c += Long.bitCount(_longs[i] ^ shift1);
        }
        int idx = _longs.length - 1;
        l = this._size % 64 != 0 && this.getIndex(this._size - 1) == 1 ? _longs[idx] | 0xFFFFFFFFFFFFFFFFL ^ -1L << this._size - 64 ^ 0xFFFFFFFFFFFFFFFFL : _longs[idx];
        shift1 = l << 1 | (_longs[idx - 1] & Long.MIN_VALUE) >>> 63;
        return c += Long.bitCount(l ^ shift1);
    }

    @Override
    public AMapToData slice(int l, int u) {
        long[] s = BitSetArray.sliceVectorized(this._data, l, u);
        MapToBit m = new MapToBit(this.getUnique(), s, u - l);
        if (m.isEmpty()) {
            return new MapToZero(u - l);
        }
        return m;
    }

    @Override
    public AMapToData append(AMapToData t) {
        if (t instanceof MapToBit) {
            MapToBit tb = (MapToBit)t;
            int newSize = this._size + t.size();
            long[] ret = new long[MapToBit.longSize(newSize)];
            System.arraycopy(this._data, 0, ret, 0, this._data.length);
            BitSetArray.setVectorizedLongs(this._size, newSize, ret, tb._data);
            return new MapToBit(2, ret, newSize);
        }
        throw new NotImplementedException("Not implemented append on Bit map different type");
    }

    @Override
    public boolean equals(AMapToData e) {
        return e instanceof MapToBit && e.getUnique() == this.getUnique() && ((MapToBit)e)._size == this._size && Arrays.equals(((MapToBit)e)._data, this._data);
    }

    @Override
    public AMapToData appendN(IMapToDataGroup[] d) {
        int p = 0;
        for (IMapToDataGroup gd : d) {
            p += gd.getMapToData().size();
        }
        long[] ret = new long[MapToBit.longSize(p)];
        long[] or = null;
        p = 0;
        for (int i = 0; i < d.length; ++i) {
            if (d[i].getMapToData().size() <= 0) continue;
            MapToBit mm = (MapToBit)d[i].getMapToData();
            int ms = mm.size();
            or = mm._data;
            BitSetArray.setVectorizedLongs(p, p + ms, ret, or);
            p += ms;
        }
        BitSet retBS = BitSet.valueOf(ret);
        return new MapToBit(this.getUnique(), retBS, p);
    }

    private static int longSize(int size) {
        return Math.max(size >> 6, 0) + 1;
    }

    @Override
    public void decompressToRangeOff(double[] c, int rl, int ru, int offR, double[] values) {
        int offT = rl + offR;
        for (int i = rl; i < ru; ++i) {
            int n = offT++;
            c[n] = c[n] + values[this.getIndex(i)];
        }
    }

    @Override
    public void decompressToRangeNoOff(double[] c, int rl, int ru, double[] values) {
        for (int i = rl; i < ru; ++i) {
            int n = i;
            c[n] = c[n] + values[this.getIndex(i)];
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(" size: " + this._size);
        sb.append(" longLength:[");
        sb.append(this._data.length);
        sb.append("]");
        return sb.toString();
    }

    private static class JoinBitSets {
        int tt = 0;
        int ft = 0;
        int tf = 0;
        int ff = 0;

        protected JoinBitSets(MapToBit t_data, MapToBit o_data, int size) {
            long[] t_longs = t_data._data;
            long[] _longs = o_data._data;
            if (t_longs.length != _longs.length) {
                throw new RuntimeException("Invalid to join bit sets not same length");
            }
            for (int i = 0; i < _longs.length; ++i) {
                long t = t_longs[i];
                long v = _longs[i];
                this.tt += Long.bitCount(t & v);
                this.ft += Long.bitCount(t & (v ^ 0xFFFFFFFFFFFFFFFFL));
                this.tf += Long.bitCount((t ^ 0xFFFFFFFFFFFFFFFFL) & v);
                this.ff += Long.bitCount((t ^ 0xFFFFFFFFFFFFFFFFL) & (v ^ 0xFFFFFFFFFFFFFFFFL));
            }
            int longest = Math.max(t_longs.length, _longs.length);
            this.ff += size - longest * 64;
        }
    }
}

