/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import java.util.HashSet;
import org.apache.sysds.common.Opcodes;
import org.apache.sysds.common.Types;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.runtime.instructions.InstructionUtils;

public class SortKeys
extends Lop {
    public static final String OPCODE = Opcodes.QSORT.toString();
    private OperationTypes operation;
    private int _numThreads;

    public OperationTypes getOpType() {
        return this.operation;
    }

    public SortKeys(Lop input, OperationTypes op, Types.DataType dt, Types.ValueType vt, Types.ExecType et, int numThreads) {
        super(Lop.Type.SortKeys, dt, vt);
        this.init(input, null, op, et, numThreads);
    }

    public SortKeys(Lop input, boolean desc, OperationTypes op, Types.DataType dt, Types.ValueType vt, Types.ExecType et) {
        super(Lop.Type.SortKeys, dt, vt);
        this.init(input, null, op, et, 1);
    }

    public SortKeys(Lop input1, Lop input2, OperationTypes op, Types.DataType dt, Types.ValueType vt, Types.ExecType et, int numThreads) {
        super(Lop.Type.SortKeys, dt, vt);
        this.init(input1, input2, op, et, numThreads);
    }

    private void init(Lop input1, Lop input2, OperationTypes op, Types.ExecType et, int numThreads) {
        this.addInput(input1);
        input1.addOutput(this);
        this.operation = op;
        this._numThreads = numThreads;
        if (input2 != null) {
            this.addInput(input2);
            input2.addOutput(this);
        }
        this.lps.setProperties(this.inputs, et);
    }

    @Override
    public String toString() {
        return "Operation: SortKeys (" + this.operation + ")";
    }

    @Override
    public String getInstructions(String input, String output) {
        String ret = InstructionUtils.concatOperands(this.getExecType().name(), OPCODE, this.getInputs().get(0).prepInputOperand(input), this.prepOutputOperand(output));
        if (this.getExecType() == Types.ExecType.CP) {
            ret = InstructionUtils.concatOperands(ret, Integer.toString(this._numThreads));
        }
        if (this.getExecType() == Types.ExecType.FED) {
            ret = InstructionUtils.concatOperands(ret, Integer.toString(this._numThreads), this._fedOutput.name());
        }
        return ret;
    }

    @Override
    public String getInstructions(String input1, String input2, String output) {
        String ret = InstructionUtils.concatOperands(this.getExecType().name(), OPCODE, this.getInputs().get(0).prepInputOperand(input1), this.getInputs().get(1).prepInputOperand(input2), this.prepOutputOperand(output));
        if (this.getExecType() == Types.ExecType.CP) {
            ret = InstructionUtils.concatOperands(ret, Integer.toString(this._numThreads));
        }
        if (this.getExecType() == Types.ExecType.FED) {
            ret = InstructionUtils.concatOperands(ret, Integer.toString(this._numThreads), this._fedOutput.name());
        }
        return ret;
    }

    public static SortKeys constructSortByValueLop(Lop input1, OperationTypes op, Types.DataType dt, Types.ValueType vt, Types.ExecType et, int numThreads) {
        for (Lop lop : input1.getOutputs()) {
            if (lop.type != Lop.Type.SortKeys) continue;
            return (SortKeys)lop;
        }
        SortKeys retVal = new SortKeys(input1, op, dt, vt, et, numThreads);
        retVal.setAllPositions(input1.getFilename(), input1.getBeginLine(), input1.getBeginColumn(), input1.getEndLine(), input1.getEndColumn());
        return retVal;
    }

    public static SortKeys constructSortByValueLop(Lop input1, Lop input2, OperationTypes op, Types.DataType dt, Types.ValueType vt, Types.ExecType et, int numThreads) {
        HashSet<Lop> set1 = new HashSet<Lop>();
        set1.addAll(input1.getOutputs());
        set1.retainAll(input2.getOutputs());
        for (Lop lop : set1) {
            if (lop.type != Lop.Type.SortKeys) continue;
            return (SortKeys)lop;
        }
        SortKeys retVal = new SortKeys(input1, input2, op, dt, vt, et, numThreads);
        retVal.setAllPositions(input1.getFilename(), input1.getBeginLine(), input1.getBeginColumn(), input1.getEndLine(), input1.getEndColumn());
        return retVal;
    }

    public static enum OperationTypes {
        WithWeights,
        WithoutWeights,
        Indexes;

    }
}

