/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data.lib;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.frame.data.columns.ACompressedArray;
import org.apache.sysds.runtime.frame.data.columns.Array;
import org.apache.sysds.runtime.frame.data.columns.ArrayFactory;
import org.apache.sysds.runtime.frame.data.columns.ColumnMetadata;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.util.CommonThreadPool;

public class FrameLibApplySchema {
    protected static final Log LOG = LogFactory.getLog((String)FrameLibApplySchema.class.getName());
    public static int PAR_ROW_THRESHOLD = 1024;
    private final FrameBlock fb;
    private final Types.ValueType[] schema;
    private final boolean[] nulls;
    private final int nCol;
    private final int nRow;
    private final Array<?>[] columnsIn;
    private final Array<?>[] columnsOut;
    private final int k;

    public static FrameBlock applySchema(FrameBlock fb, FrameBlock schema) {
        return FrameLibApplySchema.applySchema(fb, schema, 1);
    }

    public static FrameBlock applySchema(FrameBlock fb, FrameBlock schema, int k) {
        Types.ValueType[] sv = new Types.ValueType[schema.getNumColumns()];
        boolean[] nulls = new boolean[schema.getNumColumns()];
        for (int i = 0; i < schema.getNumColumns(); ++i) {
            String[] v = schema.get(0, i).toString().split("\u00b7");
            nulls[i] = v.length == 2 && v[1].equals("n");
            sv[i] = Types.ValueType.fromExternalString(v[0]);
        }
        return new FrameLibApplySchema(fb, sv, nulls, k).apply();
    }

    public static FrameBlock applySchema(FrameBlock fb, Types.ValueType[] schema) {
        return new FrameLibApplySchema(fb, schema, null, 1).apply();
    }

    public static FrameBlock applySchema(FrameBlock fb, Types.ValueType[] schema, int k) {
        return new FrameLibApplySchema(fb, schema, null, k).apply();
    }

    public static FrameBlock applySchema(FrameBlock fb, Types.ValueType[] schema, boolean[] nulls, int k) {
        return new FrameLibApplySchema(fb, schema, nulls, k).apply();
    }

    private FrameLibApplySchema(FrameBlock fb, Types.ValueType[] schema, boolean[] nulls, int k) {
        this.fb = fb;
        this.schema = schema;
        this.nulls = nulls;
        this.k = k;
        this.verifySize();
        this.nCol = fb.getNumColumns();
        this.nRow = fb.getNumRows();
        this.columnsIn = fb.getColumns();
        this.columnsOut = new Array[this.nCol];
    }

    private FrameBlock apply() {
        try {
            if (this.k <= 1 || this.nCol == 1 || this.containsCompressed()) {
                this.applySingleThread();
            } else {
                this.applyMultiThread();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed schema transformation", e);
        }
        boolean same = true;
        for (int i = 0; i < this.columnsIn.length && same; ++i) {
            same = this.columnsIn[i] == this.columnsOut[i];
        }
        if (same) {
            return this.fb;
        }
        String[] colNames = this.fb.getColumnNames(false);
        ColumnMetadata[] meta = this.fb.getColumnMetadata();
        FrameBlock out = new FrameBlock(this.schema, colNames, meta, this.columnsOut);
        if (LOG.isDebugEnabled()) {
            long inMem = this.fb.getInMemorySize();
            long outMem = out.getInMemorySize();
            LOG.debug((Object)String.format("Schema Apply Input Size: %16d", inMem));
            LOG.debug((Object)String.format("            Output Size: %16d", outMem));
            LOG.debug((Object)String.format("            Ratio      : %4.3f", (double)inMem / (double)outMem));
        }
        return out;
    }

    private boolean containsCompressed() {
        for (Array<?> col : this.fb.getColumns()) {
            if (!(col instanceof ACompressedArray)) continue;
            return true;
        }
        return false;
    }

    private void applySingleThread() {
        for (int i = 0; i < this.nCol; ++i) {
            this.apply(i);
        }
    }

    private void apply(int i) {
        this.columnsOut[i] = this.nulls != null ? (this.nulls[i] ? this.columnsIn[i].changeTypeWithNulls(this.schema[i]) : this.columnsIn[i].changeType(this.schema[i])) : this.columnsIn[i].changeType(this.schema[i]);
    }

    private int tryChangeType(int j, int l, int u) throws Exception {
        try {
            this.columnsIn[j].changeTypeWithNulls(this.columnsOut[j], l, u);
            return -1;
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage());
            return j;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyMultiThread() throws Exception {
        ExecutorService pool = CommonThreadPool.get(this.k);
        try {
            ArrayList<Future<Integer>> f = new ArrayList<Future<Integer>>(this.nCol);
            int rowThreads = Math.max(1, this.k * 2 / this.nCol);
            int block = Math.max(this.nRow / rowThreads / 64 * 64, PAR_ROW_THRESHOLD);
            for (int i = 0; i < this.nCol; ++i) {
                int j = i;
                if (!(this.schema[j] != this.columnsIn[i].getValueType() || this.nulls != null && this.nulls[j])) {
                    this.columnsOut[i] = this.columnsIn[i];
                    continue;
                }
                this.columnsOut[j] = ArrayFactory.allocate(this.schema[j], this.nRow, this.nulls != null && this.nulls[j]);
                for (int k = 0; k < this.nRow; k += block) {
                    int start = k;
                    int end = Math.min(this.nRow, k + block);
                    f.add(pool.submit(() -> this.tryChangeType(j, start, end)));
                }
            }
            HashMap<Integer, Future<Array>> fixes = new HashMap<Integer, Future<Array>>();
            for (Future future : f) {
                int j = (Integer)future.get();
                if (j < 0 || fixes.containsKey(j)) continue;
                fixes.put(j, pool.submit(() -> {
                    Pair<Types.ValueType, Boolean> sc = this.columnsIn[j].analyzeValueType();
                    LOG.warn((Object)("Failed to change type of column: " + j + " sample said value type: " + this.schema[j] + " Full analysis says: " + (Object)((Object)sc.getKey())));
                    Array<?> tmp = ArrayFactory.allocate(sc.getKey(), this.nRow, sc.getValue());
                    this.columnsIn[j].changeType(tmp);
                    return tmp;
                }));
            }
            for (Map.Entry entry : fixes.entrySet()) {
                this.columnsOut[((Integer)entry.getKey()).intValue()] = (Array)((Future)entry.getValue()).get();
            }
        }
        finally {
            pool.shutdown();
        }
    }

    private void verifySize() {
        if (this.schema.length != this.fb.getSchema().length) {
            throw new DMLRuntimeException("Invalid apply schema with different number of columns expected: " + this.fb.getSchema().length + " got: " + this.schema.length);
        }
    }
}

