/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.matrix.data;

import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.sysds.runtime.matrix.data.LibMatrixFourier;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.CommonThreadPool;

public class LibMatrixSTFT {
    public static MatrixBlock[] stft(MatrixBlock re, MatrixBlock im, int windowSize, int overlap, int threads) {
        int rows = re.getNumRows();
        int cols = re.getNumColumns();
        int stepSize = windowSize - overlap;
        if (stepSize == 0) {
            throw new IllegalArgumentException("windowSize - overlap is zero");
        }
        int numberOfFramesPerRow = (cols - overlap + stepSize - 1) / stepSize;
        int rowLength = numberOfFramesPerRow * windowSize;
        int out_len = rowLength * rows;
        double[] stftOutput_re = new double[out_len];
        double[] stftOutput_im = new double[out_len];
        double[] re_inter = new double[out_len];
        double[] im_inter = new double[out_len];
        ExecutorService pool = CommonThreadPool.get(threads);
        ArrayList tasks = new ArrayList();
        try {
            int h = 0;
            while (h < rows) {
                int n = h++;
                tasks.add(pool.submit(() -> {
                    for (int i = 0; i < numberOfFramesPerRow; ++i) {
                        for (int j = 0; j < windowSize; ++j) {
                            if (i * stepSize + j >= cols) continue;
                            stftOutput_re[finalH * rowLength + i * windowSize + j] = re.getDenseBlockValues()[finalH * cols + i * stepSize + j];
                            stftOutput_im[finalH * rowLength + i * windowSize + j] = im.getDenseBlockValues()[finalH * cols + i * stepSize + j];
                        }
                        LibMatrixFourier.fft_one_dim(stftOutput_re, stftOutput_im, re_inter, im_inter, finalH * rowLength + i * windowSize, finalH * rowLength + (i + 1) * windowSize, windowSize, 1);
                    }
                }));
            }
            for (Future future : tasks) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        finally {
            pool.shutdown();
        }
        return new MatrixBlock[]{new MatrixBlock(rows, rowLength, stftOutput_re), new MatrixBlock(rows, rowLength, stftOutput_im)};
    }

    public static MatrixBlock[] stft(MatrixBlock re, int windowSize, int overlap, int threads) {
        return LibMatrixSTFT.stft(re, new MatrixBlock(re.getNumRows(), re.getNumColumns(), new double[re.getNumRows() * re.getNumColumns()]), windowSize, overlap, threads);
    }
}

