/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.api.python;

import java.net.InetAddress;
import java.util.Locale;
import org.apache.spark.SparkConf;
import org.apache.spark.errors.SparkCoreErrors$;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import py4j.ClientServer;
import py4j.GatewayServer;
import scala.Function0;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001q3Q\u0001D\u0007\u0001#]A\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\u0006U\u0001!\ta\u000b\u0005\t_\u0001\u0011\r\u0011\"\u0001\u0012a!1A\b\u0001Q\u0001\nEBq!\u0010\u0001C\u0002\u0013%a\b\u0003\u0004H\u0001\u0001\u0006Ia\u0010\u0005\t\u0011\u0002\u0011\r\u0011\"\u0001\u0012\u0013\"1\u0001\u000b\u0001Q\u0001\n)CQ!\u0015\u0001\u0005\u0002ICQA\u0016\u0001\u0005\u0002]CQa\u0017\u0001\u0005\u0002I\u0013!\u0002U=5\u0015N+'O^3s\u0015\tqq\"\u0001\u0004qsRDwN\u001c\u0006\u0003!E\t1!\u00199j\u0015\t\u00112#A\u0003ta\u0006\u00148N\u0003\u0002\u0015+\u00051\u0011\r]1dQ\u0016T\u0011AF\u0001\u0004_J<7c\u0001\u0001\u0019=A\u0011\u0011\u0004H\u0007\u00025)\t1$A\u0003tG\u0006d\u0017-\u0003\u0002\u001e5\t1\u0011I\\=SK\u001a\u0004\"a\b\u0012\u000e\u0003\u0001R!!I\t\u0002\u0011%tG/\u001a:oC2L!a\t\u0011\u0003\u000f1{wmZ5oO\u0006I1\u000f]1sW\u000e{gNZ\u0002\u0001!\t9\u0003&D\u0001\u0012\u0013\tI\u0013CA\u0005Ta\u0006\u00148nQ8oM\u00061A(\u001b8jiz\"\"\u0001\f\u0018\u0011\u00055\u0002Q\"A\u0007\t\u000b\u0011\u0012\u0001\u0019\u0001\u0014\u0002\rM,7M]3u+\u0005\t\u0004C\u0001\u001a:\u001d\t\u0019t\u0007\u0005\u0002555\tQG\u0003\u00027K\u00051AH]8pizJ!\u0001\u000f\u000e\u0002\rA\u0013X\rZ3g\u0013\tQ4H\u0001\u0004TiJLgn\u001a\u0006\u0003qi\tqa]3de\u0016$\b%A\u0005m_\u000e\fG\u000e[8tiV\tq\b\u0005\u0002A\u000b6\t\u0011I\u0003\u0002C\u0007\u0006\u0019a.\u001a;\u000b\u0003\u0011\u000bAA[1wC&\u0011a)\u0011\u0002\f\u0013:,G/\u00113ee\u0016\u001c8/\u0001\u0006m_\u000e\fG\u000e[8ti\u0002\naa]3sm\u0016\u0014X#\u0001&\u0011\u0005-sU\"\u0001'\u000b\u00055\u001b\u0015\u0001\u00027b]\u001eL!a\u0014'\u0003\r=\u0013'.Z2u\u0003\u001d\u0019XM\u001d<fe\u0002\nQa\u001d;beR$\u0012a\u0015\t\u00033QK!!\u0016\u000e\u0003\tUs\u0017\u000e^\u0001\u0011O\u0016$H*[:uK:Lgn\u001a)peR,\u0012\u0001\u0017\t\u00033eK!A\u0017\u000e\u0003\u0007%sG/\u0001\u0005tQV$Hm\\<o\u0001")
public class Py4JServer
implements Logging {
    private final String secret;
    private final InetAddress localhost;
    private final Object server;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String secret() {
        return this.secret;
    }

    private InetAddress localhost() {
        return this.localhost;
    }

    public Object server() {
        return this.server;
    }

    public void start() {
        Object object = this.server();
        if (object instanceof ClientServer) {
            ClientServer clientServer = (ClientServer)object;
            clientServer.startServer();
            return;
        }
        if (object instanceof GatewayServer) {
            GatewayServer gatewayServer = (GatewayServer)object;
            gatewayServer.start();
            return;
        }
        throw SparkCoreErrors$.MODULE$.unexpectedPy4JServerError(object);
    }

    public int getListeningPort() {
        Object object = this.server();
        if (object instanceof ClientServer) {
            ClientServer clientServer = (ClientServer)object;
            return clientServer.getJavaServer().getListeningPort();
        }
        if (object instanceof GatewayServer) {
            GatewayServer gatewayServer = (GatewayServer)object;
            return gatewayServer.getListeningPort();
        }
        throw SparkCoreErrors$.MODULE$.unexpectedPy4JServerError(object);
    }

    public void shutdown() {
        Object object = this.server();
        if (object instanceof ClientServer) {
            ClientServer clientServer = (ClientServer)object;
            clientServer.shutdown();
            return;
        }
        if (object instanceof GatewayServer) {
            GatewayServer gatewayServer = (GatewayServer)object;
            gatewayServer.shutdown();
            return;
        }
        throw SparkCoreErrors$.MODULE$.unexpectedPy4JServerError(object);
    }

    public Py4JServer(SparkConf sparkConf) {
        Logging.$init$((Logging)this);
        this.secret = Utils$.MODULE$.createSecret(sparkConf);
        this.localhost = InetAddress.getLoopbackAddress();
        String string = ((String)package$.MODULE$.env().getOrElse((Object)"PYSPARK_PIN_THREAD", (Function0 & java.io.Serializable & Serializable)() -> "true")).toLowerCase(Locale.ROOT);
        String string2 = "true";
        this.server = !(string != null ? !string.equals(string2) : string2 != null) ? new ClientServer.ClientServerBuilder().authToken(this.secret()).javaPort(0).javaAddress(this.localhost()).build() : new GatewayServer.GatewayServerBuilder().authToken(this.secret()).javaPort(0).javaAddress(this.localhost()).callbackClient(25334, this.localhost(), this.secret()).build();
    }
}

