/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.panels.PathInputPanel;
import com.izforge.izpack.panels.TargetPanelAutomationHelper;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.VariableSubstitutor;
import java.util.Properties;

public class TargetPanel
extends PathInputPanel {
    private static final long serialVersionUID = 3256443616359429170L;
    private boolean noWhitespaces;

    public static String loadDefaultDirFromVariables(Properties properties) {
        String string = System.getProperty("os.name").replace(' ', '_').toLowerCase();
        String string2 = properties.getProperty("TargetPanel.dir.".concat(string));
        if (string2 == null && (string2 = properties.getProperty("TargetPanel.dir." + (OsVersion.IS_WINDOWS ? "windows" : (OsVersion.IS_OSX ? "macosx" : "unix")))) == null) {
            string2 = properties.getProperty("TargetPanel.dir");
        }
        if (string2 != null) {
            string2 = new VariableSubstitutor(properties).substitute(string2, null);
        }
        return string2;
    }

    public TargetPanel(InstallerFrame installerFrame, InstallData installData) {
        super(installerFrame, installData);
        this.loadDefaultDir();
        String string = this.getDefaultDir();
        if (string != null) {
            installData.setInstallPath(string);
        }
        this.noWhitespaces = Boolean.valueOf(installData.getVariable("TargetPanel.noWhitespaces"));
    }

    public void panelActivate() {
        super.panelActivate();
        this.pathSelectionPanel.setPath(this.idata.getInstallPath());
    }

    public void loadDefaultDir() {
        String string = TargetPanel.loadDefaultDirFromVariables(this.idata.getVariables());
        if (string != null) {
            System.out.println("Found default install dir in variables: " + string);
            TargetPanel.setDefaultInstallDir(string);
            return;
        }
        PathInputPanel.loadDefaultInstallDir(this.parent, this.idata);
    }

    public boolean isValidated() {
        if (this.noWhitespaces && this.pathSelectionPanel.getPath() != null && this.pathSelectionPanel.getPath().length() > 0 && this.pathSelectionPanel.getPath().contains(" ")) {
            this.emitError(this.parent.langpack.getString("installer.error"), this.parent.langpack.getString("PathInputPanel.noWhitespaces"));
            return false;
        }
        if (!super.isValidated()) {
            return false;
        }
        this.idata.setInstallPath(this.pathSelectionPanel.getPath());
        return true;
    }

    public String getDefaultDir() {
        return TargetPanel.getDefaultInstallDir();
    }

    public void setDefaultDir(String string) {
        TargetPanel.setDefaultInstallDir(string);
    }

    public void makeXMLData(IXMLElement iXMLElement) {
        new TargetPanelAutomationHelper().makeXMLData(this.idata, iXMLElement);
    }

    public String getSummaryBody() {
        return this.idata.getInstallPath();
    }
}

