/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.common.builder;

import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.impl.common.OMNamespaceImpl;

public final class OMNamespaceCache {
    private OMNamespace[] items = new OMNamespace[16];
    private int size;

    public OMNamespace getOMNamespace(String uri, String prefix) {
        OMNamespace ns;
        if (uri.isEmpty() && prefix.isEmpty()) {
            return null;
        }
        int index = this.index(uri, prefix);
        while ((ns = this.items[index]) != null) {
            if (ns.getNamespaceURI().equals(uri) && ns.getPrefix().equals(prefix)) {
                return ns;
            }
            if (++index != this.items.length) continue;
            index = 0;
        }
        if (this.items.length < this.size * 4 / 3) {
            OMNamespace[] oldItems = this.items;
            this.items = new OMNamespace[this.items.length * 2];
            OMNamespace[] oMNamespaceArray = oldItems;
            int n = oldItems.length;
            int n2 = 0;
            while (n2 < n) {
                OMNamespace ns2 = oMNamespaceArray[n2];
                if (ns2 != null) {
                    this.items[this.freeIndex((String)ns2.getNamespaceURI(), (String)ns2.getPrefix())] = ns2;
                }
                ++n2;
            }
            index = this.freeIndex(uri, prefix);
        }
        this.items[index] = ns = new OMNamespaceImpl(uri, prefix);
        ++this.size;
        return ns;
    }

    private int index(String uri, String prefix) {
        return (uri.hashCode() ^ prefix.hashCode()) & this.items.length - 1;
    }

    private int freeIndex(String uri, String prefix) {
        int index = this.index(uri, prefix);
        while (this.items[index] != null) {
            if (++index != this.items.length) continue;
            index = 0;
        }
        return index;
    }
}

