/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.sjavac.comp.dependencies;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openjdk.javax.tools.JavaFileManager;
import org.openjdk.javax.tools.JavaFileObject;
import org.openjdk.javax.tools.StandardLocation;
import org.openjdk.source.util.TaskEvent;
import org.openjdk.source.util.TaskListener;
import org.openjdk.tools.javac.code.Symbol;
import org.openjdk.tools.javac.code.Type;
import org.openjdk.tools.javac.util.Context;
import org.openjdk.tools.javac.util.Dependencies;
import org.openjdk.tools.javac.util.GraphUtils;
import org.openjdk.tools.sjavac.Util;
import org.openjdk.tools.sjavac.comp.JavaFileObjectWithLocation;
import org.openjdk.tools.sjavac.comp.PubAPIs;

public class NewDependencyCollector
implements TaskListener {
    private final Context context;
    private final Collection<JavaFileObject> explicitJFOs;
    private Map<String, Map<String, Set<String>>> deps;
    private Map<String, Map<String, Set<String>>> cpDeps;

    public NewDependencyCollector(Context context, Collection<JavaFileObject> collection) {
        this.context = context;
        this.explicitJFOs = collection;
    }

    @Override
    public void finished(TaskEvent taskEvent) {
        if (taskEvent.getKind() == TaskEvent.Kind.COMPILATION) {
            this.collectPubApisOfDependencies(this.context, this.explicitJFOs);
            this.deps = this.getDependencies(this.context, this.explicitJFOs, false);
            this.cpDeps = this.getDependencies(this.context, this.explicitJFOs, true);
        }
    }

    public Map<String, Map<String, Set<String>>> getDependencies(boolean bl) {
        return bl ? this.cpDeps : this.deps;
    }

    private Set<Dependencies.GraphDependencies.CompletionNode> getDependencyNodes(Context context, Collection<JavaFileObject> collection, boolean bl) {
        Dependencies.GraphDependencies graphDependencies = (Dependencies.GraphDependencies)Dependencies.GraphDependencies.instance(context);
        return graphDependencies.getNodes().stream().map(node -> (Dependencies.GraphDependencies.CompletionNode)node).filter(completionNode -> completionNode.getClassSymbol().fullname != null).filter(completionNode -> bl == collection.contains(completionNode.getClassSymbol().classfile)).collect(Collectors.toSet());
    }

    private void collectPubApisOfDependencies(Context context, Collection<JavaFileObject> collection) {
        PubAPIs pubAPIs = PubAPIs.instance(context);
        for (Dependencies.GraphDependencies.CompletionNode completionNode : this.getDependencyNodes(context, collection, false)) {
            Symbol.ClassSymbol classSymbol = completionNode.getClassSymbol().outermostClass();
            JavaFileManager.Location location = this.getLocationOf(classSymbol);
            if (location != StandardLocation.CLASS_PATH && location != StandardLocation.SOURCE_PATH) continue;
            pubAPIs.visitPubapi(classSymbol);
        }
    }

    private JavaFileManager.Location getLocationOf(Symbol.ClassSymbol classSymbol) {
        JavaFileObject javaFileObject = classSymbol.outermostClass().classfile;
        if (javaFileObject instanceof JavaFileObjectWithLocation) {
            return ((JavaFileObjectWithLocation)javaFileObject).getLocation();
        }
        return null;
    }

    private Map<String, Map<String, Set<String>>> getDependencies(Context context, Collection<JavaFileObject> collection, boolean bl) {
        HashMap<String, Map<String, Set<String>>> hashMap = new HashMap<String, Map<String, Set<String>>>();
        for (Dependencies.GraphDependencies.CompletionNode completionNode : this.getDependencyNodes(context, collection, true)) {
            HashSet<String> hashSet;
            String string = completionNode.getClassSymbol().outermostClass().flatname.toString();
            String string2 = Util.pkgNameOfClassName(string);
            HashMap hashMap2 = (HashMap)hashMap.get(string2);
            if (hashMap2 == null) {
                hashMap2 = new HashMap();
                hashMap.put(string2, hashMap2);
            }
            if ((hashSet = (HashSet<String>)hashMap2.get(string)) == null) {
                hashSet = new HashSet<String>();
                hashMap2.put(string, hashSet);
            }
            for (GraphUtils.Node<?, ?> node : this.getAllDependencies(completionNode)) {
                Dependencies.GraphDependencies.CompletionNode completionNode2 = (Dependencies.GraphDependencies.CompletionNode)node;
                if (completionNode2 == completionNode || completionNode2.getClassSymbol().fullname == null || !this.isSymbolRelevant(bl, completionNode2.getClassSymbol())) continue;
                hashSet.add(completionNode2.getClassSymbol().outermostClass().flatname.toString());
            }
            for (Symbol.ClassSymbol classSymbol : this.allSupertypes(completionNode.getClassSymbol())) {
                if (!this.isSymbolRelevant(bl, classSymbol)) continue;
                hashSet.add(classSymbol.outermostClass().flatname.toString());
            }
        }
        return hashMap;
    }

    public boolean isSymbolRelevant(boolean bl, Symbol.ClassSymbol classSymbol) {
        JavaFileManager.Location location = this.getLocationOf(classSymbol);
        StandardLocation standardLocation = bl ? StandardLocation.CLASS_PATH : StandardLocation.SOURCE_PATH;
        return location == standardLocation;
    }

    private Set<Symbol.ClassSymbol> allSupertypes(Symbol.TypeSymbol typeSymbol) {
        if (typeSymbol == null || !(typeSymbol instanceof Symbol.ClassSymbol)) {
            return Collections.emptySet();
        }
        HashSet<Symbol.ClassSymbol> hashSet = new HashSet<Symbol.ClassSymbol>();
        Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)typeSymbol;
        hashSet.add(classSymbol);
        hashSet.addAll(this.allSupertypes(classSymbol.getSuperclass().tsym));
        for (Type type : classSymbol.getInterfaces()) {
            hashSet.addAll(this.allSupertypes(type.tsym));
        }
        return hashSet;
    }

    private Collection<? extends GraphUtils.Node<?, ?>> getAllDependencies(Dependencies.GraphDependencies.CompletionNode completionNode) {
        return Stream.of(completionNode.getSupportedDependencyKinds()).flatMap(dependencyKind -> completionNode.getDependenciesByKind((GraphUtils.DependencyKind)dependencyKind).stream()).collect(Collectors.toSet());
    }
}

