/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.util;

public class StringIntSizedMap {
    public static final double DEFAULT_FILL_FRACTION = 0.4;
    public static final int DEFAULT_NOT_FOUND = Integer.MIN_VALUE;
    protected final int m_arraySize;
    protected final String[] m_keyTable;
    protected final int[] m_valueTable;
    protected final int m_notFoundValue;
    protected final int m_hitOffset;

    public StringIntSizedMap(int count, double fill, int miss) {
        if (fill <= 0.0 || fill > 0.7) {
            throw new IllegalArgumentException("Fill fraction of " + fill + " is out of allowed range");
        }
        int size = Math.max((int)((double)count / fill), 11);
        size += (size + 1) % 2;
        this.m_arraySize = size;
        this.m_keyTable = new String[size];
        this.m_valueTable = new int[size];
        for (int i = 0; i < size; ++i) {
            this.m_valueTable[i] = -1;
        }
        this.m_hitOffset = this.m_arraySize / 2;
        this.m_notFoundValue = miss;
    }

    public StringIntSizedMap(int count, int miss) {
        this(count, 0.4, miss);
    }

    public StringIntSizedMap(int count) {
        this(count, 0.4, Integer.MIN_VALUE);
    }

    private final int stepSlot(int slot) {
        return (slot + this.m_hitOffset) % this.m_arraySize;
    }

    private final int freeSlot(int slot) {
        while (this.m_keyTable[slot] != null) {
            slot = this.stepSlot(slot);
        }
        return slot;
    }

    private final int standardSlot(String key) {
        return (key.hashCode() & Integer.MAX_VALUE) % this.m_arraySize;
    }

    private int standardFind(String key) {
        int slot = this.standardSlot(key);
        while (this.m_keyTable[slot] != null) {
            if (this.m_keyTable[slot].equals(key)) {
                return slot;
            }
            slot = this.stepSlot(slot);
        }
        return -slot - 1;
    }

    public int add(String key, int value) {
        if (key == null) {
            throw new IllegalArgumentException("null key not supported");
        }
        if (value == -1) {
            throw new IllegalArgumentException("value matching not found return not supported");
        }
        int offset = this.standardFind(key);
        if (offset >= 0) {
            int prior = this.m_valueTable[offset];
            this.m_valueTable[offset] = value;
            return prior;
        }
        offset = -offset - 1;
        this.m_keyTable[offset] = key;
        this.m_valueTable[offset] = value;
        return this.m_notFoundValue;
    }

    public final boolean containsKey(String key) {
        return this.standardFind(key) >= 0;
    }

    public final int get(String key) {
        int slot = this.standardFind(key);
        if (slot >= 0) {
            return this.m_valueTable[slot];
        }
        return this.m_notFoundValue;
    }

    public void clear() {
        for (int i = 0; i < this.m_keyTable.length; ++i) {
            this.m_keyTable[i] = null;
            this.m_valueTable[i] = this.m_notFoundValue;
        }
    }
}

