/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.sjavac.comp;

import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.openjdk.tools.javac.main.Main;
import org.openjdk.tools.sjavac.Log;
import org.openjdk.tools.sjavac.server.Sjavac;

public class PooledSjavac
implements Sjavac {
    final Sjavac delegate;
    final ExecutorService pool;

    public PooledSjavac(Sjavac sjavac, int n) {
        Objects.requireNonNull(sjavac);
        this.delegate = sjavac;
        this.pool = Executors.newFixedThreadPool(n);
    }

    @Override
    public Main.Result compile(String[] stringArray) {
        Log log = Log.get();
        try {
            return this.pool.submit(() -> {
                Log.setLogForCurrentThread(log);
                return this.delegate.compile(stringArray);
            }).get();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Error during compile", exception);
        }
    }

    @Override
    public void shutdown() {
        Log.debug("Shutting down PooledSjavac");
        this.pool.shutdown();
        try {
            if (!this.pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.pool.shutdownNow();
                if (!this.pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                    Log.error("ThreadPool did not terminate");
                }
            }
        }
        catch (InterruptedException interruptedException) {
            this.pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
        this.delegate.shutdown();
    }
}

