/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.cpc;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Arrays;
import org.apache.datasketches.cpc.BitMatrix;
import org.apache.datasketches.cpc.CompressedState;
import org.apache.datasketches.cpc.CompressionCharacterization;
import org.apache.datasketches.cpc.CpcSketch;
import org.apache.datasketches.cpc.MergingValidation;
import org.apache.datasketches.cpc.QuickMergingValidation;
import org.apache.datasketches.cpc.StreamingValidation;
import org.apache.datasketches.cpc.TestUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAllTest {
    private PrintStream ps = null;
    private PrintWriter pw = null;

    @Test
    public void streamingCheck() {
        int lgMinK = 10;
        int lgMaxK = 10;
        int trials = 10;
        int ppoN = 1;
        StreamingValidation sVal = new StreamingValidation(lgMinK, lgMaxK, trials, ppoN, this.ps, this.pw);
        sVal.start();
    }

    @Test
    public void matrixCouponCountCheck() {
        long pat = -6510615556690126246L;
        int len = 16;
        long[] arr = new long[len];
        Arrays.fill(arr, pat);
        long trueCount = (long)len * (long)Long.bitCount(pat);
        long testCount = BitMatrix.countCoupons((long[])arr);
        Assert.assertEquals((long)testCount, (long)trueCount);
    }

    @Test
    public void compressionCharacterizationCheck() {
        int lgMinK = 10;
        int lgMaxK = 10;
        int lgMaxT = 5;
        int lgMinT = 2;
        int lgMulK = 7;
        int uPPO = 1;
        int incLgK = 1;
        CompressionCharacterization cc = new CompressionCharacterization(lgMinK, lgMaxK, lgMinT, lgMaxT, lgMulK, uPPO, incLgK, this.ps, this.pw);
        cc.start();
    }

    public void singleRowColCheck() {
        int lgK = 20;
        CpcSketch srcSketch = new CpcSketch(lgK);
        int rowCol = 54746379;
        srcSketch.rowColUpdate(rowCol);
        this.ps.println(srcSketch.toString(true));
        CompressedState state = CompressedState.compress((CpcSketch)srcSketch);
        this.ps.println(CompressedState.toString((CompressedState)state, (boolean)true));
        CpcSketch uncSketch = CpcSketch.uncompress((CompressedState)state, (long)9001L);
        this.ps.println(uncSketch.toString(true));
    }

    @Test
    public void mergingValidationCheck() {
        int lgMinK = 10;
        int lgMaxK = 10;
        int lgMulK = 5;
        int uPPO = 1;
        int incLgK = 1;
        MergingValidation mv = new MergingValidation(lgMinK, lgMaxK, lgMulK, uPPO, incLgK, this.ps, this.pw);
        mv.start();
    }

    @Test
    public void quickMergingValidationCheck() {
        int lgMinK = 10;
        int lgMaxK = 10;
        int incLgK = 1;
        QuickMergingValidation qmv = new QuickMergingValidation(lgMinK, lgMaxK, incLgK, this.ps, this.pw);
        qmv.start();
    }

    @Test
    public void checkPwrLaw10NextDouble() {
        double next = TestUtil.pwrLaw10NextDouble((int)1, (double)10.0);
        Assert.assertEquals((double)next, (double)100.0);
    }
}

