/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.lang.foreign.Arena;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.Resource;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantiles.DirectUpdateDoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DirectQuantilesMemoryRequestTest {
    @Test
    public void checkLimitedMemoryScenarios() {
        WritableMemory wmem;
        int k = 128;
        int u = 5120;
        int initBytes = 2080;
        WritableMemory wmem2 = wmem = WritableMemory.allocateDirect((long)2080L, (Arena)Arena.ofConfined());
        DirectQuantilesMemoryRequestTest.println("Initial mem size: " + wmem.getCapacity());
        UpdateDoublesSketch usk = DoublesSketch.builder().setK(128).build(wmem);
        Assert.assertTrue((boolean)usk.isEmpty());
        for (int i = 0; i < 5120; ++i) {
            usk.update((double)i);
        }
        double result = usk.getQuantile(0.5);
        DirectQuantilesMemoryRequestTest.println("Result: " + result);
        Assert.assertEquals((double)result, (double)2560.0, (double)256.0);
        DirectQuantilesMemoryRequestTest.println("\nFinal mem size: " + wmem.getCapacity());
        Assert.assertFalse((boolean)wmem2.isAlive());
    }

    @Test
    public void checkGrowBaseBuf() {
        WritableMemory wmem;
        int k = 128;
        int u = 32;
        int initBytes = 160;
        WritableMemory wmem2 = wmem = WritableMemory.allocateDirect((long)160L, (Arena)Arena.ofConfined());
        DirectQuantilesMemoryRequestTest.println("Initial mem size: " + wmem.getCapacity());
        UpdateDoublesSketch usk1 = DoublesSketch.builder().setK(128).build(wmem);
        for (int i = 1; i <= 32; ++i) {
            usk1.update((double)i);
        }
        int currentSpace = usk1.getCombinedBufferItemCapacity();
        DirectQuantilesMemoryRequestTest.println("curCombBufItemCap: " + currentSpace);
        Assert.assertEquals((int)currentSpace, (int)256);
        Assert.assertFalse((boolean)wmem2.isAlive());
    }

    @Test
    public void checkGrowCombBuf() {
        WritableMemory wmem;
        int k = 128;
        int u = 255;
        int initBytes = 2080;
        WritableMemory wmem2 = wmem = WritableMemory.allocateDirect((long)2080L, (Arena)Arena.ofConfined());
        DirectQuantilesMemoryRequestTest.println("Initial mem size: " + wmem.getCapacity());
        UpdateDoublesSketch usk1 = DoublesSketch.builder().setK(128).build(wmem);
        for (int i = 1; i <= 255; ++i) {
            usk1.update((double)i);
        }
        int currentSpace = usk1.getCombinedBufferItemCapacity();
        DirectQuantilesMemoryRequestTest.println("curCombBufItemCap: " + currentSpace);
        double[] newCB = usk1.growCombinedBuffer(currentSpace, 384);
        int newSpace = usk1.getCombinedBufferItemCapacity();
        DirectQuantilesMemoryRequestTest.println("newCombBurItemCap: " + newSpace);
        Assert.assertEquals((int)newCB.length, (int)384);
        Assert.assertFalse((boolean)wmem2.isAlive());
    }

    @Test
    public void checkUpdatableStorageBytes() {
        int k = 16;
        int initBytes = DoublesSketch.getUpdatableStorageBytes((int)16, (long)1L);
        DirectQuantilesMemoryRequestTest.println("Predicted Updatable Storage Bytes: " + initBytes);
        UpdateDoublesSketch usk1 = DoublesSketch.builder().setK(16).build();
        usk1.update(1.0);
        byte[] uarr = usk1.toByteArray();
        DirectQuantilesMemoryRequestTest.println("Actual Storage Bytes " + uarr.length);
        Assert.assertEquals((int)initBytes, (int)uarr.length);
        Assert.assertEquals((int)initBytes, (int)64);
    }

    @Test
    public void checkGrowFromWrappedEmptySketch() {
        WritableMemory wmem;
        int k = 16;
        boolean n = false;
        int initBytes = DoublesSketch.getUpdatableStorageBytes((int)16, (long)0L);
        UpdateDoublesSketch usk1 = DoublesSketch.builder().setK(16).build();
        Memory origSketchMem = Memory.wrap((byte[])usk1.toByteArray());
        WritableMemory wmem2 = wmem = WritableMemory.allocateDirect((long)initBytes, (Arena)Arena.ofConfined());
        origSketchMem.copyTo(0L, wmem, 0L, (long)initBytes);
        DirectUpdateDoublesSketch usk2 = DirectUpdateDoublesSketch.wrapInstance((WritableMemory)wmem);
        Assert.assertTrue((boolean)wmem.isSameResource((Resource)usk2.getMemory()));
        Assert.assertEquals((long)wmem.getCapacity(), (long)initBytes);
        Assert.assertTrue((boolean)wmem.isDirect());
        Assert.assertTrue((boolean)usk2.isEmpty());
        usk2.update(1.0);
        Assert.assertEquals((long)usk2.getN(), (long)1L);
        WritableMemory mem2 = usk2.getMemory();
        Assert.assertFalse((boolean)wmem.isSameResource((Resource)mem2));
        Assert.assertFalse((boolean)mem2.isDirect());
        int expectedSize = 288;
        Assert.assertEquals((long)mem2.getCapacity(), (long)288L);
        Assert.assertFalse((boolean)wmem2.isAlive());
    }

    @Test
    public void printlnTest() {
        DirectQuantilesMemoryRequestTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

